/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum PostalAddressUse implements ValueSetEnumInterface
{
    BAD_ADDRESS("BAD", "2.16.840.1.113883.5.1119", "bad address", "bad address", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    CONFIDENTIAL("CONF", "2.16.840.1.113883.5.1119", "confidential", "confidential", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DIRECT("DIR", "2.16.840.1.113883.5.1119", "direct", "direct", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    HOME_ADDRESS("H", "2.16.840.1.113883.5.1119", "home address", "home address", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PHYSICAL_VISIT_ADDRESS("PHYS", "2.16.840.1.113883.5.1119", "physical visit address", "physical visit address", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    POSTAL_ADDRESS("PST", "2.16.840.1.113883.5.1119", "postal address", "postal address", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PRIMARY_HOME("HP", "2.16.840.1.113883.5.1119", "primary home", "primary home", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PUBLIC("PUB", "2.16.840.1.113883.5.1119", "public", "public", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    TEMPORARY("TMP", "2.16.840.1.113883.5.1119", "temporary", "temporary", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    VACATION_HOME("HV", "2.16.840.1.113883.5.1119", "vacation home", "vacation home", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    WORK_PLACE("WP", "2.16.840.1.113883.5.1119", "work place", "work place", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String BAD_ADDRESS_CODE = "BAD";
    public static final String CONFIDENTIAL_CODE = "CONF";
    public static final String DIRECT_CODE = "DIR";
    public static final String HOME_ADDRESS_CODE = "H";
    public static final String PHYSICAL_VISIT_ADDRESS_CODE = "PHYS";
    public static final String POSTAL_ADDRESS_CODE = "PST";
    public static final String PRIMARY_HOME_CODE = "HP";
    public static final String PUBLIC_CODE = "PUB";
    public static final String TEMPORARY_CODE = "TMP";
    public static final String VACATION_HOME_CODE = "HV";
    public static final String WORK_PLACE_CODE = "WP";
    public static final String VALUE_SET_ID = "2.16.840.1.113883.1.11.10637";
    public static final String VALUE_SET_NAME = "PostalAddressUse";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.5.1119";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable PostalAddressUse getEnum(@Nullable String code) {
        for (PostalAddressUse x : PostalAddressUse.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(PostalAddressUse.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (PostalAddressUse x : PostalAddressUse.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private PostalAddressUse(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    @Override
    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    @Override
    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    @Override
    public @NonNull String getCodeValue() {
        return this.code;
    }

    @Override
    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    @Override
    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    @Override
    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

