/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.enums;

import java.util.EnumMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ObservationInterpretation implements ValueSetEnumInterface
{
    ABNORMAL("A", "Abnormal", "Anormal", "Anormalement", "Anormalmente"),
    ABNORMAL_ALERT("AA", "Abnormal alert", "Anormal alarmierend", "Alerte anormale", "Avviso anomalo"),
    HIGH("H", "High", "Hoch", "Haut", "Alto"),
    HIGH_ALERT("HH", "High alert", "Hoch alarmierend", "Alerte haut", "Allarme alto"),
    LOW("L", "Low", "Tief", "Bas", "Basso"),
    LOW_ALERT("LL", "Low alert", "Tief alarmierend", "Alerte bas", "Allarme basso"),
    NORMAL("N", "Normal", "Normal", "Normal", "Normale"),
    POS("POS", "Positive", "Positiv", "Positif", "Positivo"),
    NEG("NEG", "Negative", "Negativ", "N\u00e9gatif", "Negativo"),
    SUSCEPTIBLE("S", "Susceptible", "Sensibel", "Sensible", "Sensitivo"),
    SUSCEPTIBLE_DOSE_DEPENDENT("SDD", "Susceptible-dose dependent", "Sensibel", "Sensibel (dosierungsabh\u00e4ngig)", "Sensitivo (dose-dipendente)"),
    RESISTANT("R", "Resistant", "Resistent", "R\u00e9sistant", "Resistente"),
    INTERMEDIATE("I", "Intermediate", "Intermedi\u00e4r", "Interm\u00e9diaire", "Intermedio");

    public static final String CODE_SYSTEM_NAME = "HL7ObservationInterpretation";
    public static final String CODE_SYSTEM_OID = "2.16.840.1.113883.5.83";
    private Map<LanguageCode, String> displayNames;
    private String code;

    public static ObservationInterpretation getEnum(String code) {
        for (ObservationInterpretation x : ObservationInterpretation.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ObservationInterpretation.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(String codeValue) {
        for (ObservationInterpretation x : ObservationInterpretation.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ObservationInterpretation(String code, String displayNameEn, String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = code;
        this.displayNames = new EnumMap<LanguageCode, String>(LanguageCode.class);
        this.displayNames.put(LanguageCode.ENGLISH, displayNameEn);
        this.displayNames.put(LanguageCode.GERMAN, displayNameDe);
        this.displayNames.put(LanguageCode.FRENCH, displayNameFr);
        this.displayNames.put(LanguageCode.ITALIAN, displayNameIt);
    }

    @Override
    public String getCodeSystemName() {
        return CODE_SYSTEM_NAME;
    }

    @Override
    public @NonNull String getCodeSystemId() {
        return CODE_SYSTEM_OID;
    }

    @Override
    public String getCodeValue() {
        return this.code;
    }

    @Override
    public String getDisplayName() {
        return this.getDisplayName(LanguageCode.ENGLISH);
    }

    @Override
    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        String displayNameL = null;
        displayNameL = languageCode != null && this.displayNames.get((Object)languageCode) != null ? this.displayNames.get((Object)languageCode) : this.displayNames.get((Object)LanguageCode.GERMAN);
        return displayNameL;
    }

    @Override
    public @NonNull String getValueSetId() {
        return CODE_SYSTEM_OID;
    }

    @Override
    public @NonNull String getValueSetName() {
        return CODE_SYSTEM_NAME;
    }
}

