/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum NullFlavor implements ValueSetEnumInterface
{
    ASKED_BUT_UNKNOWN_L2("ASKU", "2.16.840.1.113883.5.1008", "asked but unknown", "asked but unknown", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    DERIVED_L2("DER", "2.16.840.1.113883.5.1008", "derived", "derived", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    INVALID_L1("INV", "2.16.840.1.113883.5.1008", "invalid", "invalid", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    MASKED_L1("MSK", "2.16.840.1.113883.5.1008", "masked", "masked", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NEGATIVE_INFINITY_L3("NINF", "2.16.840.1.113883.5.1008", "negative infinity", "negative infinity", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NOINFORMATION("NI", "2.16.840.1.113883.5.1008", "NoInformation", "NoInformation", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NOT_APPLICABLE_L1("NA", "2.16.840.1.113883.5.1008", "not applicable", "not applicable", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NOT_ASKED_L2("NASK", "2.16.840.1.113883.5.1008", "not asked", "not asked", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    NOT_AVAILABLE_L2("NAVU", "2.16.840.1.113883.5.1008", "Not available", "Not available", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    OTHER_L2("OTH", "2.16.840.1.113883.5.1008", "other", "other", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    POSITIVE_INFINITY_L3("PINF", "2.16.840.1.113883.5.1008", "positive infinity", "positive infinity", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SUFFICIENT_QUANTITY_L2("QS", "2.16.840.1.113883.5.1008", "Sufficient Quantity", "Sufficient Quantity", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    TEMPORARILY_UNAVAILABLE_L3("NAV", "2.16.840.1.113883.5.1008", "temporarily unavailable", "temporarily unavailable", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    TRACE_L2("TRC", "2.16.840.1.113883.5.1008", "trace", "trace", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    UNKNOWN_L1("UNK", "2.16.840.1.113883.5.1008", "unknown", "unknown", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    UN_ENCODED_L2("UNC", "2.16.840.1.113883.5.1008", "un-encoded", "un-encoded", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String ASKED_BUT_UNKNOWN_L2_CODE = "ASKU";
    public static final String DERIVED_L2_CODE = "DER";
    public static final String INVALID_L1_CODE = "INV";
    public static final String MASKED_L1_CODE = "MSK";
    public static final String NEGATIVE_INFINITY_L3_CODE = "NINF";
    public static final String NOINFORMATION_CODE = "NI";
    public static final String NOT_APPLICABLE_L1_CODE = "NA";
    public static final String NOT_ASKED_L2_CODE = "NASK";
    public static final String NOT_AVAILABLE_L2_CODE = "NAVU";
    public static final String OTHER_L2_CODE = "OTH";
    public static final String POSITIVE_INFINITY_L3_CODE = "PINF";
    public static final String SUFFICIENT_QUANTITY_L2_CODE = "QS";
    public static final String TEMPORARILY_UNAVAILABLE_L3_CODE = "NAV";
    public static final String TRACE_L2_CODE = "TRC";
    public static final String UNKNOWN_L1_CODE = "UNK";
    public static final String UN_ENCODED_L2_CODE = "UNC";
    public static final String VALUE_SET_ID = "2.16.840.1.113883.1.11.10609";
    public static final String VALUE_SET_NAME = "NullFlavor";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.5.1008";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable NullFlavor getEnum(@Nullable String code) {
        for (NullFlavor x : NullFlavor.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(NullFlavor.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (NullFlavor x : NullFlavor.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private NullFlavor(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    @Override
    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    @Override
    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    @Override
    public @NonNull String getCodeValue() {
        return this.code;
    }

    @Override
    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    @Override
    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    @Override
    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

