/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.enums;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum NameQualifier implements ValueSetEnumInterface
{
    ACADEMIC("AC", "Academic");

    public static final String CODE_SYSTEM_NAME = "NameQualifier";
    public static final String CODE_SYSTEM_OID = "2.16.840.1.113883.5.1119";
    private String code;
    private String displayName;

    public static NameQualifier getEnum(String code) {
        for (NameQualifier x : NameQualifier.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(NameQualifier.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(String codeValue) {
        for (NameQualifier x : NameQualifier.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private NameQualifier(String code, String displayName) {
        this.code = code;
        this.displayName = displayName;
    }

    @Override
    public String getCodeSystemName() {
        return CODE_SYSTEM_NAME;
    }

    @Override
    public @NonNull String getCodeSystemId() {
        return CODE_SYSTEM_OID;
    }

    @Override
    public String getCodeValue() {
        return this.code;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        return this.getDisplayName();
    }

    @Override
    public @NonNull String getValueSetId() {
        return CODE_SYSTEM_OID;
    }

    @Override
    public @NonNull String getValueSetName() {
        return CODE_SYSTEM_NAME;
    }
}

