/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.enums;

import org.apache.commons.lang3.EnumUtils;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.model.Code;

public enum LanguageCode {
    ENGLISH("en", "English"),
    FRENCH("fr-CH", "French"),
    GERMAN("de-CH", "German"),
    ITALIAN("it-CH", "Italian"),
    ROMANSH("rm-CH", "Romansh");

    public static final String CODE_SYSTEM_NAME = "";
    public static final String CODE_SYSTEM_OID = "ISO 3166";
    public static final String ENGLISH_CODE = "en";
    public static final String FRENCH_CODE = "fr-CH";
    public static final String GERMAN_CODE = "de-CH";
    public static final String ITALIAN_CODE = "it-CH";
    public static final String ROMANSH_CODE = "rm-CH";
    private String code;
    private String displayName;

    public static LanguageCode getEnum(String code) {
        for (LanguageCode aLanguage : EnumUtils.getEnumList(LanguageCode.class)) {
            if (!aLanguage.getCodeValue().equalsIgnoreCase(code)) continue;
            return aLanguage;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        return EnumUtils.isValidEnum(LanguageCode.class, (String)enumName);
    }

    public static boolean isInValueSet(String codeValue) {
        for (LanguageCode aLang : EnumUtils.getEnumList(LanguageCode.class)) {
            if (!aLang.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private LanguageCode(String code, String displayName) {
        this.code = code;
        this.displayName = displayName;
    }

    public Code getCode() {
        return new Code(this.code, CODE_SYSTEM_OID, this.displayName);
    }

    public String getCodeSystemName() {
        return CODE_SYSTEM_NAME;
    }

    public String getCodeSystemOid() {
        return CODE_SYSTEM_OID;
    }

    public String getCodeValue() {
        return this.code;
    }

    public CS getCS() {
        CS cs = new CS();
        cs.setCode(this.code);
        return cs;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

