/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.enums;

import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.model.Code;

public enum Isco08 {
    MEDICAL_DOCTORS("221", "Medical doctors"),
    MEDICAL_AND_PATHOLOGY_LABORATORY_TECHNICIANS("3212", "Medical and pathology laboratory technicians");

    public static final String CODE_SYSTEM_NAME = "ISCO-08";
    public static final String CODE_SYSTEM_OID = "2.16.840.1.113883.2.9.6.2.7";
    private String code;
    private String displayName;

    public static Isco08 getEnum(String code) {
        for (Isco08 x : Isco08.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(Isco08.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(String codeValue) {
        for (Isco08 x : Isco08.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private Isco08(String code, String displayName) {
        this.code = code;
        this.displayName = displayName;
    }

    public CE getCE() {
        CE ce = new CE();
        ce.setCodeSystem(CODE_SYSTEM_OID);
        ce.setCodeSystemName(CODE_SYSTEM_NAME);
        ce.setCode(this.code);
        ce.setDisplayName(this.displayName);
        return ce;
    }

    public Code getCode() {
        Code ehcCode = new Code();
        ehcCode.setCode(this.code);
        ehcCode.setCodeSystem(CODE_SYSTEM_NAME);
        ehcCode.setDisplayName(this.displayName);
        return ehcCode;
    }

    public String getCodeSystemName() {
        return CODE_SYSTEM_NAME;
    }

    public String getCodeSystemOid() {
        return CODE_SYSTEM_OID;
    }

    public String getCodeValue() {
        return this.code;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

