/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.enums;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum GeneralAddressUse implements ValueSetEnumInterface
{
    BAD("BAD", "bad address"),
    BUSINESS("WP", "work place"),
    BUSINESS_DIRECT("DIR", "direct"),
    CONFIDENTIAL("CONF", "confidential address"),
    OLD("OLD", "no longer in use"),
    PRIVATE("H", "home address"),
    PRIVATE_PRIMARY("HP", "primary home"),
    PRIVATE_VACATION("HV", "vacation home"),
    PUBLIC("PUB", "public"),
    TEMPORARY("TMP", "temporary address");

    public static final String CODE_SYSTEM_NAME = "AddressUse";
    public static final String CODE_SYSTEM_OID = "2.16.840.1.113883.5.1119";
    private String code;
    private String displayName;

    public static GeneralAddressUse getEnum(String code) {
        for (GeneralAddressUse x : GeneralAddressUse.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(GeneralAddressUse.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(String codeValue) {
        for (GeneralAddressUse x : GeneralAddressUse.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private GeneralAddressUse(String code, String displayName) {
        this.code = code;
        this.displayName = displayName;
    }

    @Override
    public String getCodeSystemName() {
        return CODE_SYSTEM_NAME;
    }

    @Override
    public String getCodeSystemId() {
        return CODE_SYSTEM_OID;
    }

    @Override
    public String getCodeValue() {
        return this.code;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        return this.getDisplayName();
    }

    @Override
    public @NonNull String getValueSetId() {
        return CODE_SYSTEM_OID;
    }

    @Override
    public @NonNull String getValueSetName() {
        return CODE_SYSTEM_NAME;
    }
}

