/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum EntityNameUse implements ValueSetEnumInterface
{
    ALPHABETIC_L1("ABC", "2.16.840.1.113883.5.45", "Alphabetic", "Alphabetic", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ARTIST_STAGE_L1("A", "2.16.840.1.113883.5.45", "Artist/Stage", "Artist/Stage", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    ASSIGNED("ASGN", "2.16.840.1.113883.5.45", "assigned", "assigned", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    IDEOGRAPHIC_L1("IDE", "2.16.840.1.113883.5.45", "Ideographic", "Ideographic", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    INDIGENOUS_TRIBAL("I", "2.16.840.1.113883.5.45", "Indigenous/Tribal", "Indigenous/Tribal", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    LEGAL("L", "2.16.840.1.113883.5.45", "Legal", "Legal", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    LICENSE("C", "2.16.840.1.113883.5.45", "License", "License", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    OFFICIAL_REGISTRY_L1("OR", "2.16.840.1.113883.5.45", "official registry", "official registry", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PHONETIC_L1("PHON", "2.16.840.1.113883.5.45", "phonetic", "phonetic", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    PSEUDONYM("P", "2.16.840.1.113883.5.45", "pseudonym", "pseudonym", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    RELIGIOUS("R", "2.16.840.1.113883.5.45", "Religious", "Religious", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SEARCH_V_HL7SEARCHUSE("SRCH", "2.16.840.1.113883.5.45", "search v:HL7SearchUse", "search v:HL7SearchUse", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SOUNDEX_L1("SNDX", "2.16.840.1.113883.5.45", "Soundex", "Soundex", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE"),
    SYLLABIC_L1("SYL", "2.16.840.1.113883.5.45", "Syllabic", "Syllabic", "TOTRANSLATE", "TOTRANSLATE", "TOTRANSLATE");

    public static final String ALPHABETIC_L1_CODE = "ABC";
    public static final String ARTIST_STAGE_L1_CODE = "A";
    public static final String ASSIGNED_CODE = "ASGN";
    public static final String IDEOGRAPHIC_L1_CODE = "IDE";
    public static final String INDIGENOUS_TRIBAL_CODE = "I";
    public static final String LEGAL_CODE = "L";
    public static final String LICENSE_CODE = "C";
    public static final String OFFICIAL_REGISTRY_L1_CODE = "OR";
    public static final String PHONETIC_L1_CODE = "PHON";
    public static final String PSEUDONYM_CODE = "P";
    public static final String RELIGIOUS_CODE = "R";
    public static final String SEARCH_V_HL7SEARCHUSE_CODE = "SRCH";
    public static final String SOUNDEX_L1_CODE = "SNDX";
    public static final String SYLLABIC_L1_CODE = "SYL";
    public static final String VALUE_SET_ID = "1.2.40.0.34.10.27";
    public static final String VALUE_SET_NAME = "ELGA_EntityNameUse";
    public static final String CODE_SYSTEM_ID = "2.16.840.1.113883.5.45";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable EntityNameUse getEnum(@Nullable String code) {
        for (EntityNameUse x : EntityNameUse.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(EntityNameUse.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (EntityNameUse x : EntityNameUse.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private EntityNameUse(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    @Override
    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    @Override
    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum(this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    @Override
    public @NonNull String getCodeValue() {
        return this.code;
    }

    @Override
    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    @Override
    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    @Override
    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

