/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.enums;

import org.apache.commons.lang3.EnumUtils;
import org.projecthusky.common.hl7cdar2.CS;
import org.projecthusky.common.model.Code;

public enum CountryCode {
    AUSTRIA("AT", "AUT", "Austria"),
    SWITZERLAND("CH", "CHE", "Switzerland");

    public static final String CODE_SYSTEM_NAME = "ISO 3166-1 alpha-3";
    public static final String CODE_SYSTEM_OID = "1.0.3166.2.2.3";
    private String codeAlpha2;
    private String codeAlpha3;
    private String displayName;

    public static CountryCode getEnum(String code) {
        for (CountryCode aLanguage : EnumUtils.getEnumList(CountryCode.class)) {
            if (!aLanguage.getCodeAlpha3().equalsIgnoreCase(code)) continue;
            return aLanguage;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        return EnumUtils.isValidEnum(CountryCode.class, (String)enumName);
    }

    public static boolean isInValueSet(String codeValue) {
        for (CountryCode aLang : EnumUtils.getEnumList(CountryCode.class)) {
            if (!aLang.getCodeAlpha3().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private CountryCode(String codeAlpha2, String codeAlpha3, String displayName) {
        this.codeAlpha2 = codeAlpha2;
        this.codeAlpha3 = codeAlpha3;
        this.displayName = displayName;
    }

    public Code getCode() {
        return new Code(this.codeAlpha3, CODE_SYSTEM_OID, this.displayName);
    }

    public String getCodeAlpha2() {
        return this.codeAlpha2;
    }

    public String getCodeAlpha3() {
        return this.codeAlpha3;
    }

    public String getCodeSystemName() {
        return CODE_SYSTEM_NAME;
    }

    public String getCodeSystemOid() {
        return CODE_SYSTEM_OID;
    }

    public CS getCS() {
        CS cs = new CS();
        cs.setCode(this.codeAlpha3);
        return cs;
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

