/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.enums;

import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ConfidentialityCode implements ValueSetEnumInterface
{
    LOW("L", "2.16.840.1.113883.5.25", "low"),
    MODERATE("M", "2.16.840.1.113883.5.25", "moderate"),
    NORMAL("N", "2.16.840.1.113883.5.25", "normal"),
    RESTRICTED("R", "2.16.840.1.113883.5.25", "restricted"),
    UNRESTRICTED("U", "2.16.840.1.113883.5.25", "unestricted"),
    VERY_RESTRICTED("V", "2.16.840.1.113883.5.25", "very restricted");

    private String code;
    private String displayName;
    private String oid;

    public static ConfidentialityCode getEnum(String code) {
        for (ConfidentialityCode x : ConfidentialityCode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ConfidentialityCode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(String codeValue) {
        for (ConfidentialityCode x : ConfidentialityCode.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ConfidentialityCode(String code, String oid, String displayName) {
        this.code = code;
        this.displayName = displayName;
        this.oid = oid;
    }

    @Override
    public String getCodeValue() {
        return this.code;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public @NonNull String getCodeSystemId() {
        return this.oid;
    }

    @Override
    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        return this.getDisplayName();
    }

    @Override
    public @NonNull String getValueSetId() {
        return "2.16.840.1.113883.5.25";
    }

    @Override
    public @NonNull String getValueSetName() {
        return "Confidentiality";
    }

    @Override
    public @NonNull String getCodeSystemName() {
        return "Confidentiality";
    }
}

