/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.enums;

import org.projecthusky.common.model.IdentityDomain;

public enum CodeSystems implements IdentityDomain
{
    ICR_DHA_08040_DISEASE("2.16.756.5.30.1.127.3.1.20080401.1", "diseaseName (ICR-DHA, chapter 2.1.1)"),
    GLN("2.51.1.3", "Global Location Number"),
    GTIN("2.51.1.1", "Global Trade Item Number"),
    SWISS_INDEX("2.16.756.5.30.2.6.1", "SwissINDEX"),
    WHO_ATC_CODE("2.16.840.1.113883.6.73", "WHO ATC Code"),
    SWISS_AL("2.16.756.5.30.1.129.1.3", "Swiss analysis list (AL)"),
    SWISS_TARMED("2.16.756.5.30.1.129.1.4", "Swiss Tarmed"),
    SWISS_SSN("2.16.756.5.32", "AHV Nummer (die Neue)"),
    SWISS_ZSR("2.16.756.5.30.1.123.100.2.1.1", "ZSR Nummer der SASIS"),
    SWISS_SSN_DEPRECATED("2.16.756.5.31", "AHV Nummer (die Alte)"),
    SWISS_VEKA_NR("2.16.756.5.30.1.123.100.1.1.1", "Kartennummern f\u00fcr die Versichertenkarte (VeKa)"),
    ICD10("2.16.756.5.30.1.126.3.2", "ICD-10"),
    LANGUAGE_CODE("2.16.840.1.113883.6.121", "Language Code"),
    CONFIDENTIALITY_CODE("2.16.840.1.113883.5.25", "Confidentiality Code"),
    ADMINISTRATIVE_GENDER("2.16.840.1.113883.5.1", "HL7 AdministrativeGender"),
    ADDRESS_USE("2.16.840.1.113883.5.1119", "AddressUse"),
    PARTICIPANT_SIGNATURE("2.16.840.1.113883.5.89", "ParticipationSignature"),
    ACT_STATUS("2.16.840.1.113883.5.14", "ActStatus"),
    SNOMEDCT("2.16.840.1.113883.6.96", "SNOMED CT"),
    RISC_OF_COMPLICATIONS("2.16.756.5.30.1.127.3.3.2013.1", "Komplikationsrisiken"),
    RISC_OF_EXPOSURE("2.16.756.5.30.1.127.3.3.2015.2", "Expositionsrisiken"),
    HL7_ACT_CODE("2.16.840.1.113883.5.4", "HL7ActCode"),
    HL7_SEVERITY_OBSERVATION("2.16.840.1.113883.5.1063", "HL7SeverityObservation"),
    HL7_ROUTE_OF_ADMINISTRATION("2.16.840.1.113883.5.112", "HL7RouteOfAdministration"),
    LOINC("2.16.840.1.113883.6.1", "LOINC"),
    HL7_OBSERVATION_INTERPRETATION("2.16.840.1.113883.5.83", "HL7ObservationInterpretation"),
    HL7_NULL_FLAVOR("2.16.840.1.113883.5.1008", "HL7nullFlavor"),
    WHO_D_D_MED_PPROD_ID("2.16.840.1.113883.6.294", "WHO Drug Dictionary Medicinal Product ID"),
    SWISS_SOAS_HLA_CODES("2.16.756.5.30.1.129.1.1.8", "Swiss SOAS HLA"),
    SWISS_PLRR_DHA_LAB_OBS_LIST("2.16.756.5.30.1.127.3.2.20121101.2", "Swiss PLRR-DHA LabObsList"),
    SWISS_EPR_SPID("2.16.756.5.30.1.127.3.10.3", "Swiss EPR-SPID"),
    PARTICIPATION_FUNCTION("2.16.840.1.113883.5.88", "Participation Function");

    private String codeSystem;
    private String codeSystemName;

    public static CodeSystems getEnum(String codeSystemId) {
        for (CodeSystems x : CodeSystems.values()) {
            if (!x.getCodeSystemId().equals(codeSystemId)) continue;
            return x;
        }
        return null;
    }

    private CodeSystems(String oid, String name) {
        this.codeSystem = oid;
        this.codeSystemName = name;
    }

    @Override
    public String getCodeSystemId() {
        return this.codeSystem;
    }

    @Override
    public String getCodeSystemName() {
        return this.codeSystemName;
    }
}

