/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.communication;

import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.SubmissionSet;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.projecthusky.common.communication.CDAR2Extractor;
import org.projecthusky.common.hl7cdar2.POCDMT000040ClinicalDocument;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.model.Author;
import org.projecthusky.common.model.Code;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.utils.XdsMetadataUtil;

public class SubmissionSetMetadata {
    private final POCDMT000040ClinicalDocument cda;
    private SubmissionSet s;

    public SubmissionSetMetadata() {
        this.s = new SubmissionSet();
        this.cda = new POCDMT000040ClinicalDocument();
    }

    public SubmissionSetMetadata(SubmissionSet submissionSet) {
        this.s = submissionSet;
        this.cda = new POCDMT000040ClinicalDocument();
    }

    public List<Author> getAuthor() {
        LinkedList<Author> authors = new LinkedList<Author>();
        for (org.openehealth.ipf.commons.ihe.xds.core.metadata.Author author : this.s.getAuthors()) {
            if (author == null) continue;
            authors.add(XdsMetadataUtil.convertIpfAuthor(author));
        }
        return authors;
    }

    public List<org.openehealth.ipf.commons.ihe.xds.core.metadata.Author> getAuthorTypeMdht() {
        return this.s.getAuthors();
    }

    public AvailabilityStatus getAvailabilityStatus() {
        return this.s.getAvailabilityStatus();
    }

    public String getComments() {
        return XdsMetadataUtil.convertInternationalStringType(this.s.getComments());
    }

    public Code getContentTypeCode() {
        return XdsMetadataUtil.convertOhtCodedMetadataType(this.s.getContentTypeCode());
    }

    public String getEntryUUID() {
        return this.s.getEntryUuid();
    }

    public SubmissionSet getIpfSubmissionSet() {
        return this.s;
    }

    public Identificator getPatientId() {
        return XdsMetadataUtil.convertOhtCx(this.s.getPatientId());
    }

    public String getSourceId() {
        return this.s.getSourceId();
    }

    public String getTitle() {
        return XdsMetadataUtil.convertInternationalStringType(this.s.getTitle());
    }

    public String getUniqueId() {
        return this.s.getUniqueId();
    }

    @Deprecated
    public void setAuthor(Author author) {
        if (author.getAuthorMdht().getAssignedAuthor().getTelecom().isEmpty()) {
            TEL tel = new TEL();
            author.getAuthorMdht().getAssignedAuthor().getTelecom().add(tel);
        }
        this.cda.getAuthor().clear();
        this.cda.getAuthor().add(author.getAuthorMdht());
        CDAR2Extractor extractor = new CDAR2Extractor(this.cda);
        org.openehealth.ipf.commons.ihe.xds.core.metadata.Author xAuthor = extractor.extractAuthors().get(0);
        this.s.setAuthor(xAuthor);
    }

    public void addAuthor(Author author) {
        this.s.setAuthor(XdsMetadataUtil.converteHCAuthor(author));
    }

    public void setAvailabilityStatus(AvailabilityStatus status) {
        this.s.setAvailabilityStatus(status);
    }

    public void setComments(String comments) {
        this.s.setComments(XdsMetadataUtil.createInternationalString(comments));
    }

    public void setContentTypeCode(Code code) {
        this.s.setContentTypeCode(XdsMetadataUtil.convertEhcCodeToCode(code));
    }

    public void setDestinationPatientId(Identificator id) {
        this.s.setPatientId(XdsMetadataUtil.convertEhcIdentificator(id));
    }

    public void setEntryUUID(String entryUuid) {
        this.s.setEntryUuid(entryUuid);
    }

    public void setSourceId(String id) {
        this.s.setSourceId(id);
    }

    public void setTitle(String title) {
        this.s.setTitle(XdsMetadataUtil.createInternationalString(title));
    }

    public void setUniqueId(String uniqueyId) {
        this.s.setUniqueId(uniqueyId);
    }

    public SubmissionSet toOhtSubmissionSetType(SubmissionSet ohtSubmissionSetType) {
        if (this.s.getAuthors() != null && !this.s.getAuthors().isEmpty()) {
            ohtSubmissionSetType.getAuthors().addAll(this.s.getAuthors());
        }
        if (this.s.getAvailabilityStatus() != null) {
            ohtSubmissionSetType.setAvailabilityStatus(this.s.getAvailabilityStatus());
        }
        if (this.s.getComments() != null) {
            ohtSubmissionSetType.setComments(this.s.getComments());
        }
        if (this.s.getContentTypeCode() != null) {
            ohtSubmissionSetType.setContentTypeCode(this.s.getContentTypeCode());
        }
        if (this.s.getPatientId() != null) {
            ohtSubmissionSetType.setPatientId(this.s.getPatientId());
        }
        if (this.s.getSourceId() != null) {
            ohtSubmissionSetType.setSourceId(this.s.getSourceId());
        }
        if (this.s.getTitle() != null) {
            ohtSubmissionSetType.setTitle(this.s.getTitle());
        }
        if (this.s.getUniqueId() != null) {
            ohtSubmissionSetType.setUniqueId(this.s.getUniqueId());
        }
        if (this.s.getIntendedRecipients() != null && !this.s.getIntendedRecipients().isEmpty()) {
            ohtSubmissionSetType.getIntendedRecipients().clear();
            ohtSubmissionSetType.getIntendedRecipients().addAll(this.s.getIntendedRecipients());
        }
        if (ohtSubmissionSetType.getSubmissionTime() == null) {
            ohtSubmissionSetType.setSubmissionTime(new Timestamp(ZonedDateTime.now(), Timestamp.Precision.SECOND));
        }
        if (ohtSubmissionSetType.getUniqueId() == null) {
            ohtSubmissionSetType.assignUniqueId();
        }
        if (ohtSubmissionSetType.getEntryUuid() == null) {
            ohtSubmissionSetType.assignEntryUuid();
        }
        return ohtSubmissionSetType;
    }

    public static enum SubmissionSetMetadataExtractionMode {
        DEFAULT_EXTRACTION,
        NO_METADATA_EXTRACTION;

    }
}

