/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.communication;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.PatientInfo;
import org.projecthusky.common.communication.CDAR2Extractor;
import org.projecthusky.common.enums.ConfidentialityCode;
import org.projecthusky.common.enums.DocumentDescriptor;
import org.projecthusky.common.hl7cdar2.POCDMT000040ClinicalDocument;
import org.projecthusky.common.model.Author;
import org.projecthusky.common.model.Identificator;
import org.projecthusky.common.model.Patient;
import org.projecthusky.common.utils.XdsMetadataUtil;

public class DocumentMetadata {
    private DocumentEntry xDoc;
    private final POCDMT000040ClinicalDocument cda;
    private DocumentDescriptor documentDescriptor;
    private String docSourceActorOrgId;
    private String language;

    public DocumentMetadata() {
        this.xDoc = new DocumentEntry();
        this.cda = new POCDMT000040ClinicalDocument();
    }

    public DocumentMetadata(DocumentEntry documentEntryType) {
        this();
        this.xDoc = documentEntryType;
    }

    public DocumentMetadata(String language) {
        this();
        this.language = language;
    }

    public DocumentMetadata(POCDMT000040ClinicalDocument cdaDoc, String language) {
        this.xDoc = new DocumentEntry();
        this.cda = cdaDoc;
        this.language = language;
    }

    public DocumentMetadata(POCDMT000040ClinicalDocument cdaDoc, DocumentEntry documentEntryType, String language) {
        this.xDoc = documentEntryType;
        this.cda = cdaDoc;
        this.language = language;
    }

    public void addAuthor() {
        CDAR2Extractor extractor = new CDAR2Extractor(this.cda);
        org.openehealth.ipf.commons.ihe.xds.core.metadata.Author xAuthor = extractor.extractAuthors().get(0);
        this.xDoc.getAuthors().add(xAuthor);
    }

    public void addAuthor(Author author) {
        this.xDoc.getAuthors().add(XdsMetadataUtil.converteHCAuthor(author));
    }

    public void addConfidentialityCode(org.projecthusky.common.model.Code code) {
        this.xDoc.getConfidentialityCodes().add(XdsMetadataUtil.convertEhcCodeToCode(code));
    }

    public void addConfidentialityCode(ConfidentialityCode code) {
        this.xDoc.getConfidentialityCodes().add(XdsMetadataUtil.createCodedMetadata(code.getCodeSystemId(), code.getCodeValue(), code.getDisplayName(), null));
    }

    public void clear() {
        this.xDoc.setAvailabilityStatus(null);
        this.xDoc.setClassCode(null);
        this.xDoc.setComments(null);
        this.xDoc.setCreationTime("");
        this.xDoc.setFormatCode(null);
        this.xDoc.setHash(null);
        this.xDoc.setLanguageCode(null);
        this.xDoc.setLegalAuthenticator(null);
        this.xDoc.setMimeType(null);
        this.xDoc.setPatientId(null);
        this.xDoc.setPracticeSettingCode(null);
        this.xDoc.setRepositoryUniqueId(null);
        this.xDoc.setServiceStartTime("");
        this.xDoc.setServiceStopTime("");
        this.xDoc.setSize(null);
        this.xDoc.setSourcePatientId(null);
        this.xDoc.setSourcePatientInfo(null);
        this.xDoc.setTypeCode(null);
        this.xDoc.setHealthcareFacilityTypeCode(null);
        this.xDoc.setTitle(null);
        this.xDoc.setUniqueId(null);
        this.xDoc.getAuthors().clear();
        this.xDoc.getConfidentialityCodes().clear();
        this.xDoc.getEventCodeList().clear();
        this.xDoc.getExtraMetadata().clear();
    }

    public void clearExtracted() {
        this.xDoc.setAvailabilityStatus(null);
        this.xDoc.setClassCode(null);
        this.xDoc.setComments(null);
        this.xDoc.setFormatCode(null);
        this.xDoc.setHash(null);
        this.xDoc.setMimeType(null);
        this.xDoc.setPatientId(null);
        this.xDoc.setPracticeSettingCode(null);
        this.xDoc.setRepositoryUniqueId(null);
        this.xDoc.getAuthors().clear();
        this.xDoc.getConfidentialityCodes().clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentMetadata)) {
            return false;
        }
        return this.equals((DocumentMetadata)obj);
    }

    public boolean equals(DocumentMetadata other) {
        boolean retVal = true;
        retVal = this.compareAuthors(other.getAuthors());
        if (retVal) {
            retVal = this.compareLanguange(other.language);
        }
        if (retVal) {
            retVal = this.comparePatientId(other.getPatientId());
        }
        if (retVal) {
            retVal = this.compareSourcePatientId(other.getSourcePatientId());
        }
        if (retVal) {
            retVal = this.compareClassCode(other.getClassCode());
        }
        if (retVal) {
            retVal = this.compareConfidentialityCode(other.getConfidentialityCodes());
        }
        if (retVal) {
            retVal = this.compareCodedLanguage(other.getCodedLanguage());
        }
        if (retVal) {
            retVal = this.compareCreationTime(other.getCreationTime());
        }
        if (retVal) {
            retVal = this.compareFormatCode(other.getFormatCode());
        }
        if (retVal) {
            retVal = this.compareDocSourceActorOrganizationId(other.getDocSourceActorOrganizationId());
        }
        if (retVal) {
            retVal = this.compareHealthcareFacilityTypeCode(other.getHealthcareFacilityTypeCode());
        }
        if (retVal) {
            retVal = this.compareMimeType(other.getMimeType());
        }
        if (retVal) {
            retVal = this.comparePracticeSettingCode(other.getPracticeSettingCode());
        }
        if (retVal) {
            retVal = this.compareTitle(other.getTitle());
        }
        if (retVal) {
            retVal = this.compareTypeCode(other.getTypeCode());
        }
        if (retVal) {
            retVal = this.compareUniqueId(other.getUniqueId());
        }
        return retVal;
    }

    private boolean compareLanguange(String other) {
        return !(this.language == null ? other != null : !this.language.equals(other));
    }

    private boolean compareUniqueId(String other) {
        return !(this.getUniqueId() == null ? other != null : !this.getUniqueId().equals(other));
    }

    private boolean compareTypeCode(org.projecthusky.common.model.Code other) {
        return !(this.getTypeCode() == null ? other != null : !this.getTypeCode().equals(other));
    }

    private boolean compareTitle(String other) {
        return !(this.getTitle() == null ? other != null : !this.getTitle().equals(other));
    }

    private boolean comparePracticeSettingCode(org.projecthusky.common.model.Code other) {
        return !(this.getPracticeSettingCode() == null ? other != null : !this.getPracticeSettingCode().equals(other));
    }

    private boolean compareMimeType(String other) {
        return !(this.getMimeType() == null ? other != null : !this.getMimeType().equals(other));
    }

    private boolean compareHealthcareFacilityTypeCode(org.projecthusky.common.model.Code other) {
        return !(this.getHealthcareFacilityTypeCode() == null ? other != null : !this.getHealthcareFacilityTypeCode().equals(other));
    }

    private boolean compareDocSourceActorOrganizationId(String other) {
        return !(this.getDocSourceActorOrganizationId() == null ? other != null : !this.getDocSourceActorOrganizationId().equals(other));
    }

    private boolean compareFormatCode(org.projecthusky.common.model.Code other) {
        return !(this.getFormatCode() == null ? other != null : !this.getFormatCode().equals(other));
    }

    private boolean compareCreationTime(ZonedDateTime other) {
        return !(this.getCreationTime() == null ? other != null : !this.getCreationTime().equals(other));
    }

    private boolean compareCodedLanguage(String other) {
        return !(this.getCodedLanguage() == null ? other != null : !this.getCodedLanguage().equals(other));
    }

    private boolean compareConfidentialityCode(List<org.projecthusky.common.model.Code> other) {
        return !(this.getConfidentialityCodes() == null ? other != null : !this.getConfidentialityCodes().equals(other));
    }

    private boolean compareClassCode(org.projecthusky.common.model.Code other) {
        return !(this.getClassCode() == null ? other != null : !this.getClassCode().equals(other));
    }

    private boolean compareSourcePatientId(Identificator other) {
        return !(this.getSourcePatientId() == null ? other != null : !this.getSourcePatientId().equals(other));
    }

    private boolean comparePatientId(Identificator other) {
        return !(this.getPatientId() == null ? other != null : !this.getPatientId().equals(other));
    }

    private boolean compareAuthors(List<Author> authors) {
        return !(this.getAuthors() == null ? authors != null : this.getAuthors().size() != authors.size());
    }

    public List<Author> getAuthors() {
        ArrayList<Author> authorList = new ArrayList<Author>();
        for (org.openehealth.ipf.commons.ihe.xds.core.metadata.Author at : this.xDoc.getAuthors()) {
            authorList.add(XdsMetadataUtil.convertIpfAuthor(at));
        }
        return authorList;
    }

    public AvailabilityStatus getAvailabilityStatus() {
        return this.xDoc.getAvailabilityStatus();
    }

    public org.projecthusky.common.model.Code getClassCode() {
        return XdsMetadataUtil.convertOhtCodedMetadataType(this.xDoc.getClassCode());
    }

    public String getCodedLanguage() {
        return this.xDoc.getLanguageCode();
    }

    public String getComments() {
        return XdsMetadataUtil.convertInternationalStringType(this.xDoc.getComments());
    }

    public List<org.projecthusky.common.model.Code> getConfidentialityCodes() {
        ArrayList<org.projecthusky.common.model.Code> confCodes = new ArrayList<org.projecthusky.common.model.Code>();
        if (!this.xDoc.getConfidentialityCodes().isEmpty()) {
            for (Code code : this.xDoc.getConfidentialityCodes()) {
                confCodes.add(XdsMetadataUtil.convertOhtCodedMetadataType(code));
            }
        } else {
            return new LinkedList<org.projecthusky.common.model.Code>();
        }
        return confCodes;
    }

    public ZonedDateTime getCreationTime() {
        return this.xDoc.getCreationTime().getDateTime();
    }

    public String getDocSourceActorOrganizationId() {
        return this.docSourceActorOrgId;
    }

    public DocumentDescriptor getDocumentDescriptor() {
        return this.documentDescriptor;
    }

    public String getEntryUUID() {
        return this.xDoc.getEntryUuid();
    }

    public org.projecthusky.common.model.Code getFormatCode() {
        return XdsMetadataUtil.convertOhtCodedMetadataType(this.xDoc.getFormatCode());
    }

    public org.projecthusky.common.model.Code getHealthcareFacilityTypeCode() {
        return XdsMetadataUtil.convertOhtCodedMetadataType(this.xDoc.getHealthcareFacilityTypeCode());
    }

    public DocumentEntry getDocumentEntry() {
        return this.xDoc;
    }

    public String getMetadataLanguage() {
        return this.language;
    }

    public String getMimeType() {
        return this.xDoc.getMimeType();
    }

    public Patient getPatient() {
        return XdsMetadataUtil.convertOhtSourcePatientInfoType(this.xDoc.getSourcePatientInfo());
    }

    public Identificator getPatientId() {
        return XdsMetadataUtil.convertOhtCx(this.xDoc.getPatientId());
    }

    public org.projecthusky.common.model.Code getPracticeSettingCode() {
        return XdsMetadataUtil.convertOhtCodedMetadataType(this.xDoc.getPracticeSettingCode());
    }

    public Identificator getSourcePatientId() {
        if (this.xDoc.getSourcePatientId() != null) {
            return XdsMetadataUtil.convertOhtCx(this.xDoc.getSourcePatientId());
        }
        return null;
    }

    public String getTitle() {
        return XdsMetadataUtil.convertInternationalStringType(this.xDoc.getTitle());
    }

    public org.projecthusky.common.model.Code getTypeCode() {
        return XdsMetadataUtil.convertOhtCodedMetadataType(this.xDoc.getTypeCode());
    }

    public String getUniqueId() {
        return this.xDoc.getUniqueId();
    }

    public String getUri() {
        return this.xDoc.getUri();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.xDoc == null) {
            return 31;
        }
        result += this.getAuthors().hashCode();
        result += this.getPatientId().hashCode();
        result += this.getSourcePatientId().hashCode();
        result += this.getClassCode().hashCode();
        result += this.getConfidentialityCodes().hashCode();
        result += this.getCodedLanguage().hashCode();
        result += this.getCreationTime().hashCode();
        result += this.getFormatCode().hashCode();
        result += this.getDocSourceActorOrganizationId().hashCode();
        result += this.getHealthcareFacilityTypeCode().hashCode();
        result += this.getMimeType().hashCode();
        result += this.getPracticeSettingCode().hashCode();
        result += this.getTitle().hashCode();
        result += this.getTypeCode().hashCode();
        result += this.getUniqueId().hashCode();
        return result *= 31;
    }

    public void setAvailabilityStatus(AvailabilityStatus availabilityStatus) {
        this.xDoc.setAvailabilityStatus(availabilityStatus);
    }

    public void setClassCode(org.projecthusky.common.model.Code code) {
        this.xDoc.setClassCode(XdsMetadataUtil.convertEhcCodeToIpfCode(code, this.language));
    }

    public void setCodedLanguage(String codedLanguage) {
        this.xDoc.setLanguageCode(codedLanguage);
    }

    public void setCreationTime(ZonedDateTime dateAndTime) {
        this.xDoc.setCreationTime(dateAndTime.format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssZ").withZone(ZoneId.systemDefault())));
    }

    public void setDestinationPatientId(Identificator id) {
        this.xDoc.setPatientId(XdsMetadataUtil.convertEhcIdentificator(id));
    }

    public void setDocSourceActorOrganizationId(String docSourceActorOrgId) {
        this.docSourceActorOrgId = docSourceActorOrgId;
    }

    public void setDocumentDescriptor(DocumentDescriptor documentDescriptor) {
        this.documentDescriptor = documentDescriptor;
    }

    public void setEntryUUID(String entryUuid) {
        this.xDoc.setEntryUuid(entryUuid);
    }

    public void setFormatCode(org.projecthusky.common.model.Code code) {
        this.xDoc.setFormatCode(XdsMetadataUtil.convertEhcCodeToIpfCode(code, this.language));
    }

    public void setHealthcareFacilityTypeCode(org.projecthusky.common.model.Code code) {
        this.xDoc.setHealthcareFacilityTypeCode(XdsMetadataUtil.convertEhcCodeToIpfCode(code, this.language));
    }

    public void setMetadata(DocumentMetadata metaData) {
        this.clear();
        for (Author author : metaData.getAuthors()) {
            this.addAuthor(author);
        }
        for (org.projecthusky.common.model.Code code : metaData.getConfidentialityCodes()) {
            this.addConfidentialityCode(code);
        }
        this.setClassCode(metaData.getClassCode());
        this.setCodedLanguage(metaData.getCodedLanguage());
        this.setCreationTime(metaData.getCreationTime());
        this.setDocumentDescriptor(metaData.getDocumentDescriptor());
        this.setDocSourceActorOrganizationId(metaData.getDocSourceActorOrganizationId());
        this.setFormatCode(metaData.getFormatCode());
        this.setHealthcareFacilityTypeCode(metaData.getHealthcareFacilityTypeCode());
        this.setMetadataLanguage(metaData.getMetadataLanguage());
        this.setMimeType(metaData.getMimeType());
        this.setPatient(metaData.getPatient());
        this.setPracticeSettingCode(metaData.getPracticeSettingCode());
        this.setTitle(metaData.getTitle());
        this.setTypeCode(metaData.getTypeCode());
        this.setUniqueId(metaData.getUniqueId());
        this.setUri(metaData.getUri());
        this.setSourcePatientId(metaData.getSourcePatientId());
        this.setDestinationPatientId(metaData.getPatientId());
    }

    public void setMetadataLanguage(String language) {
        this.language = language;
    }

    public void setMimeType(String mimeType) {
        this.xDoc.setMimeType(mimeType);
    }

    public void setPatient(Patient patient) {
        this.cda.getRecordTarget().add(patient.getMdhtRecordTarget());
        CDAR2Extractor extractor = new CDAR2Extractor(this.cda);
        PatientInfo spi = extractor.extractSourcePatientInfo();
        this.xDoc.setSourcePatientInfo(spi);
        if (patient.getIds() != null && !patient.getIds().isEmpty()) {
            this.setDestinationPatientId(patient.getIds().get(0));
        }
    }

    public void setPracticeSettingCode(org.projecthusky.common.model.Code code) {
        this.xDoc.setPracticeSettingCode(XdsMetadataUtil.convertEhcCodeToIpfCode(code, this.language));
    }

    public void setSourcePatientId(Identificator id) {
        this.xDoc.setSourcePatientId(XdsMetadataUtil.convertEhcIdentificator(id));
    }

    public void setTitle(String title) {
        this.xDoc.setTitle(XdsMetadataUtil.createInternationalString(title, this.language));
    }

    public void setTypeCode(org.projecthusky.common.model.Code code) {
        this.xDoc.setTypeCode(XdsMetadataUtil.convertEhcCodeToIpfCode(code, this.language));
    }

    public void setUniqueId(String id) {
        this.xDoc.setUniqueId(id);
    }

    public void setUri(String uri) {
        this.xDoc.setUri(uri);
    }

    public POCDMT000040ClinicalDocument getCda() {
        return this.cda;
    }

    public DocumentEntry getXDoc() {
        return this.xDoc;
    }

    public static enum DocumentMetadataExtractionMode {
        DEFAULT_EXTRACTION,
        NO_METADATA_EXTRACTION;

    }
}

