/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.communication;

import java.net.URI;

public class Destination {
    private String keyStore;
    private String keyStorePassword;
    private String receiverApplicationOid;
    private String receiverFacilityOid;
    private String senderApplicationOid;
    private String senderFacilityOid;
    private String senderOrganizationalOid;
    private String trustStore;
    private String trustStorePassword;
    private URI uri;
    private String keyStoreType;
    private String trustStoreType;

    public Destination() {
        this.keyStoreType = "jks";
        this.trustStoreType = "jks";
    }

    public Destination(String senderOrganizationalOid, URI uri) {
        this.uri = uri;
        this.senderOrganizationalOid = senderOrganizationalOid;
        this.keyStoreType = "jks";
        this.trustStoreType = "jks";
    }

    public Destination(String senderOrganizationalOid, URI uri, String keyStore, String keyStorePassword) {
        this(senderOrganizationalOid, uri);
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.trustStore = keyStore;
        this.trustStorePassword = keyStorePassword;
        this.setKeyStore();
    }

    public Destination(String senderOrganizationalOid, URI uri, String keyStore, String keyStorePassword, String keyStoreType) {
        this(senderOrganizationalOid, uri);
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
        this.trustStore = keyStore;
        this.trustStorePassword = keyStorePassword;
        this.trustStoreType = keyStoreType;
        this.setKeyStore();
    }

    public Destination(String senderOrganizationalOid, URI uri, String keyStore, String keyStorePassword, String trustStore, String trustStorePassword) {
        this(senderOrganizationalOid, uri);
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.trustStore = trustStore;
        this.trustStorePassword = trustStorePassword;
        this.setKeyStore();
    }

    public Destination(String senderOrganizationalOid, URI uri, String keyStore, String keyStorePassword, String keyStoreType, String trustStore, String trustStorePassword, String trustStoreType) {
        this(senderOrganizationalOid, uri);
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.keyStoreType = keyStoreType;
        this.trustStore = trustStore;
        this.trustStorePassword = trustStorePassword;
        this.trustStoreType = trustStoreType;
        this.setKeyStore();
    }

    public Destination(Destination origin) {
        this(origin.getSenderOrganizationalOid(), origin.getUri());
        this.receiverApplicationOid = origin.getReceiverApplicationOid();
        this.receiverFacilityOid = origin.getReceiverFacilityOid();
        this.senderApplicationOid = origin.getSenderApplicationOid();
        this.senderFacilityOid = origin.getSenderFacilityOid();
        this.keyStore = origin.getKeyStore();
        this.keyStorePassword = origin.getKeyStorePassword();
        this.keyStoreType = origin.getKeyStoreType();
        this.trustStore = origin.getTrustStore();
        this.trustStorePassword = origin.getTrustStorePassword();
        this.trustStoreType = origin.getTrustStoreType();
        this.setKeyStore();
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getReceiverApplicationOid() {
        return this.receiverApplicationOid;
    }

    public String getReceiverFacilityOid() {
        return this.receiverFacilityOid;
    }

    public String getSenderApplicationOid() {
        return this.senderApplicationOid;
    }

    public String getSenderFacilityOid() {
        return this.senderFacilityOid;
    }

    public String getSenderOrganizationalOid() {
        return this.senderOrganizationalOid;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public URI getUri() {
        return this.uri;
    }

    private void setKeyStore() {
        if (this.keyStore != null) {
            System.setProperty("javax.net.ssl.keyStore", this.keyStore);
            System.setProperty("javax.net.ssl.keyStorePassword", this.keyStorePassword);
            System.setProperty("javax.net.ssl.keyStoreType", this.keyStoreType);
            System.setProperty("javax.net.ssl.trustStore", this.trustStore);
            System.setProperty("javax.net.ssl.trustStorePassword", this.trustStorePassword);
            System.setProperty("javax.net.ssl.trustStoreType", this.trustStoreType);
        }
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setReceiverApplicationOid(String receiverApplicationOid) {
        this.receiverApplicationOid = receiverApplicationOid;
    }

    public void setReceiverFacilityOid(String receiverFacilityOid) {
        this.receiverFacilityOid = receiverFacilityOid;
    }

    public void setSenderApplicationOid(String senderApplicationOid) {
        this.senderApplicationOid = senderApplicationOid;
    }

    public void setSenderFacilityOid(String senderFacilityOid) {
        this.senderFacilityOid = senderFacilityOid;
    }

    public void setSenderOrganizationalOid(String senderOrganizationalOid) {
        this.senderOrganizationalOid = senderOrganizationalOid;
    }

    public void setTrustStore(String trustStore) {
        this.trustStore = trustStore;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }
}

