/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.communication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Address;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssigningAuthority;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Author;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.LocalizedString;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Name;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Organization;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.PatientInfo;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Person;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Telecom;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.XcnName;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.XpnName;
import org.projecthusky.common.communication.MetadataExtractionException;
import org.projecthusky.common.hl7cdar2.AD;
import org.projecthusky.common.hl7cdar2.AdxpAdditionalLocator;
import org.projecthusky.common.hl7cdar2.AdxpCity;
import org.projecthusky.common.hl7cdar2.AdxpCountry;
import org.projecthusky.common.hl7cdar2.AdxpHouseNumber;
import org.projecthusky.common.hl7cdar2.AdxpPostalCode;
import org.projecthusky.common.hl7cdar2.AdxpState;
import org.projecthusky.common.hl7cdar2.AdxpStreetAddressLine;
import org.projecthusky.common.hl7cdar2.AdxpStreetName;
import org.projecthusky.common.hl7cdar2.CD;
import org.projecthusky.common.hl7cdar2.CE;
import org.projecthusky.common.hl7cdar2.EnFamily;
import org.projecthusky.common.hl7cdar2.EnGiven;
import org.projecthusky.common.hl7cdar2.EnPrefix;
import org.projecthusky.common.hl7cdar2.EnSuffix;
import org.projecthusky.common.hl7cdar2.II;
import org.projecthusky.common.hl7cdar2.IVLTS;
import org.projecthusky.common.hl7cdar2.IVXBTS;
import org.projecthusky.common.hl7cdar2.ON;
import org.projecthusky.common.hl7cdar2.PN;
import org.projecthusky.common.hl7cdar2.POCDMT000040AssignedAuthor;
import org.projecthusky.common.hl7cdar2.POCDMT000040AssignedEntity;
import org.projecthusky.common.hl7cdar2.POCDMT000040Author;
import org.projecthusky.common.hl7cdar2.POCDMT000040ClinicalDocument;
import org.projecthusky.common.hl7cdar2.POCDMT000040DocumentationOf;
import org.projecthusky.common.hl7cdar2.POCDMT000040Organization;
import org.projecthusky.common.hl7cdar2.POCDMT000040Patient;
import org.projecthusky.common.hl7cdar2.POCDMT000040PatientRole;
import org.projecthusky.common.hl7cdar2.POCDMT000040RecordTarget;
import org.projecthusky.common.hl7cdar2.POCDMT000040ServiceEvent;
import org.projecthusky.common.hl7cdar2.QTY;
import org.projecthusky.common.hl7cdar2.TEL;
import org.projecthusky.common.hl7cdar2.TS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CDAR2Extractor {
    private static final Map<String, String> ADMIN_GENDER_TABLE_001;
    private static Logger logger;
    protected POCDMT000040ClinicalDocument cda;
    private static final String INFORMATION_NOT_EXTRACTED = "DocumentEntry.parentDocument expresses the id and relationship of a parent document to this CDA document in the XDS Registry.\n         This is not necessarily the same parent document that is documented within the CDA.\n         Thus, this information is not extracted.\n";
    private static final String INFO_PART_NOT_EXTRACTED = "is an XDS specific attribute and outside the scope of any CDA R2 document.\nThus, it cannot be extracted.\n";

    public CDAR2Extractor(POCDMT000040ClinicalDocument cda) {
        this.cda = cda;
    }

    public DocumentEntry extract() throws MetadataExtractionException {
        String uniqueId;
        Code typeCode;
        LocalizedString title;
        PatientInfo patientInfo;
        Identifiable sourcePatientId;
        Timestamp stopTime;
        Timestamp startTime;
        Person legalAuth;
        String langCode;
        Code hcfc;
        Timestamp creationTime;
        List<Code> confidentialityCodes;
        Code classCode;
        logger.info("BEGIN CDAR2Extractor.extract()");
        if (this.cda == null) {
            logger.error("CDA is null, cannot execute extraction.");
            throw new MetadataExtractionException("CDA is null, cannot execute extraction.");
        }
        DocumentEntry docEntry = new DocumentEntry();
        List<Author> authors = this.extractAuthors();
        if (authors != null) {
            docEntry.getAuthors().addAll(authors);
        }
        if ((classCode = this.extractClassCode()) != null) {
            docEntry.setClassCode(classCode);
        }
        if ((confidentialityCodes = this.extractConfidentialityCodes()) != null) {
            docEntry.getConfidentialityCodes().addAll(confidentialityCodes);
        }
        if ((creationTime = this.extractCreationTime()) != null) {
            docEntry.setCreationTime(creationTime);
        }
        if ((hcfc = this.extractHealthCareFacilityTypeCode()) != null) {
            docEntry.setHealthcareFacilityTypeCode(hcfc);
        }
        if ((langCode = this.extractLanguageCode()) != null) {
            docEntry.setLanguageCode(langCode);
        }
        if ((legalAuth = this.extractLegalAuthenticator()) != null) {
            docEntry.setLegalAuthenticator(legalAuth);
        }
        if ((startTime = this.extractServiceStartTime()) != null) {
            docEntry.setServiceStartTime(startTime);
        }
        if ((stopTime = this.extractServiceStopTime()) != null) {
            docEntry.setServiceStopTime(stopTime);
        }
        if ((sourcePatientId = this.extractSourcePatientId()) != null) {
            docEntry.setSourcePatientId(sourcePatientId);
        }
        if ((patientInfo = this.extractSourcePatientInfo()) != null) {
            docEntry.setSourcePatientInfo(patientInfo);
        }
        if ((title = this.extractTitle()) != null) {
            docEntry.setTitle(title);
        }
        if ((typeCode = this.extractTypeCode()) != null) {
            docEntry.setTypeCode(typeCode);
        }
        if ((uniqueId = this.extractUniqueId()) != null) {
            docEntry.setUniqueId(uniqueId);
        }
        logger.info("DONE");
        return docEntry;
    }

    public List<Author> extractAuthors() {
        if (!this.atLeastOne(this.cda.getAuthor())) {
            return new ArrayList<Author>();
        }
        Iterator<POCDMT000040Author> i = this.cda.getAuthor().iterator();
        ArrayList<Author> authorList = new ArrayList<Author>();
        while (i.hasNext()) {
            POCDMT000040Author author = i.next();
            POCDMT000040AssignedAuthor aAuth = author.getAssignedAuthor();
            if (aAuth == null || aAuth.getAssignedAuthoringDevice() != null) continue;
            authorList.add(this.extractAuthor(author));
        }
        return authorList;
    }

    private Author extractAuthor(POCDMT000040Author author) {
        Identifiable speciality;
        Identifiable role;
        Organization inst;
        Author aut = new Author();
        if (author == null) {
            return aut;
        }
        POCDMT000040AssignedAuthor aAuth = author.getAssignedAuthor();
        Person person = this.extractAuthorPerson(aAuth);
        if (person != null) {
            logger.debug("found author person");
            aut.setAuthorPerson(person);
        }
        if ((inst = this.extractAuthorInstitution(aAuth.getRepresentedOrganization())) != null) {
            logger.debug("found author institution");
            aut.getAuthorInstitution().add(inst);
        }
        if ((role = this.extractAuthorRole(author.getFunctionCode())) != null) {
            logger.debug("found author role");
            aut.getAuthorRole().add(role);
        }
        if ((speciality = this.extractAuthorSpeciality(aAuth.getCode())) != null) {
            logger.debug("found author specialty");
            aut.getAuthorSpecialty().add(speciality);
        }
        logger.debug("looking for telcom in: {}", aAuth.getTelecom());
        if (!aAuth.getTelecom().isEmpty()) {
            logger.debug("telcom not empty");
            Iterator<TEL> j = aAuth.getTelecom().iterator();
            while (j.hasNext()) {
                Telecom telcom = this.extractAuthorTelecommunication(j.next());
                if (telcom == null) continue;
                logger.debug("found author telcom");
                aut.getAuthorTelecom().add(telcom);
            }
        }
        return aut;
    }

    public AvailabilityStatus extractAvailabilityStatus() {
        logger.info("CDA R2 document header does not contain information corresponding to availablity status metadata.");
        return null;
    }

    public Code extractClassCode() {
        if (this.cda.getCode() == null) {
            return null;
        }
        return this.map(this.cda.getCode());
    }

    public LocalizedString extractComments() {
        logger.info("CDA R2 document header does not contain information corresponding to comments metadata.");
        return null;
    }

    public List<Code> extractConfidentialityCodes() {
        logger.info("DocumentEntry.confidentialityCode should be set explicitly");
        return new LinkedList<Code>();
    }

    public Timestamp extractCreationTime() {
        if (this.cda.getEffectiveTime() == null) {
            return null;
        }
        if (this.cda.getEffectiveTime().getValue() == null) {
            return null;
        }
        return Timestamp.fromHL7((String)this.cda.getEffectiveTime().getValue());
    }

    public String extractEntryUUID() {
        logger.info("DocumentEntry.entryUUID is an XDS specific attribute and outside the scope of any CDA R2 document.\nThus, it cannot be extracted.\n");
        return "";
    }

    public List<Code> extractEventCodes() {
        logger.info("This extraction routine, at this point,does not attempt to extract event code metadata from a generic CDA R2 document.");
        return new LinkedList<Code>();
    }

    public Map<String, List<String>> extractExtensions() {
        logger.info("This extraction routine, at this point,does not attempt to extract extension metadata from a generic CDA R2 document.");
        return new HashMap<String, List<String>>();
    }

    public Code extractFormatCode() {
        logger.info("DocumentEntry.formatCode is an XDS specific attribute and outside the scope of any CDA R2 document.\nThus, it cannot be extracted.\n");
        return null;
    }

    public String extractHash() {
        logger.info("DocumentEntry.hash is an XDS specific attribute and outside the scope of any CDA R2 document.\nThus, it cannot be extracted.\n");
        return "";
    }

    public Code extractHealthCareFacilityTypeCode() {
        if (this.cda.getComponentOf() != null && this.cda.getComponentOf().getEncompassingEncounter() != null && this.cda.getComponentOf().getEncompassingEncounter().getLocation() != null && this.cda.getComponentOf().getEncompassingEncounter().getLocation().getHealthCareFacility() != null && this.cda.getComponentOf().getEncompassingEncounter().getLocation().getHealthCareFacility().getCode() != null) {
            CE facility = this.cda.getComponentOf().getEncompassingEncounter().getLocation().getHealthCareFacility().getCode();
            return this.map(facility);
        }
        return null;
    }

    public String extractLanguageCode() {
        return this.cda.getLanguageCode().getCode();
    }

    public Person extractLegalAuthenticator() {
        if (this.cda.getLegalAuthenticator() != null && this.cda.getLegalAuthenticator().getAssignedEntity() != null) {
            logger.debug("extract legal authenticator");
            POCDMT000040AssignedEntity auth = this.cda.getLegalAuthenticator().getAssignedEntity();
            boolean idNull = false;
            if (!this.atLeastOne(auth.getId())) {
                idNull = true;
            } else if (auth.getId().get(0).getExtension() == null && auth.getId().get(0).getRoot() != null) {
                auth.getId().get(0).setExtension(auth.getId().get(0).getRoot());
                auth.getId().get(0).setRoot(null);
            }
            this.extractPerson(auth, idNull);
        }
        return null;
    }

    private Person extractPerson(POCDMT000040AssignedEntity auth, boolean idNull) {
        if (auth.getAssignedPerson() == null || auth.getAssignedPerson().getName().isEmpty()) {
            if (idNull) {
                return null;
            }
            return this.map(auth.getId().get(0), null);
        }
        if (idNull) {
            return this.map(null, auth.getAssignedPerson().getName().get(0));
        }
        return this.map(auth.getId().get(0), auth.getAssignedPerson().getName().get(0));
    }

    public String extractMimeType() {
        logger.info("DocumentEntry.mimeTypeis an XDS specific attribute and outside the scope of any CDA R2 document.\nThus, it cannot be extracted.\n");
        return null;
    }

    public Identifiable extractParentDocument() {
        logger.info(INFORMATION_NOT_EXTRACTED);
        return null;
    }

    public String extractRepositoryUniqueId() {
        logger.info("DocumentEntry.repositoryUniqueIdis an XDS specific attribute and outside the scope of any CDA R2 document.\nThus, it cannot be extracted.\n");
        return null;
    }

    public Timestamp extractServiceStartTime() {
        if (!this.atLeastOne(this.cda.getDocumentationOf())) {
            return null;
        }
        Iterator<POCDMT000040DocumentationOf> i = this.cda.getDocumentationOf().iterator();
        Timestamp minLowTime = null;
        while (i.hasNext()) {
            POCDMT000040DocumentationOf docOf = i.next();
            POCDMT000040ServiceEvent sEvent = docOf.getServiceEvent();
            if (sEvent == null || sEvent.getEffectiveTime() == null) continue;
            minLowTime = this.extractMinLowTime(sEvent.getEffectiveTime(), minLowTime);
        }
        return minLowTime;
    }

    private Timestamp extractMinLowTime(IVLTS range, Timestamp minLowTime) {
        if (range == null || range.getRest().isEmpty()) {
            return minLowTime;
        }
        Timestamp lowTime = null;
        for (JAXBElement<? extends QTY> qty : range.getRest()) {
            if (qty == null || qty.getName() == null || !qty.getName().getLocalPart().equalsIgnoreCase("low") || !(qty.getValue() instanceof IVXBTS)) continue;
            lowTime = Timestamp.fromHL7((String)((IVXBTS)qty.getValue()).getValue());
        }
        if (lowTime != null && (minLowTime == null || lowTime.getDateTime().isBefore(minLowTime.getDateTime()))) {
            minLowTime = lowTime;
        }
        return minLowTime;
    }

    public Timestamp extractServiceStopTime() {
        if (!this.atLeastOne(this.cda.getDocumentationOf())) {
            return null;
        }
        Iterator<POCDMT000040DocumentationOf> i = this.cda.getDocumentationOf().iterator();
        Timestamp maxHighTime = null;
        while (i.hasNext()) {
            POCDMT000040DocumentationOf docOf = i.next();
            POCDMT000040ServiceEvent sEvent = docOf.getServiceEvent();
            if (sEvent == null || sEvent.getEffectiveTime() == null) continue;
            maxHighTime = this.extractMaxHighTime(sEvent.getEffectiveTime(), maxHighTime);
        }
        return maxHighTime;
    }

    private Timestamp extractMaxHighTime(IVLTS range, Timestamp maxHighTime) {
        if (range == null || range.getRest().isEmpty()) {
            return maxHighTime;
        }
        Timestamp highTime = null;
        for (JAXBElement<? extends QTY> qty : range.getRest()) {
            if (qty == null || qty.getName() == null || !qty.getName().getLocalPart().equalsIgnoreCase("high") || !(qty.getValue() instanceof IVXBTS)) continue;
            highTime = Timestamp.fromHL7((String)((IVXBTS)qty.getValue()).getValue());
        }
        if (highTime != null && (maxHighTime == null || highTime.getDateTime().isAfter(maxHighTime.getDateTime()))) {
            maxHighTime = highTime;
        }
        return maxHighTime;
    }

    public Long extractSize() {
        logger.info("DocumentEntry.size is a comptuted value and outside the scope of any CDA R2 document. \nThus, it cannot be extracted.");
        return null;
    }

    public Identifiable extractSourcePatientId() {
        if (!this.atLeastOne(this.cda.getRecordTarget())) {
            return null;
        }
        POCDMT000040RecordTarget target = this.cda.getRecordTarget().get(0);
        if (target.getPatientRole() == null) {
            return null;
        }
        POCDMT000040PatientRole patient = target.getPatientRole();
        if (!this.atLeastOne(patient.getId())) {
            return null;
        }
        II pId = patient.getId().get(0);
        return this.map(pId);
    }

    public PatientInfo extractSourcePatientInfo() {
        if (!this.atLeastOne(this.cda.getRecordTarget())) {
            return null;
        }
        POCDMT000040RecordTarget target = this.cda.getRecordTarget().get(0);
        if (target.getPatientRole() == null) {
            return null;
        }
        POCDMT000040PatientRole patient = target.getPatientRole();
        PatientInfo sourceInfo = new PatientInfo();
        this.addIds(patient.getId(), sourceInfo);
        this.addAddressesOfPatientInfo(patient.getAddr(), sourceInfo);
        if (patient.getPatient() != null) {
            POCDMT000040Patient p = patient.getPatient();
            if (p.getId() != null) {
                this.addIds(List.of(p.getId()), sourceInfo);
            }
            this.addNames(p.getName(), sourceInfo);
            sourceInfo.setDateOfBirth(this.extractPid7(p.getBirthTime()));
            sourceInfo.setGender(this.extractPid8(p.getAdministrativeGenderCode()));
        } else {
            XpnName xpn = new XpnName();
            xpn.setFamilyName("");
            sourceInfo.getNames().add(xpn);
            sourceInfo.setDateOfBirth("");
            sourceInfo.setGender("");
        }
        return sourceInfo;
    }

    private void addIds(List<II> iis, PatientInfo patientInfo) {
        if (iis != null) {
            List<Identifiable> ids = this.extractPid3(iis);
            for (Identifiable id : ids) {
                patientInfo.getIds().add(id);
            }
        }
    }

    private void addNames(List<PN> pn, PatientInfo patientInfo) {
        if (this.atLeastOne(pn)) {
            List<XpnName> names = this.extractPid5(pn);
            for (XpnName name : names) {
                patientInfo.getNames().add(name);
            }
        } else {
            XpnName xpn = new XpnName();
            xpn.setFamilyName("");
            patientInfo.getNames().add(xpn);
        }
    }

    private void addAddressesOfPatientInfo(List<AD> ad, PatientInfo patientInfo) {
        if (this.atLeastOne(ad)) {
            Address xad = this.extractPid11(ad.get(0));
            if (xad != null && xad.getStreetAddress() != null && xad.getCity() != null && xad.getStateOrProvince() != null && xad.getZipOrPostalCode() != null && xad.getCountry() != null) {
                patientInfo.getAddresses().add(xad);
            }
        } else {
            Address xad = new Address();
            xad.setStreetAddress("");
            patientInfo.getAddresses().add(xad);
        }
    }

    public LocalizedString extractTitle() {
        if (this.cda.getTitle() == null) {
            return null;
        }
        LocalizedString dName = new LocalizedString();
        dName.setValue(this.cda.getTitle().getTextContent());
        return dName;
    }

    public Code extractTypeCode() {
        return this.extractClassCode();
    }

    public String extractUniqueId() {
        if (this.cda.getId() == null) {
            return null;
        }
        if (this.cda.getId().getRoot() == null) {
            return null;
        }
        if (this.cda.getId().getExtension() == null) {
            return this.cda.getId().getRoot();
        }
        return this.cda.getId().getRoot() + "^" + this.cda.getId().getExtension();
    }

    public String extractURI() {
        logger.info("DocumentEntry.URI is a comptuted value and outside the scope of any CDA R2 document. \nThus, it cannot be extracted.");
        return null;
    }

    private Organization extractAuthorInstitution(POCDMT000040Organization org) {
        if (org == null) {
            return null;
        }
        Organization retVal = null;
        boolean idNull = false;
        boolean nameNull = false;
        if (!this.atLeastOne(org.getId())) {
            idNull = true;
        }
        if (!this.atLeastOne(org.getName())) {
            nameNull = true;
        }
        retVal = idNull ? this.map(org.getName().get(0), null) : (nameNull ? this.map(null, org.getId().get(0)) : this.map(org.getName().get(0), org.getId().get(0)));
        return retVal;
    }

    public Person extractAuthorPerson(POCDMT000040AssignedAuthor aAuth) {
        if (aAuth == null) {
            return null;
        }
        boolean idNull = false;
        if (!this.atLeastOne(aAuth.getId())) {
            idNull = true;
        } else if (aAuth.getId().get(0).getExtension() == null && aAuth.getId().get(0).getRoot() != null) {
            aAuth.getId().get(0).setExtension(aAuth.getId().get(0).getRoot());
            aAuth.getId().get(0).setRoot(null);
        }
        if (aAuth.getAssignedPerson() == null || !this.atLeastOne(aAuth.getAssignedPerson().getName())) {
            if (idNull) {
                return null;
            }
            return this.map(aAuth.getId().get(0), null);
        }
        if (idNull) {
            return this.map(null, aAuth.getAssignedPerson().getName().get(0));
        }
        return this.map(aAuth.getId().get(0), aAuth.getAssignedPerson().getName().get(0));
    }

    private Identifiable extractAuthorRole(CE role) {
        if (role == null) {
            return null;
        }
        Identifiable identifiable = new Identifiable();
        if (role.getCode() == null) {
            return null;
        }
        identifiable.setId(role.getDisplayName());
        return identifiable;
    }

    private Identifiable extractAuthorSpeciality(CE spec) {
        if (spec == null) {
            return null;
        }
        Identifiable identifiable = new Identifiable();
        if (spec.getCode() == null) {
            return null;
        }
        identifiable.setId(spec.getCode());
        return identifiable;
    }

    private Telecom extractAuthorTelecommunication(TEL tel) {
        if (tel == null) {
            return null;
        }
        return this.map(tel);
    }

    private Address extractPid11(AD addr) {
        return this.map(addr);
    }

    private List<Identifiable> extractPid3(List<II> idList) {
        Iterator<II> i = idList.iterator();
        ArrayList<Identifiable> ids = new ArrayList<Identifiable>();
        while (i.hasNext()) {
            II pId = i.next();
            Identifiable cx = this.map(pId);
            if (cx == null) continue;
            ids.add(cx);
        }
        return ids;
    }

    private List<XpnName> extractPid5(List<PN> nameList) {
        Iterator<PN> i = nameList.iterator();
        ArrayList<XpnName> names = new ArrayList<XpnName>();
        while (i.hasNext()) {
            PN name = i.next();
            XpnName xpn = this.map(name);
            names.add(xpn);
        }
        return names;
    }

    private Timestamp extractPid7(TS time) {
        if (time == null) {
            return new Timestamp();
        }
        return Timestamp.fromHL7((String)time.getValue());
    }

    private String extractPid8(CE docCode) {
        if (docCode == null) {
            return "";
        }
        String gender = docCode.getCode();
        return ADMIN_GENDER_TABLE_001.get(gender);
    }

    protected boolean atLeastOne(List<?> l) {
        return l != null && !l.isEmpty() && l.get(0) != null;
    }

    protected Address map(AD addr) {
        if (addr == null) {
            return null;
        }
        Address xad = new Address();
        if (this.atLeastOne(addr.getContent())) {
            for (Serializable obj : addr.getContent()) {
                JAXBElement element = (JAXBElement)obj;
                this.addXadElement(element.getValue(), xad);
            }
        }
        return xad;
    }

    private void addXadElement(Object value, Address xad) {
        AdxpCountry stl;
        String txt;
        xad.setStreetAddress(this.extractXad1(value, xad.getStreetAddress()));
        if (value instanceof AdxpAdditionalLocator) {
            AdxpAdditionalLocator stl2 = (AdxpAdditionalLocator)value;
            String txt2 = stl2.getTextContent();
            if (txt2.length() > 0) {
                xad.setOtherDesignation(txt2);
            }
        } else if (value instanceof AdxpCity) {
            AdxpCity stl3 = (AdxpCity)value;
            String txt3 = stl3.getTextContent();
            if (txt3.length() > 0) {
                xad.setCity(txt3);
            }
        } else if (value instanceof AdxpState) {
            AdxpState stl4 = (AdxpState)value;
            String txt4 = stl4.getTextContent();
            if (txt4.length() > 0) {
                xad.setStateOrProvince(txt4);
            }
        } else if (value instanceof AdxpPostalCode) {
            AdxpPostalCode stl5 = (AdxpPostalCode)value;
            String txt5 = stl5.getTextContent();
            if (txt5.length() > 0) {
                xad.setZipOrPostalCode(txt5);
            }
        } else if (value instanceof AdxpCountry && (txt = (stl = (AdxpCountry)value).getTextContent()).length() > 0) {
            xad.setCountry(txt);
        }
    }

    private String appendAddress(String txt, String streetAddress, boolean addressfirst) {
        if (txt != null && txt.length() > 0) {
            streetAddress = streetAddress != null && !((String)streetAddress).isEmpty() ? (addressfirst ? (String)streetAddress + " " + txt : txt + " " + (String)streetAddress) : txt;
        }
        return streetAddress;
    }

    private String extractXad1(Object value, String streetAddress) {
        if (value instanceof AdxpStreetAddressLine) {
            AdxpStreetAddressLine stl = (AdxpStreetAddressLine)value;
            return stl.getTextContent();
        }
        if (value instanceof AdxpStreetName) {
            AdxpStreetName stl = (AdxpStreetName)value;
            String txt = stl.getTextContent();
            streetAddress = this.appendAddress(txt, streetAddress, false);
        } else if (value instanceof AdxpHouseNumber) {
            AdxpHouseNumber stl = (AdxpHouseNumber)value;
            String txt = stl.getTextContent();
            streetAddress = this.appendAddress(txt, streetAddress, true);
        }
        return streetAddress;
    }

    protected Code map(CD docCode) {
        if (docCode == null) {
            return null;
        }
        Code code = new Code();
        code.setCode(docCode.getCode());
        if (docCode.getDisplayName() != null) {
            code.setDisplayName(new LocalizedString(docCode.getDisplayName()));
        }
        if (docCode.getCodeSystemName() != null) {
            code.setSchemeName(docCode.getCodeSystemName());
        } else {
            code.setSchemeName(docCode.getCodeSystem());
        }
        return code;
    }

    protected Identifiable map(II id) {
        if (id == null) {
            return null;
        }
        Identifiable cx = new Identifiable();
        AssigningAuthority assigningAuthority = new AssigningAuthority();
        cx.setId(id.getExtension());
        assigningAuthority.setUniversalId(id.getRoot());
        assigningAuthority.setUniversalIdType("ISO");
        cx.setAssigningAuthority(assigningAuthority);
        return cx;
    }

    protected Person map(II id, PN name) {
        Person xcn = new Person();
        boolean idNull = true;
        if (id != null) {
            xcn.setId(this.map(id));
            idNull = false;
        }
        if (name != null) {
            xcn.setName((Name)this.mapXcn(name));
        }
        if (idNull && name == null) {
            return null;
        }
        return xcn;
    }

    protected Organization map(ON name, II id) {
        String txt;
        Organization xon = new Organization();
        if (id != null) {
            if (id.getExtension() != null) {
                xon.setIdNumber(id.getExtension());
                AssigningAuthority assigningAuthority = new AssigningAuthority();
                assigningAuthority.setUniversalId(id.getRoot());
                assigningAuthority.setUniversalIdType("ISO");
                xon.setAssigningAuthority(assigningAuthority);
            } else {
                xon.setIdNumber(id.getRoot());
            }
        }
        if (name != null && (txt = name.getMergedXmlMixed()).length() > 0) {
            xon.setOrganizationName(txt);
        }
        return xon;
    }

    protected XpnName map(PN name) {
        if (name == null) {
            return null;
        }
        XpnName xpn = new XpnName();
        for (Serializable obj : name.getContent()) {
            JAXBElement element = (JAXBElement)obj;
            this.addNameElements(element.getValue(), (Name<?>)xpn);
        }
        return xpn;
    }

    protected XcnName mapXcn(PN name) {
        if (name == null) {
            return null;
        }
        XcnName xcn = new XcnName();
        for (Serializable obj : name.getContent()) {
            JAXBElement element = (JAXBElement)obj;
            this.addNameElements(element.getValue(), (Name<?>)xcn);
        }
        return xcn;
    }

    private void addNameElements(Object value, Name<?> xpn) {
        EnPrefix prefix;
        String txt;
        if (value instanceof EnFamily) {
            EnFamily family = (EnFamily)value;
            String txt2 = family.getTextContent();
            if (!txt2.isEmpty()) {
                xpn.setFamilyName(txt2);
            }
        } else if (value instanceof EnGiven) {
            EnGiven given = (EnGiven)value;
            String txt3 = given.getTextContent();
            if (!txt3.isEmpty()) {
                xpn.setGivenName(txt3);
            }
        } else if (value instanceof EnSuffix) {
            EnSuffix suffix = (EnSuffix)value;
            String txt4 = suffix.getTextContent();
            if (!txt4.isEmpty()) {
                xpn.setSuffix(txt4);
            }
        } else if (value instanceof EnPrefix && !(txt = (prefix = (EnPrefix)value).getTextContent()).isEmpty()) {
            xpn.setPrefix(txt);
        }
    }

    protected Telecom map(TEL tel) {
        if (tel == null || tel.getValue() == null || tel.getValue().isEmpty()) {
            return null;
        }
        Telecom xtn = new Telecom();
        if (tel.getValue().contains("tel")) {
            xtn.setType("PH");
            xtn.setUnformattedPhoneNumber(tel.getValue().replace("tel:", ""));
        } else if (tel.getValue().contains("mailto")) {
            xtn.setEmail(tel.getValue().replace("mailto:", ""));
        }
        for (String use : tel.getUse()) {
            xtn.setUse(use);
        }
        return xtn;
    }

    static {
        logger = LoggerFactory.getLogger(CDAR2Extractor.class);
        ADMIN_GENDER_TABLE_001 = new HashMap<String, String>();
        ADMIN_GENDER_TABLE_001.put("M", "M");
        ADMIN_GENDER_TABLE_001.put("F", "F");
        ADMIN_GENDER_TABLE_001.put("UN", "O");
    }
}

