/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.communication;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.projecthusky.common.communication.AtnaConfig;
import org.projecthusky.common.communication.Destination;

public class AffinityDomain {
    private AtnaConfig atnaConfig;
    private String mpiPid;
    private List<Destination> mRepositories;
    private Set<String> otherIdsOidSet;
    private Destination pdqDestination = null;
    private Destination pixDestination = null;
    private Destination registryDestination = null;

    public AffinityDomain() {
        this.mRepositories = new ArrayList<Destination>();
        this.otherIdsOidSet = new HashSet<String>();
    }

    public AffinityDomain(Destination destPidSource, Destination destRegistry, Destination destRepository) {
        this.pixDestination = destPidSource;
        this.registryDestination = destRegistry;
        this.mRepositories = new ArrayList<Destination>();
        this.mRepositories.add(destRepository);
        this.otherIdsOidSet = new HashSet<String>();
    }

    public AffinityDomain(Destination destPidSource, Destination destRegistry, List<Destination> destRepositories) {
        this.pixDestination = destPidSource;
        this.registryDestination = destRegistry;
        this.mRepositories = destRepositories;
        this.otherIdsOidSet = new HashSet<String>();
    }

    public void addOtherId(String oid) {
        this.otherIdsOidSet.add(oid);
    }

    public void addRepository(Destination destRepository) {
        this.mRepositories.add(destRepository);
    }

    public void clearRepositories() {
        this.mRepositories = new ArrayList<Destination>();
    }

    public AtnaConfig getAtnaConfig() {
        return this.atnaConfig;
    }

    public String getMpiPid() {
        return this.mpiPid;
    }

    public Set<String> getOtherIdsOidSet() {
        return this.otherIdsOidSet;
    }

    public Destination getPdqDestination() {
        return this.pdqDestination;
    }

    public Destination getPixDestination() {
        return this.pixDestination;
    }

    public Destination getRegistryDestination() {
        return this.registryDestination;
    }

    public Destination getRepositoryDestination() {
        Destination retVal = null;
        if (!this.mRepositories.isEmpty()) {
            retVal = this.mRepositories.get(0);
        }
        return retVal;
    }

    public Destination getRepositoryDestination(int index) {
        Destination retVal = null;
        if (!this.mRepositories.isEmpty()) {
            retVal = this.mRepositories.get(index);
        }
        return retVal;
    }

    public void setAtnaConfig(AtnaConfig atnaConfig) {
        this.atnaConfig = atnaConfig;
    }

    public void setMpiPid(String mpiPid) {
        this.mpiPid = mpiPid;
    }

    public void setOtherIdsOidSet(Set<String> otherIdsOidSet) {
        this.otherIdsOidSet = otherIdsOidSet;
    }

    public void setPdqDestination(Destination pdqDestination) {
        this.pdqDestination = pdqDestination;
    }

    public void setPixDestination(Destination destPidSource) {
        this.pixDestination = destPidSource;
    }

    public void setRegistryDestination(Destination destRegistry) {
        this.registryDestination = destRegistry;
    }

    public void setRepositoryDestination(Destination destRepository) {
        this.mRepositories = new ArrayList<Destination>();
        this.mRepositories.add(destRepository);
    }
}

