/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.basetypes;

import java.io.Serializable;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.enums.TelecomAddressUse;

public class TelecomBaseType
implements Serializable {
    private static final long serialVersionUID = 6908791040642752931L;
    private NullFlavor nullFlavor;
    private TelecomAddressUse usage;
    private String value;

    public TelecomBaseType() {
    }

    private TelecomBaseType(Builder builder) {
        this.usage = builder.usage;
        this.value = builder.value;
        this.nullFlavor = builder.nullFlavor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        boolean retVal = true;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelecomBaseType)) {
            return false;
        }
        retVal = this.usage == null ? ((TelecomBaseType)obj).getUsage() == null : this.usage.equals(((TelecomBaseType)obj).getUsage());
        if (retVal) {
            retVal = this.value == null ? ((TelecomBaseType)obj).getValue() == null : this.value.equals(((TelecomBaseType)obj).getValue());
        }
        return retVal;
    }

    public NullFlavor getNullFlavor() {
        return this.nullFlavor;
    }

    public TelecomAddressUse getUsage() {
        return this.usage;
    }

    public void setUsage(TelecomAddressUse usage) {
        this.usage = usage;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.value).append(this.usage != null ? Integer.valueOf(this.usage.hashCode()) : null).toHashCode();
    }

    public boolean isNullFlavor() {
        return this.nullFlavor != null;
    }

    public void setNullFlavor(NullFlavor nullFlavor) {
        this.nullFlavor = nullFlavor;
    }

    public void setFax(String value) {
        this.setValue("fax:" + value);
    }

    public void setMail(String value) {
        this.setValue("mailto:" + value);
    }

    public void setPhone(String value) {
        this.setValue("tel:" + value);
    }

    public String toString() {
        return this.getValue();
    }

    public static final class Builder {
        private NullFlavor nullFlavor;
        private TelecomAddressUse usage;
        private String value;

        private Builder() {
        }

        public TelecomBaseType build() {
            return new TelecomBaseType(this);
        }

        public Builder withNullFlavor(NullFlavor nullFlavor) {
            this.nullFlavor = nullFlavor;
            return this;
        }

        public Builder withUsage(TelecomAddressUse usage) {
            this.usage = usage;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }
    }
}

