/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.basetypes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.projecthusky.common.basetypes.AddressBaseType;
import org.projecthusky.common.basetypes.IdentificatorBaseType;
import org.projecthusky.common.basetypes.NameBaseType;
import org.projecthusky.common.basetypes.TelecomBaseType;
import org.projecthusky.common.enums.NullFlavor;

public class OrganizationBaseType
implements Serializable {
    private static final long serialVersionUID = -2506412743872695565L;
    private List<AddressBaseType> addressList;
    private List<IdentificatorBaseType> identificatorList;
    private List<NameBaseType> nameList;
    private NullFlavor nullFlavor;
    private AddressBaseType primaryAddress;
    private IdentificatorBaseType primaryIdentificator;
    private NameBaseType primaryName;
    private TelecomBaseType primaryTelecom;
    private List<TelecomBaseType> telecomList;

    public OrganizationBaseType() {
    }

    private OrganizationBaseType(Builder builder) {
        this.addressList = builder.addressList;
        this.identificatorList = builder.identificatorList;
        this.nameList = builder.nameList;
        this.primaryAddress = builder.primaryAddress;
        this.primaryIdentificator = builder.primaryIdentificator;
        this.primaryName = builder.primaryName;
        this.primaryTelecom = builder.primaryTelecom;
        this.nullFlavor = builder.nullFlavor;
        this.telecomList = builder.telecomList;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void addAddress(AddressBaseType value) {
        if (this.addressList == null) {
            this.addressList = new ArrayList<AddressBaseType>();
            if (this.primaryAddress == null) {
                this.primaryAddress = value;
            }
        }
        this.addressList.add(value);
    }

    public void addIdentificator(IdentificatorBaseType value) {
        if (this.identificatorList == null) {
            this.identificatorList = new ArrayList<IdentificatorBaseType>();
            if (this.primaryIdentificator == null) {
                this.primaryIdentificator = value;
            }
        }
        this.identificatorList.add(value);
    }

    public void addName(NameBaseType value) {
        if (this.nameList == null) {
            this.nameList = new ArrayList<NameBaseType>();
            if (this.primaryName == null) {
                this.primaryName = value;
            }
        }
        this.nameList.add(value);
    }

    public void addTelecom(TelecomBaseType value) {
        if (this.telecomList == null) {
            this.telecomList = new ArrayList<TelecomBaseType>();
            if (this.primaryTelecom == null) {
                this.primaryTelecom = value;
            }
        }
        this.telecomList.add(value);
    }

    public void clearAddressList() {
        this.addressList = new ArrayList<AddressBaseType>();
    }

    public void clearIdentificatorList() {
        this.identificatorList = new ArrayList<IdentificatorBaseType>();
    }

    public void clearNameList() {
        this.nameList = new ArrayList<NameBaseType>();
    }

    public void clearTelecomList() {
        this.telecomList = new ArrayList<TelecomBaseType>();
    }

    public boolean contains(AddressBaseType value) {
        if (this.addressList != null) {
            for (AddressBaseType entry : this.addressList) {
                if (!entry.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(IdentificatorBaseType value) {
        if (this.addressList != null) {
            for (IdentificatorBaseType entry : this.identificatorList) {
                if (!entry.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(NameBaseType value) {
        if (this.addressList != null) {
            for (NameBaseType entry : this.nameList) {
                if (!entry.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(TelecomBaseType value) {
        if (this.addressList != null) {
            for (TelecomBaseType entry : this.telecomList) {
                if (!entry.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        boolean retVal = true;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationBaseType)) {
            return false;
        }
        retVal = this.compareAddressList((OrganizationBaseType)obj);
        if (retVal) {
            retVal = this.compareIdentificatorList((OrganizationBaseType)obj);
        }
        if (retVal) {
            retVal = this.compareNameList((OrganizationBaseType)obj);
        }
        if (retVal) {
            retVal = this.compareTelecomList((OrganizationBaseType)obj);
        }
        return retVal;
    }

    private boolean compareAddressList(OrganizationBaseType obj) {
        boolean retVal = true;
        if (this.addressList == null) {
            this.addressList = new ArrayList<AddressBaseType>();
        }
        for (int i = 0; i < this.addressList.size(); ++i) {
            retVal = obj.contains(this.addressList.get(i));
            if (retVal) continue;
            return false;
        }
        return retVal;
    }

    private boolean compareIdentificatorList(OrganizationBaseType obj) {
        boolean retVal = true;
        if (this.identificatorList == null) {
            this.identificatorList = new ArrayList<IdentificatorBaseType>();
        }
        for (int i = 0; i < this.identificatorList.size(); ++i) {
            retVal = obj.contains(this.identificatorList.get(i));
            if (retVal) continue;
            return false;
        }
        return retVal;
    }

    private boolean compareNameList(OrganizationBaseType obj) {
        boolean retVal = true;
        if (this.nameList == null) {
            this.nameList = new ArrayList<NameBaseType>();
        }
        for (int i = 0; i < this.nameList.size(); ++i) {
            retVal = obj.contains(this.nameList.get(i));
            if (retVal) continue;
            return false;
        }
        return retVal;
    }

    private boolean compareTelecomList(OrganizationBaseType obj) {
        boolean retVal = true;
        if (this.telecomList == null) {
            this.telecomList = new ArrayList<TelecomBaseType>();
        }
        for (int i = 0; i < this.telecomList.size(); ++i) {
            retVal = obj.contains(this.telecomList.get(i));
            if (retVal) continue;
            return false;
        }
        return retVal;
    }

    public List<AddressBaseType> getAddressList() {
        if (this.addressList == null) {
            this.addressList = new ArrayList<AddressBaseType>();
        }
        return this.addressList;
    }

    public void setAddressList(List<AddressBaseType> addressList) {
        this.addressList = addressList;
    }

    public List<IdentificatorBaseType> getIdentificatorList() {
        if (this.identificatorList == null) {
            this.identificatorList = new ArrayList<IdentificatorBaseType>();
        }
        return this.identificatorList;
    }

    public void setIdentificatorList(List<IdentificatorBaseType> identificatorList) {
        this.identificatorList = identificatorList;
    }

    public List<NameBaseType> getNameList() {
        if (this.nameList == null) {
            this.nameList = new ArrayList<NameBaseType>();
        }
        return this.nameList;
    }

    public void setNameList(List<NameBaseType> nameList) {
        this.nameList = nameList;
    }

    public NullFlavor getNullFlavor() {
        return this.nullFlavor;
    }

    public AddressBaseType getPrimaryAddress() {
        return this.primaryAddress;
    }

    public void setPrimaryAddress(AddressBaseType primaryAddress) {
        this.primaryAddress = primaryAddress;
        if (primaryAddress != null) {
            this.addAddress(primaryAddress);
        }
    }

    public IdentificatorBaseType getPrimaryIdentificator() {
        return this.primaryIdentificator;
    }

    public void setPrimaryIdentificator(IdentificatorBaseType primaryIdentificator) {
        this.primaryIdentificator = primaryIdentificator;
        if (primaryIdentificator != null) {
            this.addIdentificator(primaryIdentificator);
        }
    }

    public NameBaseType getPrimaryName() {
        return this.primaryName;
    }

    public void setPrimaryName(NameBaseType primaryName) {
        this.primaryName = primaryName;
        if (primaryName != null) {
            this.addName(primaryName);
        }
    }

    public TelecomBaseType getPrimaryTelecom() {
        return this.primaryTelecom;
    }

    public void setPrimaryTelecom(TelecomBaseType primaryTelecom) {
        this.primaryTelecom = primaryTelecom;
        if (primaryTelecom != null) {
            this.addTelecom(primaryTelecom);
        }
    }

    public List<TelecomBaseType> getTelecomList() {
        if (this.telecomList == null) {
            this.telecomList = new ArrayList<TelecomBaseType>();
        }
        return this.telecomList;
    }

    public void setTelecomList(List<TelecomBaseType> telecomList) {
        this.telecomList = telecomList;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 37);
        if (this.addressList != null) {
            for (AddressBaseType address : this.addressList) {
                builder.append(address.hashCode());
            }
        }
        if (this.identificatorList != null) {
            for (IdentificatorBaseType id : this.identificatorList) {
                builder.append(id.hashCode());
            }
        }
        if (this.nameList != null) {
            for (NameBaseType name : this.nameList) {
                builder.append(name.hashCode());
            }
        }
        if (this.telecomList != null) {
            for (TelecomBaseType telecom : this.telecomList) {
                builder.append(telecom.hashCode());
            }
        }
        return builder.toHashCode();
    }

    public boolean isNullFlavor() {
        return this.nullFlavor != null;
    }

    public void setNullFlavor(NullFlavor nullFlavor) {
        this.nullFlavor = nullFlavor;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        retVal.append(this.getPrimaryName().toString());
        retVal.append("\n");
        retVal.append(this.getPrimaryAddress().toString());
        return retVal.toString();
    }

    public static final class Builder {
        private List<AddressBaseType> addressList;
        private List<IdentificatorBaseType> identificatorList;
        private List<NameBaseType> nameList;
        private NullFlavor nullFlavor;
        private AddressBaseType primaryAddress;
        private IdentificatorBaseType primaryIdentificator;
        private NameBaseType primaryName;
        private TelecomBaseType primaryTelecom;
        private List<TelecomBaseType> telecomList;

        private Builder() {
        }

        public OrganizationBaseType build() {
            return new OrganizationBaseType(this);
        }

        public Builder withAddressList(ArrayList<AddressBaseType> addressList) {
            this.addressList = addressList;
            return this;
        }

        public Builder withIdentificatorList(ArrayList<IdentificatorBaseType> identificatorList) {
            this.identificatorList = identificatorList;
            return this;
        }

        public Builder withNameList(ArrayList<NameBaseType> nameList) {
            this.nameList = nameList;
            return this;
        }

        public Builder withNullFlavor(NullFlavor nullFlavor) {
            this.nullFlavor = nullFlavor;
            return this;
        }

        public Builder withPrimaryAddress(AddressBaseType primaryAddress) {
            this.primaryAddress = primaryAddress;
            return this;
        }

        public Builder withPrimaryIdentificator(IdentificatorBaseType primaryIdentificator) {
            this.primaryIdentificator = primaryIdentificator;
            return this;
        }

        public Builder withPrimaryName(NameBaseType primaryName) {
            this.primaryName = primaryName;
            return this;
        }

        public Builder withPrimaryTelecom(TelecomBaseType primaryTelecom) {
            this.primaryTelecom = primaryTelecom;
            return this;
        }

        public Builder withTelecomList(ArrayList<TelecomBaseType> telecomList) {
            this.telecomList = telecomList;
            return this;
        }
    }
}

