/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.basetypes;

import java.io.Serializable;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.projecthusky.common.enums.EntityNameUse;
import org.projecthusky.common.enums.NullFlavor;

public class NameBaseType
implements Serializable {
    private static final long serialVersionUID = -3673361087444594377L;
    private String delimiter;
    private String family;
    private String given;
    private String name;
    private NullFlavor nullFlavor;
    private String prefix;
    private String suffix;
    private EntityNameUse usage = EntityNameUse.LEGAL;

    public NameBaseType() {
    }

    private NameBaseType(Builder builder) {
        this.delimiter = builder.delimiter;
        this.family = builder.family;
        this.given = builder.given;
        this.name = builder.name;
        this.nullFlavor = builder.nullFlavor;
        this.prefix = builder.prefix;
        this.suffix = builder.suffix;
        this.usage = builder.usage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        boolean retVal = true;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NameBaseType)) {
            return false;
        }
        retVal = this.compareDelimiter((NameBaseType)obj);
        if (retVal) {
            retVal = this.compareFamily((NameBaseType)obj);
        }
        if (retVal) {
            retVal = this.compareGiven((NameBaseType)obj);
        }
        if (retVal) {
            retVal = this.comparePrefix((NameBaseType)obj);
        }
        if (retVal) {
            retVal = this.compareSuffix((NameBaseType)obj);
        }
        if (retVal) {
            retVal = this.compareUsage((NameBaseType)obj);
        }
        return retVal;
    }

    private boolean compareDelimiter(NameBaseType obj) {
        if (this.delimiter == null) {
            return obj.getDelimiter() == null;
        }
        return this.delimiter.equals(obj.getDelimiter());
    }

    private boolean compareFamily(NameBaseType obj) {
        if (this.family == null) {
            return obj.getFamily() == null;
        }
        return this.family.equals(obj.getFamily());
    }

    private boolean compareGiven(NameBaseType obj) {
        if (this.given == null) {
            return obj.getGiven() == null;
        }
        return this.given.equals(obj.getGiven());
    }

    private boolean comparePrefix(NameBaseType obj) {
        if (this.prefix == null) {
            return obj.getPrefix() == null;
        }
        return this.prefix.equals(obj.getPrefix());
    }

    private boolean compareSuffix(NameBaseType obj) {
        if (this.suffix == null) {
            return obj.getSuffix() == null;
        }
        return this.suffix.equals(obj.getSuffix());
    }

    private boolean compareUsage(NameBaseType obj) {
        if (this.usage == null) {
            return obj.getUsage() == null;
        }
        return this.usage.equals(obj.getUsage());
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        this.name = this.getFullName();
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
        this.name = this.getFullName();
    }

    public String getFullName() {
        StringBuilder sb = new StringBuilder();
        String myDelimiter = " ";
        if (this.delimiter != null) {
            myDelimiter = this.delimiter;
        }
        if (this.prefix != null) {
            sb.append(this.prefix);
            sb.append(myDelimiter);
        }
        if (this.given != null) {
            sb.append(this.given);
            sb.append(myDelimiter);
        }
        if (this.family != null) {
            sb.append(this.family);
        }
        if (this.suffix != null) {
            sb.append(myDelimiter);
            sb.append(this.suffix);
        }
        if (sb.length() != 0) {
            return sb.toString();
        }
        return this.name;
    }

    public String getGiven() {
        return this.given;
    }

    public void setGiven(String given) {
        this.given = given;
        this.name = this.getFullName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NullFlavor getNullFlavor() {
        return this.nullFlavor;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.name = this.getFullName();
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
        this.name = this.getFullName();
    }

    public EntityNameUse getUsage() {
        return this.usage;
    }

    public void setUsage(EntityNameUse usage) {
        this.usage = usage;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.delimiter).append((Object)this.family).append((Object)this.given).append((Object)this.prefix).append((Object)this.suffix).toHashCode();
    }

    public boolean isNullFlavor() {
        return this.nullFlavor != null;
    }

    public void setNullFlavor(NullFlavor nullFlavor) {
        this.nullFlavor = nullFlavor;
    }

    public String toString() {
        return this.name;
    }

    public static final class Builder {
        private String delimiter;
        private String family;
        private String given;
        private String name;
        private NullFlavor nullFlavor;
        private String prefix;
        private String suffix;
        private EntityNameUse usage;

        private Builder() {
        }

        public NameBaseType build() {
            return new NameBaseType(this);
        }

        public Builder withDelimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder withFamily(String family) {
            this.family = family;
            return this;
        }

        public Builder withGiven(String given) {
            this.given = given;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withNullFlavor(NullFlavor nullFlavor) {
            this.nullFlavor = nullFlavor;
            return this;
        }

        public Builder withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder withSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder withUsage(EntityNameUse usage) {
            this.usage = usage;
            return this;
        }
    }
}

