/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.basetypes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.utils.LangText;

public class CodeBaseType
implements Serializable {
    private static final long serialVersionUID = -7581542143784688019L;
    private String code;
    private String codeSystem;
    private String codeSystemName;
    private String codeSystemVersion;
    private List<CodeBaseType> codeTranslationList;
    private String displayName;
    private List<LangText> displayNameTranslationList;
    private NullFlavor nullFlavor;
    private String originalText;

    public CodeBaseType() {
    }

    private CodeBaseType(Builder builder) {
        this.code = builder.code;
        this.codeSystem = builder.codeSystem;
        this.codeSystemName = builder.codeSystemName;
        this.codeSystemVersion = builder.codeSystemVersion;
        this.codeTranslationList = builder.codeTranslationList;
        this.displayName = builder.displayName;
        this.displayNameTranslationList = builder.displayNameTranslationList;
        this.originalText = builder.originalText;
        this.nullFlavor = builder.nullFlavor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void addCodeTranslation(CodeBaseType codeTranslation) {
        if (this.codeTranslationList == null) {
            this.codeTranslationList = new ArrayList<CodeBaseType>();
        }
        this.codeTranslationList.add(codeTranslation);
    }

    public void addDisplayNameTranslation(LangText displayNameTranslation) {
        if (this.displayNameTranslationList == null) {
            this.displayNameTranslationList = new ArrayList<LangText>();
        }
        this.displayNameTranslationList.add(displayNameTranslation);
    }

    public void addDisplayNameTranslation(LanguageCode lang, String text) {
        this.addDisplayNameTranslation(new LangText(lang, text));
    }

    public void clearCodeTranslationList() {
        this.codeTranslationList = new ArrayList<CodeBaseType>();
    }

    public void clearDisplayNameTranslationList() {
        this.displayNameTranslationList = new ArrayList<LangText>();
    }

    public boolean contains(CodeBaseType value) {
        if (this.codeTranslationList != null) {
            for (CodeBaseType entry : this.codeTranslationList) {
                if (!entry.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(LangText value) {
        if (this.displayNameTranslationList != null) {
            for (LangText entry : this.displayNameTranslationList) {
                if (!entry.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        boolean retVal = true;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeBaseType)) {
            return false;
        }
        retVal = this.code == null ? ((CodeBaseType)obj).getCode() == null : this.code.equals(((CodeBaseType)obj).getCode());
        if (retVal) {
            retVal = this.codeSystem == null ? ((CodeBaseType)obj).getCodeSystem() == null : this.codeSystem.equals(((CodeBaseType)obj).getCodeSystem());
        }
        return retVal;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCodeSystem() {
        return this.codeSystem;
    }

    public void setCodeSystem(String codeSystem) {
        this.codeSystem = codeSystem;
    }

    public String getCodeSystemName() {
        return this.codeSystemName;
    }

    public void setCodeSystemName(String codeSystemName) {
        this.codeSystemName = codeSystemName;
    }

    public String getCodeSystemVersion() {
        return this.codeSystemVersion;
    }

    public void setCodeSystemVersion(String codeSystemVersion) {
        this.codeSystemVersion = codeSystemVersion;
    }

    public List<CodeBaseType> getCodeTranslationList() {
        if (this.codeTranslationList == null) {
            this.codeTranslationList = new ArrayList<CodeBaseType>();
        }
        return this.codeTranslationList;
    }

    public void setCodeTranslationList(List<CodeBaseType> codeTranslationList) {
        this.codeTranslationList = codeTranslationList;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public List<LangText> getDisplayNameTranslationList() {
        if (this.displayNameTranslationList == null) {
            this.displayNameTranslationList = new ArrayList<LangText>();
        }
        return this.displayNameTranslationList;
    }

    public void setDisplayNameTranslationList(List<LangText> displayNameTranslationList) {
        this.displayNameTranslationList = displayNameTranslationList;
    }

    public NullFlavor getNullFlavor() {
        return this.nullFlavor;
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public void setOriginalText(String originalText) {
        this.originalText = originalText;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.code).append((Object)this.codeSystem).toHashCode();
    }

    public boolean isNullFlavor() {
        return this.nullFlavor != null;
    }

    public void setNullFlavor(NullFlavor nullFlavor) {
        this.nullFlavor = nullFlavor;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        if (this.getCode() != null) {
            retVal.append(this.getCode() + " / ");
        } else {
            retVal.append("no code !! / ");
        }
        if (this.getCodeSystem() != null) {
            retVal.append(this.getCodeSystem());
        } else {
            retVal.append("no code system !!");
        }
        String displayNameL = this.getDisplayName();
        String codeSystemNameL = this.getCodeSystemName();
        if (displayNameL != null || codeSystemNameL != null) {
            retVal.append(" (");
            if (displayNameL != null) {
                retVal.append(displayNameL);
            }
            if (codeSystemNameL != null) {
                if (displayNameL != null) {
                    retVal.append(" / ");
                }
                retVal.append(codeSystemNameL);
            }
            retVal.append(")");
        }
        return retVal.toString();
    }

    public static final class Builder {
        private String code;
        private String codeSystem;
        private String codeSystemName;
        private String codeSystemVersion;
        private List<CodeBaseType> codeTranslationList;
        private String displayName;
        private List<LangText> displayNameTranslationList;
        private NullFlavor nullFlavor;
        private String originalText;

        private Builder() {
        }

        public CodeBaseType build() {
            return new CodeBaseType(this);
        }

        public Builder withCode(String code) {
            this.code = code;
            return this;
        }

        public Builder withCodeSystem(String codeSystem) {
            this.codeSystem = codeSystem;
            return this;
        }

        public Builder withCodeSystemName(String codeSystemName) {
            this.codeSystemName = codeSystemName;
            return this;
        }

        public Builder withCodeSystemVersion(String codeSystemVersion) {
            this.codeSystemVersion = codeSystemVersion;
            return this;
        }

        public Builder withCodeTranslationList(List<CodeBaseType> codeTranslationList) {
            this.codeTranslationList = codeTranslationList;
            return this;
        }

        public Builder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder withDisplayNameTranslationList(ArrayList<LangText> displayNameTranslationList) {
            this.displayNameTranslationList = displayNameTranslationList;
            return this;
        }

        public Builder withNullFlavor(NullFlavor nullFlavor) {
            this.nullFlavor = nullFlavor;
            return this;
        }

        public Builder withOriginalText(String originalText) {
            this.originalText = originalText;
            return this;
        }
    }
}

