/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.basetypes;

import java.io.Serializable;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.projecthusky.common.enums.NullFlavor;
import org.projecthusky.common.enums.PostalAddressUse;

public class AddressBaseType
implements Serializable {
    private static final long serialVersionUID = -5851119541693670862L;
    private String additionalLocator;
    private String buildingNumber;
    private String city;
    private String country;
    private NullFlavor nullFlavor;
    private String postalCode;
    private String postBox;
    private String state;
    private String streetAddressLine1;
    private String streetAddressLine2;
    private String streetName;
    private PostalAddressUse usage;

    public AddressBaseType() {
    }

    private AddressBaseType(Builder builder) {
        this.additionalLocator = builder.additionalLocator;
        this.buildingNumber = builder.buildingNumber;
        this.city = builder.city;
        this.country = builder.country;
        this.postalCode = builder.postalCode;
        this.postBox = builder.postBox;
        this.state = builder.state;
        this.streetAddressLine1 = builder.streetAddressLine1;
        this.streetAddressLine2 = builder.streetAddressLine2;
        this.streetName = builder.streetName;
        this.nullFlavor = builder.nullFlavor;
        this.usage = builder.usage;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object obj) {
        boolean retVal = true;
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressBaseType)) {
            return false;
        }
        retVal = this.compareAdditionalLocator((AddressBaseType)obj);
        if (retVal) {
            retVal = this.compareBuildingNumber((AddressBaseType)obj);
        }
        if (retVal) {
            retVal = this.compareCity((AddressBaseType)obj);
        }
        if (retVal) {
            retVal = this.compareCountry((AddressBaseType)obj);
        }
        if (retVal) {
            retVal = this.comparePostalCode((AddressBaseType)obj);
        }
        if (retVal) {
            retVal = this.comparePostBox((AddressBaseType)obj);
        }
        if (retVal) {
            retVal = this.compareState((AddressBaseType)obj);
        }
        if (retVal) {
            retVal = this.compareStreetAddressLine1((AddressBaseType)obj);
        }
        if (retVal) {
            retVal = this.compareStreetAddressLine2((AddressBaseType)obj);
        }
        if (retVal) {
            retVal = this.compareStreetName((AddressBaseType)obj);
        }
        if (retVal) {
            retVal = this.compareUsage((AddressBaseType)obj);
        }
        return retVal;
    }

    private boolean compareAdditionalLocator(AddressBaseType obj) {
        if (this.additionalLocator == null) {
            return obj.getAdditionalLocator() == null;
        }
        return this.additionalLocator.equals(obj.getAdditionalLocator());
    }

    private boolean compareBuildingNumber(AddressBaseType obj) {
        if (this.buildingNumber == null) {
            return obj.getBuildingNumber() == null;
        }
        return this.buildingNumber.equals(obj.getBuildingNumber());
    }

    private boolean compareCity(AddressBaseType obj) {
        if (this.city == null) {
            return obj.getCity() == null;
        }
        return this.city.equals(obj.getCity());
    }

    private boolean compareCountry(AddressBaseType obj) {
        if (this.country == null) {
            return obj.getCountry() == null;
        }
        return this.country.equals(obj.getCountry());
    }

    private boolean comparePostalCode(AddressBaseType obj) {
        if (this.postalCode == null) {
            return obj.getPostalCode() == null;
        }
        return this.postalCode.equals(obj.getPostalCode());
    }

    private boolean comparePostBox(AddressBaseType obj) {
        if (this.postBox == null) {
            return obj.getPostBox() == null;
        }
        return this.postBox.equals(obj.getPostBox());
    }

    private boolean compareState(AddressBaseType obj) {
        if (this.state == null) {
            return obj.getState() == null;
        }
        return this.state.equals(obj.getState());
    }

    private boolean compareStreetAddressLine1(AddressBaseType obj) {
        if (this.streetAddressLine1 == null) {
            return obj.getStreetAddressLine1() == null;
        }
        return this.streetAddressLine1.equals(obj.getStreetAddressLine1());
    }

    private boolean compareStreetAddressLine2(AddressBaseType obj) {
        if (this.streetAddressLine2 == null) {
            return obj.getStreetAddressLine2() == null;
        }
        return this.streetAddressLine2.equals(obj.getStreetAddressLine2());
    }

    private boolean compareStreetName(AddressBaseType obj) {
        if (this.streetName == null) {
            return obj.getStreetName() == null;
        }
        return this.streetName.equals(obj.getStreetName());
    }

    private boolean compareUsage(AddressBaseType obj) {
        if (this.usage == null) {
            return obj.getUsage() == null;
        }
        return this.usage.equals(obj.getUsage());
    }

    public String getAdditionalLocator() {
        return this.additionalLocator;
    }

    public void setAdditionalLocator(String additionalLocator) {
        this.additionalLocator = additionalLocator;
    }

    public String getBuildingNumber() {
        return this.buildingNumber;
    }

    public void setBuildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public NullFlavor getNullFlavor() {
        return this.nullFlavor;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getPostBox() {
        return this.postBox;
    }

    public void setPostBox(String postBox) {
        this.postBox = postBox;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getStreetAddressLine1() {
        return this.streetAddressLine1;
    }

    public void setStreetAddressLine1(String streetAddressLine1) {
        this.streetAddressLine1 = streetAddressLine1;
    }

    public String getStreetAddressLine2() {
        return this.streetAddressLine2;
    }

    public void setStreetAddressLine2(String streetAddressLine2) {
        this.streetAddressLine2 = streetAddressLine2;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public PostalAddressUse getUsage() {
        return this.usage;
    }

    public void setUsage(PostalAddressUse usage) {
        this.usage = usage;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.additionalLocator).append((Object)this.buildingNumber).append((Object)this.city).append((Object)this.country).append((Object)this.postalCode).append((Object)this.postBox).append((Object)this.state).append((Object)this.streetAddressLine1).append((Object)this.streetAddressLine2).append((Object)this.streetName).toHashCode();
    }

    public boolean isNullFlavor() {
        return this.nullFlavor != null;
    }

    public void setNullFlavor(NullFlavor nullFlavor) {
        this.nullFlavor = nullFlavor;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        if (this.getStreetAddressLine1() != null) {
            retVal.append(this.getStreetAddressLine1() + "\n");
        }
        if (this.getStreetAddressLine2() != null) {
            retVal.append(this.getStreetAddressLine2() + "\n");
        }
        if (this.getPostalCode() != null) {
            retVal.append(this.getPostalCode() + " ");
        }
        if (this.getCity() != null) {
            retVal.append(this.getCity() + "\n");
        }
        if (this.getState() != null) {
            retVal.append(this.getState() + "\n");
        }
        if (this.getCountry() != null) {
            retVal.append(this.getCountry() + "\n");
        }
        return retVal.toString();
    }

    public static final class Builder {
        private PostalAddressUse usage;
        private String streetName;
        private String streetAddressLine2;
        private String streetAddressLine1;
        private String state;
        private String postBox;
        private String postalCode;
        private NullFlavor nullFlavor;
        private String country;
        private String city;
        private String buildingNumber;
        private String additionalLocator;

        private Builder() {
        }

        public AddressBaseType build() {
            return new AddressBaseType(this);
        }

        public Builder withAdditionalLocator(String additionalLocator) {
            this.additionalLocator = additionalLocator;
            return this;
        }

        public Builder withBuildingNumber(String buildingNumber) {
            this.buildingNumber = buildingNumber;
            return this;
        }

        public Builder withCity(String city) {
            this.city = city;
            return this;
        }

        public Builder withCountry(String country) {
            this.country = country;
            return this;
        }

        public Builder withNullFlavor(NullFlavor nullFlavor) {
            this.nullFlavor = nullFlavor;
            return this;
        }

        public Builder withPostalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public Builder withPostBox(String postBox) {
            this.postBox = postBox;
            return this;
        }

        public Builder withState(String state) {
            this.state = state;
            return this;
        }

        public Builder withStreetAddressLine1(String streetAddressLine1) {
            this.streetAddressLine1 = streetAddressLine1;
            return this;
        }

        public Builder withStreetAddressLine2(String streetAddressLine2) {
            this.streetAddressLine2 = streetAddressLine2;
            return this;
        }

        public Builder withStreetName(String streetName) {
            this.streetName = streetName;
            return this;
        }

        public Builder withUsage(PostalAddressUse usage) {
            this.usage = usage;
            return this;
        }
    }
}

