/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.ch.enums.r202406;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum HcpSpecialisation implements ValueSetEnumInterface
{
    ALLERGOLOGY_AND_CLINICAL_IMMUNOLOGY("1019", "2.16.756.5.30.1.127.3.5", "Allergology and clinical immunology", "Allergology and clinical immunology", "Allergologie und klinische Immunologie", "Allergologie et immunologie clinique", "Allergologia e immunologia clinica"),
    ANAESTHESIOLOGY("1012", "2.16.756.5.30.1.127.3.5", "Anaesthesiology", "Anaesthesiology", "An\u00e4sthesiologie", "Anesth\u00e9siologie", "Anestesiologia"),
    ANGIOLOGY("1041", "2.16.756.5.30.1.127.3.5", "Angiology", "Angiology", "Angiologie", "Angiologie", "Angiologia"),
    CARDIAC_AND_THORACIC_VASCULAR_SURGERY("1004", "2.16.756.5.30.1.127.3.5", "Cardiac and thoracic vascular surgery", "Cardiac and thoracic vascular surgery", "Herz- und thorakale Gef\u00e4sschirurgie", "Chirurgie cardiaque et vasculaire thoracique", "Chirurgia del cuore e dei vasi toracici"),
    CARDIOLOGY("1025", "2.16.756.5.30.1.127.3.5", "Cardiology", "Cardiology", "Kardiologie", "Cardiologie", "Cardiologia"),
    CHILD_AND_ADOLESCENT_PSYCHIATRY_AND_PSYCHOTHERAPY("1027", "2.16.756.5.30.1.127.3.5", "Child and adolescent psychiatry and psychotherapy", "Child and adolescent psychiatry and psychotherapy", "Kinder- und Jugendpsychiatrie und -psychotherapie", "Psychiatrie et psychoth\u00e9rapie d\u2019enfants et d\u2019adolescents", "Psichiatria e psicoterapia infantile e dell\u2019adolescenza"),
    CHILD_AND_ADOLESCENT_PSYCHOLOGY("1055", "2.16.756.5.30.1.127.3.5", "Child and adolescent psychology", "Child and adolescent psychology", "Kinder- und Jugendpsychologie", "Psychologie des enfants et des adolescents", "Psicologia dell\u2019et\u00e0 evolutiva"),
    CHIROPRACTIC_SPECIALIST("1011", "2.16.756.5.30.1.127.3.5", "Chiropractic specialist", "Chiropractic specialist", "Fachchiropraktik", "Chiropratique sp\u00e9cialis\u00e9e", "Chiropratica specialistica"),
    CLINICAL_PHARMACOLOGY_AND_TOXICOLOGY("1029", "2.16.756.5.30.1.127.3.5", "Clinical pharmacology and toxicology", "Clinical pharmacology and toxicology", "Klinische Pharmakologie und Toxikologie", "Pharmacologie et toxicologie cliniques", "Farmacologia e tossicologia cliniche"),
    CLINICAL_PSYCHOLOGY("1056", "2.16.756.5.30.1.127.3.5", "Clinical psychology", "Clinical psychology", "Klinische Psychologie", "Psychologie clinique", "Psicologia clinica"),
    COMMUNITY_PHARMACY("1052", "2.16.756.5.30.1.127.3.5", "Community pharmacy", "Community pharmacy", "Offizinpharmazie", "Pharmacie d\u2019officine", "Farmacia d\u2019officina"),
    DERMATOLOGY_AND_VENEREOLOGY("1021", "2.16.756.5.30.1.127.3.5", "Dermatology and venereology", "Dermatology and venereology", "Dermatologie und Venerologie", "Dermatologie et v\u00e9n\u00e9r\u00e9ologie", "Dermatologia e venereologia"),
    ENDOCRINOLOGY_AND_DIABETOLOGY("1022", "2.16.756.5.30.1.127.3.5", "Endocrinology \u2013 Diabetology", "Endocrinology and diabetology", "Endokrinologie und Diabetologie", "Endocrinologie et diab\u00e9tologie", "Endocrinologia e diabetologia"),
    FORENSIC_MEDICINE("1046", "2.16.756.5.30.1.127.3.5", "Forensic medicine", "Forensic medicine", "Rechtsmedizin", "M\u00e9decine l\u00e9gale", "Medicina legale"),
    GASTROENTEROLOGY("1023", "2.16.756.5.30.1.127.3.5", "Gastroenterology", "Gastroenterology", "Gastroenterologie", "Gastroent\u00e9rologie", "Gastroenterologia"),
    GENERAL_INTERNAL_MEDICINE("1051", "2.16.756.5.30.1.127.3.5", "General internal medicine", "General internal medicine", "Allgemeine Innere Medizin", "M\u00e9decine interne g\u00e9n\u00e9rale", "Medicina interna generale"),
    GENERAL_MEDICAL_PRACTITIONER("1040", "2.16.756.5.30.1.127.3.5", "General medical practitioner", "General medical practitioner", "Praktischer Arzt/Praktische \u00c4rztin", "M\u00e9decin praticien", "Medico generico"),
    GYNAECOLOGY_AND_OBSTETRICS("1003", "2.16.756.5.30.1.127.3.5", "Gynaecology and obstetrics", "Gynaecology and obstetrics", "Gyn\u00e4kologie und Geburtshilfe", "Gyn\u00e9cologie et obst\u00e9trique", "Ginecologia e ostetricia"),
    HAEMATOLOGY("1024", "2.16.756.5.30.1.127.3.5", "Haematology", "Haematology", "H\u00e4matologie", "H\u00e9matologie", "Ematologia"),
    HAND_SURGERY("1059", "2.16.756.5.30.1.127.3.5", "Hand surgery", "Hand surgery", "Handchirurgie", "Chirurgie de la main", "Chirurgia della mano"),
    HEALTH_PSYCHOLOGY("1058", "2.16.756.5.30.1.127.3.5", "Health psychology", "Health psychology", "Gesundheitspsychologie", "Psychologie de la sant\u00e9", "Psicologia della salute"),
    HOSPITAL_PHARMACY("1053", "2.16.756.5.30.1.127.3.5", "Hospital pharmacy", "Hospital pharmacy", "Spitalpharmazie", "Pharmacie hospitali\u00e8re", "Farmacia d\u2019ospedale"),
    INFECTOLOGY("1039", "2.16.756.5.30.1.127.3.5", "Infectology", "Infectology", "Infektiologie", "Infectiologie", "Malattie infettive"),
    INTENSIVE_CARE_MEDICINE("1042", "2.16.756.5.30.1.127.3.5", "Intensive care medicine", "Intensive care medicine", "Intensivmedizin", "M\u00e9decine intensive", "Medicina intensiva"),
    MEDICAL_GENETICS("1043", "2.16.756.5.30.1.127.3.5", "Medical genetics", "Medical genetics", "Medizinische Genetik", "G\u00e9n\u00e9tique m\u00e9dicale", "Genetica medica"),
    MEDICAL_ONCOLOGY("1044", "2.16.756.5.30.1.127.3.5", "Medical oncology", "Medical oncology", "Medizinische Onkologie", "Oncologie m\u00e9dicale", "Oncologia medica"),
    NEPHROLOGY("1033", "2.16.756.5.30.1.127.3.5", "Nephrology", "Nephrology", "Nephrologie", "N\u00e9phrologie", "Nefrologia"),
    NEUROLOGY("1014", "2.16.756.5.30.1.127.3.5", "Neurology", "Neurology", "Neurologie", "Neurologie", "Neurologia"),
    NEUROPSYCHOLOGY("1057", "2.16.756.5.30.1.127.3.5", "Neuropsychology", "Neuropsychology", "Neuropsychologie", "Neuropsychologie", "Neuropsicologia"),
    NEUROSURGERY("1013", "2.16.756.5.30.1.127.3.5", "Neurosurgery", "Neurosurgery", "Neurochirurgie", "Neurochirurgie", "Neurochirurgia"),
    NUCLEAR_MEDICINE("1031", "2.16.756.5.30.1.127.3.5", "Nuclear medicine", "Nuclear medicine", "Nuklearmedizin", "M\u00e9decine nucl\u00e9aire", "Medicina nucleare"),
    OCCUPATIONAL_MEDICINE("1020", "2.16.756.5.30.1.127.3.5", "Occupational medicine", "Occupational medicine", "Arbeitsmedizin", "M\u00e9decine du travail", "Medicina del lavoro"),
    OPHTHALMOLOGY("1007", "2.16.756.5.30.1.127.3.5", "Ophthalmology", "Ophthalmology", "Ophthalmologie", "Ophtalmologie", "Oftalmologia"),
    ORAL_AND_MAXILLOFACIAL_SURGERY("1026", "2.16.756.5.30.1.127.3.5", "Oral and maxillofacial surgery", "Oral and maxillofacial surgery", "Mund-, Kiefer- und Gesichtschirurgie", "Chirurgie orale et maxillo-faciale", "Chirurgia oro-maxillo-facciale"),
    ORAL_SURGERY("1047", "2.16.756.5.30.1.127.3.5", "Oral surgery", "Oral surgery", "Oralchirurgie", "Chirurgie orale", "Chirurgia orale"),
    ORTHODONTICS("1010", "2.16.756.5.30.1.127.3.5", "Orthodontics", "Orthodontics", "Kieferorthop\u00e4die", "Orthodontie", "Ortodonzia"),
    ORTHOPAEDIC_SURGERY_AND_TRAUMATOLOGY_OF_THE_LOCOMOTOR_APPARATUS("1015", "2.16.756.5.30.1.127.3.5", "Orthopaedic surgery and traumatology of the locomotor apparatus", "Orthopaedic surgery and traumatology of the locomotor apparatus", "Orthop\u00e4dische Chirurgie und Traumatologie des Bewegungsapparates", "Chirurgie orthop\u00e9dique et traumatologie de l\u2019appareil locomoteur", "Chirurgia ortopedica e traumatologia dell\u2019apparato locomotore"),
    OTHER("1050", "2.16.756.5.30.1.127.3.5", "Other", "Other", "Andere", "Autre", "Altre"),
    OTORHINOLARYNGOLOGY("1008", "2.16.756.5.30.1.127.3.5", "Otorhinolaryngology", "Otorhinolaryngology", "Oto-Rhino-Laryngologie", "Oto-rhino-laryngologie", "Otorinolaringoiatria"),
    PAEDIATRICS("1006", "2.16.756.5.30.1.127.3.5", "Paediatrics", "Paediatrics", "Kinder- und Jugendmedizin", "P\u00e9diatrie", "Pediatria"),
    PAEDIATRIC_SURGERY("1028", "2.16.756.5.30.1.127.3.5", "Paediatric surgery", "Paediatric surgery", "Kinderchirurgie", "Chirurgie p\u00e9diatrique", "Chirurgia pediatrica"),
    PARADONTOLOGY("1048", "2.16.756.5.30.1.127.3.5", "Paradontology", "Paradontology", "Parodontologie", "Parodontologie", "Parodontologia"),
    PATHOLOGY("1009", "2.16.756.5.30.1.127.3.5", "Pathology", "Pathology", "Pathologie", "Pathologie", "Patologia"),
    PHARMACEUTICAL_MEDICINE("1045", "2.16.756.5.30.1.127.3.5", "Pharmaceutical medicine", "Pharmaceutical medicine", "Pharmazeutische Medizin", "M\u00e9decine pharmaceutique", "Medicina farmacologica"),
    PHYSICAL_MEDICINE_AND_REHABILITATION("1034", "2.16.756.5.30.1.127.3.5", "Physical medicine and rehabilitation", "Physical medicine and rehabilitation", "Physikalische Medizin und Rehabilitation", "M\u00e9decine physique et r\u00e9adaptation", "Medicina fisica e riabilitazione"),
    PLASTIC_RECONSTRUCTIVE_AND_AESTHETIC_SURGERY("1035", "2.16.756.5.30.1.127.3.5", "Plastic, reconstructive and aesthetic surgery", "Plastic, reconstructive and aesthetic surgery", "Plastische, Rekonstruktive und \u00c4sthetische Chirurgie", "Chirurgie plastique, reconstructive et esth\u00e9tique", "Chirurgia plastica, ricostruttiva ed estetica"),
    PNEUMOLOGY("1016", "2.16.756.5.30.1.127.3.5", "Pneumology", "Pneumology", "Pneumologie", "Pneumologie", "Pneumologia"),
    PREVENTION_AND_PUBLIC_HEALTH("1036", "2.16.756.5.30.1.127.3.5", "Prevention and public health", "Prevention and public health", "Pr\u00e4vention und Gesundheitswesen", "Pr\u00e9vention et sant\u00e9 publique", "Prevenzione e salute pubblica"),
    PSYCHIATRY_AND_PSYCHOTHERAPY("1017", "2.16.756.5.30.1.127.3.5", "Psychiatry and psychotherapy", "Psychiatry and psychotherapy", "Psychiatrie und Psychotherapie", "Psychiatrie et psychoth\u00e9rapie", "Psichiatria e psicoterapia"),
    PSYCHOTHERAPY("1054", "2.16.756.5.30.1.127.3.5", "Psychotherapy", "Psychotherapy", "Psychotherapie", "Psychoth\u00e9rapie", "Psicoterapia"),
    RADIOLOGY("1030", "2.16.756.5.30.1.127.3.5", "Radiology", "Radiology", "Radiologie", "Radiologie", "Radiologia"),
    RADIO_ONCOLOGY_RADIOTHERAPY("1032", "2.16.756.5.30.1.127.3.5", "Radio-oncology / radiotherapy", "Radio-oncology/radiotherapy", "Radio-Onkologie/Strahlentherapie", "Radio-oncologie/radioth\u00e9rapie", "Radio-oncologia/radioterapia"),
    RECONSTRUCTIVE_DENTISTRY("1049", "2.16.756.5.30.1.127.3.5", "Reconstructive dentistry", "Reconstructive dentistry", "Rekonstruktive Zahnmedizin", "M\u00e9decine dentaire reconstructive", "Medicina dentaria riconstruttiva"),
    RHEUMATOLOGY("1037", "2.16.756.5.30.1.127.3.5", "Rheumatology", "Rheumatology", "Rheumatologie", "Rhumatologie", "Reumatologia"),
    SURGERY("1002", "2.16.756.5.30.1.127.3.5", "Surgery", "Surgery", "Chirurgie", "Chirurgie", "Chirurgia"),
    THORACIC_SURGERY("1061", "2.16.756.5.30.1.127.3.5", "Thoracic surgery", "Thoracic surgery", "Thoraxchirurgie", "Chirurgie thoracique", "Chirurgia toracica"),
    TROPICAL_AND_TRAVEL_MEDICINE("1038", "2.16.756.5.30.1.127.3.5", "Tropical and travel medicine", "Tropical and travel medicine", "Tropen- und Reisemedizin", "M\u00e9decine tropicale et m\u00e9decine des voyages", "Medicina tropicale e medicina di viaggio"),
    UROLOGY("1018", "2.16.756.5.30.1.127.3.5", "Urology", "Urology", "Urologie", "Urologie", "Urologia"),
    VASCULAR_SURGERY("1060", "2.16.756.5.30.1.127.3.5", "Vascular surgery", "Vascular surgery", "Gef\u00e4sschirurgie", "Chirurgie vasculaire", "Chirurgia vascolare");

    public static final String ALLERGOLOGY_AND_CLINICAL_IMMUNOLOGY_CODE = "1019";
    public static final String ANAESTHESIOLOGY_CODE = "1012";
    public static final String ANGIOLOGY_CODE = "1041";
    public static final String CARDIAC_AND_THORACIC_VASCULAR_SURGERY_CODE = "1004";
    public static final String CARDIOLOGY_CODE = "1025";
    public static final String CHILD_AND_ADOLESCENT_PSYCHIATRY_AND_PSYCHOTHERAPY_CODE = "1027";
    public static final String CHILD_AND_ADOLESCENT_PSYCHOLOGY_CODE = "1055";
    public static final String CHIROPRACTIC_SPECIALIST_CODE = "1011";
    public static final String CLINICAL_PHARMACOLOGY_AND_TOXICOLOGY_CODE = "1029";
    public static final String CLINICAL_PSYCHOLOGY_CODE = "1056";
    public static final String COMMUNITY_PHARMACY_CODE = "1052";
    public static final String DERMATOLOGY_AND_VENEREOLOGY_CODE = "1021";
    public static final String ENDOCRINOLOGY_AND_DIABETOLOGY_CODE = "1022";
    public static final String FORENSIC_MEDICINE_CODE = "1046";
    public static final String GASTROENTEROLOGY_CODE = "1023";
    public static final String GENERAL_INTERNAL_MEDICINE_CODE = "1051";
    public static final String GENERAL_MEDICAL_PRACTITIONER_CODE = "1040";
    public static final String GYNAECOLOGY_AND_OBSTETRICS_CODE = "1003";
    public static final String HAEMATOLOGY_CODE = "1024";
    public static final String HAND_SURGERY_CODE = "1059";
    public static final String HEALTH_PSYCHOLOGY_CODE = "1058";
    public static final String HOSPITAL_PHARMACY_CODE = "1053";
    public static final String INFECTOLOGY_CODE = "1039";
    public static final String INTENSIVE_CARE_MEDICINE_CODE = "1042";
    public static final String MEDICAL_GENETICS_CODE = "1043";
    public static final String MEDICAL_ONCOLOGY_CODE = "1044";
    public static final String NEPHROLOGY_CODE = "1033";
    public static final String NEUROLOGY_CODE = "1014";
    public static final String NEUROPSYCHOLOGY_CODE = "1057";
    public static final String NEUROSURGERY_CODE = "1013";
    public static final String NUCLEAR_MEDICINE_CODE = "1031";
    public static final String OCCUPATIONAL_MEDICINE_CODE = "1020";
    public static final String OPHTHALMOLOGY_CODE = "1007";
    public static final String ORAL_AND_MAXILLOFACIAL_SURGERY_CODE = "1026";
    public static final String ORAL_SURGERY_CODE = "1047";
    public static final String ORTHODONTICS_CODE = "1010";
    public static final String ORTHOPAEDIC_SURGERY_AND_TRAUMATOLOGY_OF_THE_LOCOMOTOR_APPARATUS_CODE = "1015";
    public static final String OTHER_CODE = "1050";
    public static final String OTORHINOLARYNGOLOGY_CODE = "1008";
    public static final String PAEDIATRICS_CODE = "1006";
    public static final String PAEDIATRIC_SURGERY_CODE = "1028";
    public static final String PARADONTOLOGY_CODE = "1048";
    public static final String PATHOLOGY_CODE = "1009";
    public static final String PHARMACEUTICAL_MEDICINE_CODE = "1045";
    public static final String PHYSICAL_MEDICINE_AND_REHABILITATION_CODE = "1034";
    public static final String PLASTIC_RECONSTRUCTIVE_AND_AESTHETIC_SURGERY_CODE = "1035";
    public static final String PNEUMOLOGY_CODE = "1016";
    public static final String PREVENTION_AND_PUBLIC_HEALTH_CODE = "1036";
    public static final String PSYCHIATRY_AND_PSYCHOTHERAPY_CODE = "1017";
    public static final String PSYCHOTHERAPY_CODE = "1054";
    public static final String RADIOLOGY_CODE = "1030";
    public static final String RADIO_ONCOLOGY_RADIOTHERAPY_CODE = "1032";
    public static final String RECONSTRUCTIVE_DENTISTRY_CODE = "1049";
    public static final String RHEUMATOLOGY_CODE = "1037";
    public static final String SURGERY_CODE = "1002";
    public static final String THORACIC_SURGERY_CODE = "1061";
    public static final String TROPICAL_AND_TRAVEL_MEDICINE_CODE = "1038";
    public static final String UROLOGY_CODE = "1018";
    public static final String VASCULAR_SURGERY_CODE = "1060";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.8.2";
    public static final String VALUE_SET_NAME = "HCProfessional.hcSpecialisation";
    public static final String CODE_SYSTEM_ID = "2.16.756.5.30.1.127.3.5";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable HcpSpecialisation getEnum(@Nullable String code) {
        for (HcpSpecialisation x : HcpSpecialisation.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(HcpSpecialisation.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (HcpSpecialisation x : HcpSpecialisation.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private HcpSpecialisation(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

