/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.ch.enums.r202406;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum HcpProfession implements ValueSetEnumInterface
{
    ACTIVATION_THERAPY_SPECIALIST("00100", "2.16.756.5.30.1.127.3.10.9", "Aktivierungsfachfrau/Aktivierungsfachmann", "Activation therapy specialist", "Fachperson f\u00fcr Aktivierung", "sp\u00e9cialiste de l'activation", "specialista in attivazione"),
    BIOMEDICAL_ANALYST("00300", "2.16.756.5.30.1.127.3.10.9", "Biomedizinische Analytikerin/Biomedizinischer Analytiker", "Biomedical analyst", "Biomedizinischer Analytiker/Biomedizinische Analytikerin", "technicien(ne) en analyses biom\u00e9dicales", "tecnico(-a) in analisi biomediche"),
    CHIROPRACTOR("3842006", "2.16.840.1.113883.6.96", "Chiropractor (occupation)", "Chiropractor", "Chiropraktiker/Chiropraktikerin", "chiropraticien(ne)", "chiropratico(-a)"),
    DENTAL_HYGIENIST("00400", "2.16.756.5.30.1.127.3.10.9", "Dental hygienist", "Dental hygienist", "Dentalhygieniker/Dentalhygienikerin", "hygi\u00e9niste dentaire", "igienista dentale"),
    DENTIST("106289002", "2.16.840.1.113883.6.96", "Dentist (occupation)", "Dentist", "Zahnarzt/Zahn\u00e4rztin", "dentiste", "dentista"),
    DIETITIAN("159033005", "2.16.840.1.113883.6.96", "Dietitian (occupation)", "Dietitian", "Ern\u00e4hrungsberater/Ern\u00e4hrungsberaterin", "di\u00e9t\u00e9ticien(ne)", "dietista"),
    DRUGGIST("00500", "2.16.756.5.30.1.127.3.10.9", "Drogist/Drogistin", "Druggist", "Drogist/Drogistin", "droguiste", "droghiere(-a)"),
    HEALTHCARE_ASSISTANT("00700", "2.16.756.5.30.1.127.3.10.9", "Fachfrau Gesundheit/Fachmann Gesundheit", "Healthcare assistant", "Fachperson Gesundheit", "assistant(e) en soins et sant\u00e9 communautaire", "operatore(-trice) sociosanitario"),
    MEDICAL_MASSEUR("00900", "2.16.756.5.30.1.127.3.10.9", "Medizinische Masseurin/Medizinischer Masseur", "Medical masseur", "Medizinischer Masseur/Medizinische Masseurin", "masseur(-euse) m\u00e9dical", "massaggiatore(-trice) medicale"),
    MEDICAL_TECHNICAL_RADIOLOGY_ASSISTANT("00600", "2.16.756.5.30.1.127.3.10.9", "Fachfrau f\u00fcr medizinisch-technische Radiologie/Fachmann f\u00fcr medizinisch-technische Radiologie", "Medical-technical radiology assistant", "Fachperson f\u00fcr medizinisch-technische Radiologie", "technicien(ne) en radiologie m\u00e9dicale", "tecnico(-a) di radiologia medica"),
    NATUROPATHIC_PRACTITIONER("01000", "2.16.756.5.30.1.127.3.10.9", "Naturheilpraktikerin/Naturheilpraktiker", "Naturopathic practitioner", "Naturheilpraktiker/Naturheilpraktikerin", "naturopathe", "naturopata"),
    OCCUPATIONAL_THERAPIST("80546007", "2.16.840.1.113883.6.96", "Occupational therapist (occupation)", "Occupational therapist", "Ergotherapeut/Ergotherapeutin", "ergoth\u00e9rapeute", "ergoterapista"),
    OPERATING_ROOM_TECHNICIAN("00800", "2.16.756.5.30.1.127.3.10.9", "Fachfrau Operationstechnik/Fachmann Operationstechnik", "Operating room technician", "Fachperson Operationstechnik", "technicien(ne) en salle d'op\u00e9ration", "tecnico(-a) di sala operatoria"),
    OPTICIAN("00200", "2.16.756.5.30.1.127.3.10.9", "Optician", "Optician", "Optiker/Optikerin", "opticien(ne)", "ottico(-a)"),
    OPTOMETRIST("01100", "2.16.756.5.30.1.127.3.10.9", "Optometrist", "Optometrist", "Optometrist/Optometristin", "optom\u00e9triste", "optometrista"),
    ORTHOPTIST("01200", "2.16.756.5.30.1.127.3.10.9", "Orthoptist", "orthoptist", "Orthoptist/Orthoptistin", "orthoptiste", "ortottista"),
    OSTEOPATH("01300", "2.16.756.5.30.1.127.3.10.9", "Osteopath", "Osteopath", "Osteopath/Osteopathin", "ost\u00e9opathe", "osteopata"),
    OTHER("00000", "2.16.756.5.30.1.127.3.10.9", "Other", "Other", "Andere", "autre", "altro"),
    PARAMEDIC("01500", "2.16.756.5.30.1.127.3.10.9", "Rettungssanit\u00e4terin/Rettungssanit\u00e4ter", "Paramedic", "Rettungssanit\u00e4ter/Rettungssanit\u00e4terin", "ambulancier(-\u00e8re)", "soccorritore(-trice)"),
    PHARMACIST("46255001", "2.16.840.1.113883.6.96", "Pharmacist (occupation)", "Pharmacist", "Apotheker/Apothekerin", "pharmacien(ne)", "farmacista"),
    PHYSICIAN("309343006", "2.16.840.1.113883.6.96", "Physician (occupation)", "Physician", "Arzt/\u00c4rztin", "m\u00e9decin", "medico"),
    PHYSIOTHERAPIST("36682004", "2.16.840.1.113883.6.96", "Physiotherapist (occupation)", "Physiotherapist", "Physiotherapeut/Physiotherapeutin", "physioth\u00e9rapeute", "fisioterapista"),
    PODIATRIST("01400", "2.16.756.5.30.1.127.3.10.9", "Podologin/Podologe", "Podiatrist", "Podologe/Podologin", "podologue", "podologo(-a)"),
    PROFESSIONAL_NURSE("106292003", "2.16.840.1.113883.6.96", "Professional nurse (occupation)", "Professional nurse", "Pflegefachmann/Pflegefachfrau", "infirmier(-\u00e8re)", "infermiere(-a)"),
    PSYCHOLOGIST("59944000", "2.16.840.1.113883.6.96", "Psychologist (occupation)", "Psychologist", "Psychologe/Psychologin", "psychologue", "psicologo(-a)"),
    REGISTERED_MIDWIFE("309453006", "2.16.840.1.113883.6.96", "Registered midwife (occupation)", "Registered midwife", "Registrierte Hebamme", "sage-femme", "levatrice"),
    SPEECH_LANGUAGE_THERAPIST("159026005", "2.16.840.1.113883.6.96", "Speech/language therapist (occupation)", "Speech/language therapist", "Sprachtherapeut/Sprachtherapeutin", "orthophoniste", "logopedista");

    public static final String ACTIVATION_THERAPY_SPECIALIST_CODE = "00100";
    public static final String BIOMEDICAL_ANALYST_CODE = "00300";
    public static final String CHIROPRACTOR_CODE = "3842006";
    public static final String DENTAL_HYGIENIST_CODE = "00400";
    public static final String DENTIST_CODE = "106289002";
    public static final String DIETITIAN_CODE = "159033005";
    public static final String DRUGGIST_CODE = "00500";
    public static final String HEALTHCARE_ASSISTANT_CODE = "00700";
    public static final String MEDICAL_MASSEUR_CODE = "00900";
    public static final String MEDICAL_TECHNICAL_RADIOLOGY_ASSISTANT_CODE = "00600";
    public static final String NATUROPATHIC_PRACTITIONER_CODE = "01000";
    public static final String OCCUPATIONAL_THERAPIST_CODE = "80546007";
    public static final String OPERATING_ROOM_TECHNICIAN_CODE = "00800";
    public static final String OPTICIAN_CODE = "00200";
    public static final String OPTOMETRIST_CODE = "01100";
    public static final String ORTHOPTIST_CODE = "01200";
    public static final String OSTEOPATH_CODE = "01300";
    public static final String OTHER_CODE = "00000";
    public static final String PARAMEDIC_CODE = "01500";
    public static final String PHARMACIST_CODE = "46255001";
    public static final String PHYSICIAN_CODE = "309343006";
    public static final String PHYSIOTHERAPIST_CODE = "36682004";
    public static final String PODIATRIST_CODE = "01400";
    public static final String PROFESSIONAL_NURSE_CODE = "106292003";
    public static final String PSYCHOLOGIST_CODE = "59944000";
    public static final String REGISTERED_MIDWIFE_CODE = "309453006";
    public static final String SPEECH_LANGUAGE_THERAPIST_CODE = "159026005";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.8.1";
    public static final String VALUE_SET_NAME = "HCProfessional.hcProfession";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable HcpProfession getEnum(@Nullable String code) {
        for (HcpProfession x : HcpProfession.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(HcpProfession.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (HcpProfession x : HcpProfession.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private HcpProfession(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

