/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.common.ch.enums.r202104;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum DocumentLanguage implements ValueSetEnumInterface
{
    ARABIC("ar", "2.16.840.1.113883.6.316", "Arabic", "Arabic", "Arabisch", "Arabe", "Arabo"),
    BENGALI("bn", "2.16.840.1.113883.6.316", "Bengali", "Bengali", "Bengalisch", "Bengali", "Bengalese"),
    CHINESE("zh", "2.16.840.1.113883.6.316", "Chinese", "Chinese", "Chinesisch", "Chinois", "Cinese"),
    CHINESE_CHINA("zh-CN", "2.16.840.1.113883.6.316", "Chinese (China)", "Chinese (China)", "Chinesisch (China)", "Chinois (Chine)", "Cinese (Cina)"),
    CHINESE_HONG_KONG("zh-HK", "2.16.840.1.113883.6.316", "Chinese (Hong Kong)", "Chinese (Hong Kong)", "Chinesisch (Hong Kong)", "Chinois (Hong Kong)", "Cinese (Hong Kong)"),
    CHINESE_SINGAPORE("zh-SG", "2.16.840.1.113883.6.316", "Chinese (Singapore)", "Chinese (Singapore)", "Chinesisch (Singapur)", "Chinois (Singapour)", "Cinese (Singapore)"),
    CHINESE_TAIWAN("zh-TW", "2.16.840.1.113883.6.316", "Chinese (Taiwan)", "Chinese (Taiwan)", "Chinesisch (Taiwan)", "Chinois (Ta\u00efwan)", "Cinese (Taiwan)"),
    CROATIAN("hr", "2.16.840.1.113883.6.316", "Croatian", "Croatian", "Kroatisch", "Croate", "Croato"),
    CZECH("cs", "2.16.840.1.113883.6.316", "Czech", "Czech", "Tschechisch", "Tch\u00e8que", "Ceco"),
    DANISH("da", "2.16.840.1.113883.6.316", "Danish", "Danish", "D\u00e4nisch", "Danois", "Danese"),
    DUTCH("nl", "2.16.840.1.113883.6.316", "Dutch", "Dutch", "Niederl\u00e4ndisch", "N\u00e9erlandais", "Olandese"),
    DUTCH_BELGIUM("nl-BE", "2.16.840.1.113883.6.316", "Dutch (Belgium)", "Dutch (Belgium)", "Niederl\u00e4ndisch (Belgien)", "N\u00e9erlandais (Belgique)", "Olandese (Belgio)"),
    DUTCH_NETHERLANDS("nl-NL", "2.16.840.1.113883.6.316", "Dutch (Netherlands)", "Dutch (Netherlands)", "Niederl\u00e4ndisch (Niederlande)", "N\u00e9erlandais (Pays-Bas)", "Olandese (Paesi Bassi)"),
    ENGLISH("en", "2.16.840.1.113883.6.316", "English", "English", "Englisch", "Anglais", "Inglese"),
    ENGLISH_AUSTRALIA("en-AU", "2.16.840.1.113883.6.316", "English (Australia)", "English (Australia)", "Englisch (Australien)", "Anglais (Australie)", "Inglese (Australia)"),
    ENGLISH_CANADA("en-CA", "2.16.840.1.113883.6.316", "English (Canada)", "English (Canada)", "Englisch (Kanada)", "Anglais (Canada)", "Inglese (Canada)"),
    ENGLISH_GREAT_BRITAIN("en-GB", "2.16.840.1.113883.6.316", "English (Great Britain)", "English (Great Britain)", "Englisch (Grossbritannien)", "Anglais (Grande Bretagne)", "Inglese (Gran Bretagna)"),
    ENGLISH_INDIA("en-IN", "2.16.840.1.113883.6.316", "English (India)", "English (India)", "Englisch (Indien)", "Anglais (Inde)", "Inglese (India)"),
    ENGLISH_NEW_ZEALAND("en-NZ", "2.16.840.1.113883.6.316", "English (New Zealand)", "English (New Zealand)", "Englisch (Neuseeland)", "Anglais (Nouvelle Z\u00e9lande)", "Inglese (Nuova Zelanda)"),
    ENGLISH_SINGAPORE("en-SG", "2.16.840.1.113883.6.316", "English (Singapore)", "English (Singapore)", "Englisch (Singapur)", "Anglais (Singapour)", "Inglese (Singapore)"),
    ENGLISH_UNITED_STATES("en-US", "2.16.840.1.113883.6.316", "English (United States)", "English (United States)", "Englisch (USA)", "Anglais (\u00c9tats Unis)", "Inglese (Stati Uniti)"),
    FINNISH("fi", "2.16.840.1.113883.6.316", "Finnish", "Finnish", "Finnisch", "Finnois", "Finlandese"),
    FRENCH("fr", "2.16.840.1.113883.6.316", "French", "French", "Franz\u00f6sisch", "Fran\u00e7ais", "Francese"),
    FRENCH_BELGIUM("fr-BE", "2.16.840.1.113883.6.316", "French (Belgium)", "French (Belgium)", "Franz\u00f6sisch (Belgien)", "Fran\u00e7ais (Belgique)", "Francese (Belgio)"),
    FRENCH_FRANCE("fr-FR", "2.16.840.1.113883.6.316", "French (France)", "French (France)", "Franz\u00f6sisch (Frankreich)", "Fran\u00e7ais (France)", "Francese (Francia)"),
    FRENCH_SWITZERLAND("fr-CH", "2.16.840.1.113883.6.316", "French (Switzerland)", "French (Switzerland)", "Franz\u00f6sisch (Schweiz)", "Fran\u00e7ais (Suisse)", "Francese (Svizzera)"),
    FRYSIAN("fy", "2.16.840.1.113883.6.316", "Frysian", "Frysian", "Friesisch", "Frison", "Frisone"),
    FRYSIAN_NETHERLANDS("fy-NL", "2.16.840.1.113883.6.316", "Frysian (Netherlands)", "Frysian (Netherlands)", "Friesisch (Niederlande)", "Frison (Pays-Bas)", "Frisone (Paesi Bassi)"),
    GERMAN("de", "2.16.840.1.113883.6.316", "German", "German", "Deutsch", "Allemand", "Tedesco"),
    GERMAN_AUSTRIA("de-AT", "2.16.840.1.113883.6.316", "German (Austria)", "German (Austria)", "Deutsch (\u00d6sterreich)", "Allemand (Autriche)", "Tedesco (Austria)"),
    GERMAN_GERMANY("de-DE", "2.16.840.1.113883.6.316", "German (Germany)", "German (Germany)", "Deutsch (Deutschland)", "Allemand (Allemagne)", "Tedesco (Germania)"),
    GERMAN_SWITZERLAND("de-CH", "2.16.840.1.113883.6.316", "German (Switzerland)", "German (Switzerland)", "Deutsch (Schweiz)", "Allemand (Suisse)", "Tedesco (Svizzera)"),
    GREEK("el", "2.16.840.1.113883.6.316", "Greek", "Greek", "Griechisch", "Grec", "Greco"),
    HINDI("hi", "2.16.840.1.113883.6.316", "Hindi", "Hindi", "Hindi", "Hindi", "Hindi"),
    ITALIAN("it", "2.16.840.1.113883.6.316", "Italian", "Italian", "Italienisch", "Italien", "Italiano"),
    ITALIAN_ITALY("it-IT", "2.16.840.1.113883.6.316", "Italian (Italy)", "Italian (Italy)", "Italienisch (Italien)", "Italien (Italie)", "Italiano (Italia)"),
    ITALIAN_SWITZERLAND("it-CH", "2.16.840.1.113883.6.316", "Italian (Switzerland)", "Italian (Switzerland)", "Italienisch (Schweiz)", "Italien (Suisse)", "Italiano (Svizzera)"),
    JAPANESE("ja", "2.16.840.1.113883.6.316", "Japanese", "Japanese", "Japanisch", "Japonais", "Giapponese"),
    KOREAN("ko", "2.16.840.1.113883.6.316", "Korean", "Korean", "Koreanisch", "Cor\u00e9en", "Coreano"),
    NORWEGIAN("no", "2.16.840.1.113883.6.316", "Norwegian", "Norwegian", "Norwegisch", "Norv\u00e9gien", "Norvegese"),
    NORWEGIAN_NORWAY("no-NO", "2.16.840.1.113883.6.316", "Norwegian (Norway)", "Norwegian (Norway)", "Norwegisch (Norwegen)", "Norv\u00e9gien (Norv\u00e8ge)", "Norvegese (Norvegia)"),
    OTHER_LANGUAGE("OTHER", "2.16.756.5.30.1.127.3.10.12", "Other language", "Other language", "Andere Sprache", "Autre langue", "Altra lingua"),
    POLISH("pl", "2.16.840.1.113883.6.316", "Polish", "Polish", "Polnisch", "Polonais", "Polacco"),
    PORTUGUESE("pt", "2.16.840.1.113883.6.316", "Portuguese", "Portuguese", "Portugiesisch", "Portugais", "Portoghese"),
    PORTUGUESE_BRAZIL("pt-BR", "2.16.840.1.113883.6.316", "Portuguese (Brazil)", "Portuguese (Brazil)", "Portugiesisch (Brasilien)", "Portugais (Br\u00e9sil)", "Portoghese (Brasile)"),
    PUNJABI("pa", "2.16.840.1.113883.6.316", "Punjabi", "Punjabi", "Panjabi", "Panjabi", "Panjabi"),
    ROMANSH("rm", "2.16.840.1.113883.6.316", "Romansh", "Romansh", "R\u00e4toromanisch", "Rh\u00e9to-roman", "Romancio"),
    RUSSIAN("ru", "2.16.840.1.113883.6.316", "Russian", "Russian", "Russisch", "Russe", "Russo"),
    RUSSIAN_RUSSIA("ru-RU", "2.16.840.1.113883.6.316", "Russian (Russia)", "Russian (Russia)", "Russisch (Russland)", "Russe (Russie)", "Russo (Russia)"),
    SERBIAN("sr", "2.16.840.1.113883.6.316", "Serbian", "Serbian", "Serbisch", "Serbe", "Serbo"),
    SERBIAN_SERBIA("sr-RS", "2.16.840.1.113883.6.316", "Serbian (Serbia)", "Serbian (Serbia)", "Serbisch (Serbien)", "Serbe (Serbie)", "Serbo (Serbia)"),
    SPANISH("es", "2.16.840.1.113883.6.316", "Spanish", "Spanish", "Spanisch", "Espagnol", "Spagnolo"),
    SPANISH_ARGENTINA("es-AR", "2.16.840.1.113883.6.316", "Spanish (Argentina)", "Spanish (Argentina)", "Spanisch (Argentinien)", "Espagnol (Argentine)", "Spagnolo (Argentina)"),
    SPANISH_SPAIN("es-ES", "2.16.840.1.113883.6.316", "Spanish (Spain)", "Spanish (Spain)", "Spanisch (Spanien)", "Espagnol (Espagne)", "Spagnolo (Spagna)"),
    SPANISH_URUGUAY("es-UY", "2.16.840.1.113883.6.316", "Spanish (Uruguay)", "Spanish (Uruguay)", "Spanisch (Uruguay)", "Espagnol (Uruguay)", "Spagnolo (Uruguay)"),
    SWEDISH("sv", "2.16.840.1.113883.6.316", "Swedish", "Swedish", "Schwedisch", "Su\u00e9dois", "Svedese"),
    SWEDISH_SWEDEN("sv-SE", "2.16.840.1.113883.6.316", "Swedish (Sweden)", "Swedish (Sweden)", "Schwedisch (Schweden)", "Su\u00e9dois (Su\u00e8de)", "Svedese (Svezia)"),
    TELEGU("te", "2.16.840.1.113883.6.316", "Telegu", "Telegu", "Telugu", "Telugu", "Telugu");

    public static final String ARABIC_CODE = "ar";
    public static final String BENGALI_CODE = "bn";
    public static final String CHINESE_CODE = "zh";
    public static final String CHINESE_CHINA_CODE = "zh-CN";
    public static final String CHINESE_HONG_KONG_CODE = "zh-HK";
    public static final String CHINESE_SINGAPORE_CODE = "zh-SG";
    public static final String CHINESE_TAIWAN_CODE = "zh-TW";
    public static final String CROATIAN_CODE = "hr";
    public static final String CZECH_CODE = "cs";
    public static final String DANISH_CODE = "da";
    public static final String DUTCH_CODE = "nl";
    public static final String DUTCH_BELGIUM_CODE = "nl-BE";
    public static final String DUTCH_NETHERLANDS_CODE = "nl-NL";
    public static final String ENGLISH_CODE = "en";
    public static final String ENGLISH_AUSTRALIA_CODE = "en-AU";
    public static final String ENGLISH_CANADA_CODE = "en-CA";
    public static final String ENGLISH_GREAT_BRITAIN_CODE = "en-GB";
    public static final String ENGLISH_INDIA_CODE = "en-IN";
    public static final String ENGLISH_NEW_ZEALAND_CODE = "en-NZ";
    public static final String ENGLISH_SINGAPORE_CODE = "en-SG";
    public static final String ENGLISH_UNITED_STATES_CODE = "en-US";
    public static final String FINNISH_CODE = "fi";
    public static final String FRENCH_CODE = "fr";
    public static final String FRENCH_BELGIUM_CODE = "fr-BE";
    public static final String FRENCH_FRANCE_CODE = "fr-FR";
    public static final String FRENCH_SWITZERLAND_CODE = "fr-CH";
    public static final String FRYSIAN_CODE = "fy";
    public static final String FRYSIAN_NETHERLANDS_CODE = "fy-NL";
    public static final String GERMAN_CODE = "de";
    public static final String GERMAN_AUSTRIA_CODE = "de-AT";
    public static final String GERMAN_GERMANY_CODE = "de-DE";
    public static final String GERMAN_SWITZERLAND_CODE = "de-CH";
    public static final String GREEK_CODE = "el";
    public static final String HINDI_CODE = "hi";
    public static final String ITALIAN_CODE = "it";
    public static final String ITALIAN_ITALY_CODE = "it-IT";
    public static final String ITALIAN_SWITZERLAND_CODE = "it-CH";
    public static final String JAPANESE_CODE = "ja";
    public static final String KOREAN_CODE = "ko";
    public static final String NORWEGIAN_CODE = "no";
    public static final String NORWEGIAN_NORWAY_CODE = "no-NO";
    public static final String OTHER_LANGUAGE_CODE = "OTHER";
    public static final String POLISH_CODE = "pl";
    public static final String PORTUGUESE_CODE = "pt";
    public static final String PORTUGUESE_BRAZIL_CODE = "pt-BR";
    public static final String PUNJABI_CODE = "pa";
    public static final String ROMANSH_CODE = "rm";
    public static final String RUSSIAN_CODE = "ru";
    public static final String RUSSIAN_RUSSIA_CODE = "ru-RU";
    public static final String SERBIAN_CODE = "sr";
    public static final String SERBIAN_SERBIA_CODE = "sr-RS";
    public static final String SPANISH_CODE = "es";
    public static final String SPANISH_ARGENTINA_CODE = "es-AR";
    public static final String SPANISH_SPAIN_CODE = "es-ES";
    public static final String SPANISH_URUGUAY_CODE = "es-UY";
    public static final String SWEDISH_CODE = "sv";
    public static final String SWEDISH_SWEDEN_CODE = "sv-SE";
    public static final String TELEGU_CODE = "te";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.3.10.1.13";
    public static final String VALUE_SET_NAME = "DocumentEntry.languageCode";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable DocumentLanguage getEnum(@Nullable String code) {
        for (DocumentLanguage x : DocumentLanguage.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(DocumentLanguage.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (DocumentLanguage x : DocumentLanguage.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private DocumentLanguage(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

