/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.xacml20.chppq1;

import org.apache.camel.Exchange;
import org.openehealth.ipf.commons.ihe.xacml20.chppq1.ChPpq1PortType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.UnknownPolicySetIdFaultMessage;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.AddPolicyRequest;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.AssertionBasedRequestType;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.DeletePolicyRequest;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.EprPolicyRepositoryResponse;
import org.openehealth.ipf.commons.ihe.xacml20.stub.ehealthswiss.UpdatePolicyRequest;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.ws.AbstractWebService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChPpq1Service
extends AbstractWebService
implements ChPpq1PortType {
    private static final Logger log = LoggerFactory.getLogger(ChPpq1Service.class);

    public EprPolicyRepositoryResponse addPolicy(AddPolicyRequest request) {
        try {
            return this.processPolicyRequest(request);
        }
        catch (UnknownPolicySetIdFaultMessage unknownPolicySetIdFaultMessage) {
            return ChPpq1Service.errorResponse();
        }
    }

    public EprPolicyRepositoryResponse updatePolicy(UpdatePolicyRequest request) throws UnknownPolicySetIdFaultMessage {
        return this.processPolicyRequest(request);
    }

    public EprPolicyRepositoryResponse deletePolicy(DeletePolicyRequest request) throws UnknownPolicySetIdFaultMessage {
        return this.processPolicyRequest(request);
    }

    private static EprPolicyRepositoryResponse errorResponse() {
        EprPolicyRepositoryResponse repositoryResponse = new EprPolicyRepositoryResponse();
        repositoryResponse.setStatus("urn:e-health-suisse:2015:response-status:failure");
        return repositoryResponse;
    }

    private <T extends AssertionBasedRequestType> EprPolicyRepositoryResponse processPolicyRequest(T request) throws UnknownPolicySetIdFaultMessage {
        Exchange result = this.process(request);
        Exception exception = Exchanges.extractException((Exchange)result);
        if (exception != null) {
            log.debug(((Object)((Object)this)).getClass().getSimpleName() + " service failed", (Throwable)exception);
            if (exception instanceof UnknownPolicySetIdFaultMessage) {
                throw (UnknownPolicySetIdFaultMessage)((Object)exception);
            }
            return ChPpq1Service.errorResponse();
        }
        return (EprPolicyRepositoryResponse)result.getMessage().getBody(EprPolicyRepositoryResponse.class);
    }
}

