/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hl7v3.iti55;

import groovy.xml.slurpersupport.GPathResult;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.xml.ws.handler.MessageContext;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.support.DefaultExchange;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.openehealth.ipf.commons.ihe.hl7v3.Hl7v3Exception;
import org.openehealth.ipf.commons.ihe.hl7v3.Hl7v3InteractionId;
import org.openehealth.ipf.commons.ihe.hl7v3.Hl7v3NakFactory;
import org.openehealth.ipf.commons.ihe.hl7v3.Hl7v3Utils;
import org.openehealth.ipf.commons.ihe.hl7v3.Hl7v3WsTransactionConfiguration;
import org.openehealth.ipf.commons.ihe.hl7v3.XCPD;
import org.openehealth.ipf.commons.ihe.hl7v3.iti55.Iti55PortType;
import org.openehealth.ipf.commons.ihe.hl7v3.iti55.Iti55Utils;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.AbstractAuditInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.hl7v3.AbstractHl7v3WebService;
import org.openehealth.ipf.platform.camel.ihe.hl7v3.Hl7v3Endpoint;
import org.openehealth.ipf.platform.camel.ihe.ws.AbstractWsEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Iti55Service
extends AbstractHl7v3WebService
implements Iti55PortType {
    private static final transient Logger LOG = LoggerFactory.getLogger(Iti55Service.class);
    private final ProducerTemplate producerTemplate;
    private final ExecutorService executorService;
    private final Hl7v3Endpoint<Hl7v3WsTransactionConfiguration> endpoint;
    private final CamelContext camelContext;

    Iti55Service(Hl7v3Endpoint<Hl7v3WsTransactionConfiguration> endpoint) {
        super((Hl7v3InteractionId<? extends Hl7v3WsTransactionConfiguration>)XCPD.Interactions.ITI_55);
        this.endpoint = endpoint;
        this.camelContext = endpoint.getCamelContext();
        this.producerTemplate = this.camelContext.createProducerTemplate();
        this.executorService = this.getDeferredResponseExecutorService();
    }

    private ExecutorService getDeferredResponseExecutorService() {
        ExecutorServiceManager manager = this.camelContext.getExecutorServiceManager();
        ExecutorService result = manager.newThreadPool((Object)this, "iti55.deferred.response", "iti55.deferred.response");
        if (result == null) {
            result = manager.newDefaultThreadPool((Object)this, "iti55.deferred.response");
        }
        return result;
    }

    public String discoverPatients(String requestString) {
        return this.doProcess(requestString);
    }

    public String discoverPatientsDeferred(String requestString) {
        return this.doProcess(requestString);
    }

    @Override
    protected String doProcess(String request) {
        String requestString = request;
        GPathResult requestXml = Hl7v3Utils.slurp((String)requestString);
        String processingMode = Iti55Utils.processingMode((GPathResult)requestXml);
        if ("I".equals(processingMode)) {
            String response = this.doProcess0(requestString, requestXml);
            Iti55Service.configureWsaAction("urn:hl7-org:v3:PRPA_IN201306UV02:CrossGatewayPatientDiscovery");
            return response;
        }
        if ("D".equals(processingMode)) {
            String requestMessageId;
            String deferredResponseUri = Iti55Utils.normalizedDeferredResponseUri((GPathResult)requestXml);
            if (deferredResponseUri == null) {
                Hl7v3Exception hl7v3Exception = new Hl7v3Exception("Deferred response URI is missing or not HTTP(S)");
                hl7v3Exception.setTypeCode("AE");
                hl7v3Exception.setAcknowledgementDetailCode("SYN105");
                hl7v3Exception.setQueryResponseCode("AE");
                return this.createNak(requestXml, (Throwable)hl7v3Exception);
            }
            WrappedMessageContext messageContext = (WrappedMessageContext)new WebServiceContextImpl().getMessageContext();
            AddressingProperties apropos = (AddressingProperties)messageContext.get((Object)"javax.xml.ws.addressing.context.inbound");
            String string = requestMessageId = apropos != null && apropos.getMessageID() != null ? apropos.getMessageID().getValue() : null;
            if (requestMessageId == null) {
                LOG.warn("Cannot determine WS-Addressing ID of the request message");
            }
            WsAuditDataset auditDataset = (WsAuditDataset)messageContext.getWrappedMessage().getContextualProperty(AbstractAuditInterceptor.DATASET_CONTEXT_KEY);
            Map mdcContextMap = MDC.getCopyOfContextMap();
            Runnable processRouteAndNotifyTask = () -> {
                try {
                    MDC.setContextMap((Map)mdcContextMap);
                    WebServiceContextImpl.setMessageContext((MessageContext)messageContext);
                    String result = this.doProcess0(requestString, requestXml);
                    DefaultExchange exchange = new DefaultExchange(this.camelContext);
                    exchange.getIn().setBody((Object)result);
                    exchange.getIn().setHeader("iti55.deferred.requestMessageId", (Object)requestMessageId);
                    exchange.getIn().setHeader("iti55.deferred.auditDataset", (Object)auditDataset);
                    AbstractWsEndpoint responseEndpoint = (AbstractWsEndpoint)this.camelContext.getEndpoint(deferredResponseUri);
                    responseEndpoint.setAuditContext(this.endpoint.getAuditContext());
                    exchange = this.producerTemplate.send((Endpoint)responseEndpoint, (Exchange)exchange);
                    Exception exception = Exchanges.extractException((Exchange)exchange);
                    if (exception != null) {
                        LOG.error("Sending deferred response failed", (Throwable)exception);
                    }
                }
                finally {
                    MDC.clear();
                }
            };
            this.executorService.submit(processRouteAndNotifyTask);
            Iti55Service.configureWsaAction("urn:hl7-org:v3:MCCI_IN000002UV01");
            return Hl7v3NakFactory.response((GPathResult)requestXml, null, (String)"MCCI_IN000002UV01", null, (boolean)false, (boolean)this.getWsTransactionConfiguration().isIncludeQuantities());
        }
        Hl7v3Exception hl7v3Exception = new Hl7v3Exception(String.format("Unsupported processing mode '%s'", processingMode));
        hl7v3Exception.setTypeCode("AE");
        hl7v3Exception.setAcknowledgementDetailCode("NS250");
        hl7v3Exception.setQueryResponseCode("AE");
        return this.createNak(requestXml, (Throwable)hl7v3Exception);
    }

    private String doProcess0(String requestString, GPathResult requestXml) {
        Exchange result = this.process(requestString);
        Exception exception = Exchanges.extractException((Exchange)result);
        return exception != null ? this.nak(exception, requestXml) : (String)result.getMessage().getBody(String.class);
    }

    private String nak(Exception exception, GPathResult requestXml) {
        Hl7v3Exception hl7v3Exception;
        if (exception instanceof Hl7v3Exception) {
            hl7v3Exception = (Hl7v3Exception)exception;
        } else {
            hl7v3Exception = new Hl7v3Exception(exception.getMessage(), (Throwable)exception);
            hl7v3Exception.setDetectedIssueManagementCode("InternalError");
            hl7v3Exception.setDetectedIssueManagementCodeSystem("1.3.6.1.4.1.19376.1.2.27.3");
        }
        return this.createNak(requestXml, (Throwable)hl7v3Exception);
    }

    private static void configureWsaAction(String action) {
        WrappedMessageContext messageContext = (WrappedMessageContext)new WebServiceContextImpl().getMessageContext();
        Message outMessage = messageContext.getWrappedMessage().getExchange().getOutMessage();
        if (outMessage == null) {
            return;
        }
        AddressingProperties apropos = (AddressingProperties)outMessage.get((Object)"javax.xml.ws.addressing.context.outbound");
        if (apropos == null) {
            apropos = new AddressingProperties();
            outMessage.put((Object)"javax.xml.ws.addressing.context.outbound", (Object)apropos);
        }
        AttributedURIType actionHolder = new AttributedURIType();
        actionHolder.setValue(action);
        apropos.setAction(actionHolder);
    }
}

