/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hl7v3.iti55;

import groovy.xml.slurpersupport.GPathResult;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import org.apache.camel.Exchange;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.openehealth.ipf.commons.ihe.hl7v3.Hl7v3Utils;
import org.openehealth.ipf.commons.ihe.hl7v3.Hl7v3WsTransactionConfiguration;
import org.openehealth.ipf.commons.ihe.hl7v3.audit.Hl7v3AuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v3.iti55.Iti55PortType;
import org.openehealth.ipf.commons.ihe.hl7v3.iti55.Iti55Utils;
import org.openehealth.ipf.commons.ihe.ws.JaxWsClientFactory;
import org.openehealth.ipf.commons.ihe.ws.correlation.AsynchronyCorrelator;
import org.openehealth.ipf.platform.camel.ihe.ws.AbstractWsEndpoint;
import org.openehealth.ipf.platform.camel.ihe.ws.AbstractWsProducer;

class Iti55Producer
extends AbstractWsProducer<Hl7v3AuditDataset, Hl7v3WsTransactionConfiguration, String, String> {
    private static final String PROCESSING_MODE_PROPERTY = Iti55Producer.class.getName() + ".MODE";

    Iti55Producer(AbstractWsEndpoint<Hl7v3AuditDataset, Hl7v3WsTransactionConfiguration> endpoint, JaxWsClientFactory<Hl7v3AuditDataset> clientFactory) {
        super(endpoint, clientFactory, String.class, String.class);
    }

    protected void enrichRequestContext(Exchange exchange, WrappedMessageContext requestContext) {
        String requestString = (String)exchange.getIn().getBody(String.class);
        GPathResult requestXml = Hl7v3Utils.slurp((String)requestString);
        String processingMode = Iti55Utils.processingMode((GPathResult)requestXml);
        if ("D".equals(processingMode)) {
            if (exchange.getIn().getHeader(AbstractWsEndpoint.WSA_REPLYTO_HEADER_NAME, String.class) != null) {
                throw new RuntimeException("WS-Addressing asynchrony cannot be combined with the Deferred Response option");
            }
            if (Iti55Utils.deferredResponseUri((GPathResult)requestXml) == null) {
                throw new RuntimeException("missing deferred response URI in the request");
            }
            requestContext.put(AsynchronyCorrelator.FORCE_CORRELATION, (Object)Boolean.TRUE);
        }
        requestContext.put(PROCESSING_MODE_PROPERTY, (Object)processingMode);
    }

    protected String callService(Object client, String request) {
        BindingProvider bindingProvider = (BindingProvider)client;
        Map requestContext = bindingProvider.getRequestContext();
        return "D".equals(requestContext.get(PROCESSING_MODE_PROPERTY)) ? ((Iti55PortType)client).discoverPatientsDeferred(request) : ((Iti55PortType)client).discoverPatients(request);
    }

    protected String[] getAlternativeRequestKeys(Exchange exchange) {
        String requestString = (String)exchange.getIn().getBody(String.class);
        GPathResult requestXml = Hl7v3Utils.slurp((String)requestString);
        return new String[]{Iti55Utils.requestQueryId((GPathResult)requestXml)};
    }
}

