/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hl7v3;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.openehealth.ipf.commons.ihe.hl7v3.Hl7v3InteractionId;
import org.openehealth.ipf.commons.ihe.hl7v3.PDQV3;
import org.openehealth.ipf.commons.ihe.hl7v3.PIXV3;
import org.openehealth.ipf.commons.ihe.hl7v3.QED;
import org.openehealth.ipf.commons.ihe.hl7v3.XCPD;
import org.openehealth.ipf.commons.xml.CombinedXmlValidator;
import org.openehealth.ipf.platform.camel.core.adapter.ValidatorAdapter;

public abstract class PixPdqV3CamelValidators {
    private static final CombinedXmlValidator VALIDATOR = new CombinedXmlValidator();
    private static final Processor ITI_44_REQUEST_VALIDATOR = PixPdqV3CamelValidators.validatingProcessor((Hl7v3InteractionId)PIXV3.Interactions.ITI_44_PIX, true);
    private static final Processor ITI_44_RESPONSE_VALIDATOR = PixPdqV3CamelValidators.validatingProcessor((Hl7v3InteractionId)PIXV3.Interactions.ITI_44_PIX, false);
    private static final Processor ITI_45_REQUEST_VALIDATOR = PixPdqV3CamelValidators.validatingProcessor((Hl7v3InteractionId)PIXV3.Interactions.ITI_45, true);
    private static final Processor ITI_45_RESPONSE_VALIDATOR = PixPdqV3CamelValidators.validatingProcessor((Hl7v3InteractionId)PIXV3.Interactions.ITI_45, false);
    private static final Processor ITI_46_REQUEST_VALIDATOR = PixPdqV3CamelValidators.validatingProcessor((Hl7v3InteractionId)PIXV3.Interactions.ITI_46, true);
    private static final Processor ITI_46_RESPONSE_VALIDATOR = PixPdqV3CamelValidators.validatingProcessor((Hl7v3InteractionId)PIXV3.Interactions.ITI_46, false);
    private static final Processor ITI_47_REQUEST_VALIDATOR = PixPdqV3CamelValidators.validatingProcessor((Hl7v3InteractionId)PDQV3.Interactions.ITI_47, true);
    private static final Processor ITI_47_RESPONSE_VALIDATOR = PixPdqV3CamelValidators.validatingProcessor((Hl7v3InteractionId)PDQV3.Interactions.ITI_47, false);
    private static final Processor ITI_55_REQUEST_VALIDATOR = PixPdqV3CamelValidators.validatingProcessor((Hl7v3InteractionId)XCPD.Interactions.ITI_55, true);
    private static final Processor ITI_55_RESPONSE_VALIDATOR = PixPdqV3CamelValidators.validatingProcessor((Hl7v3InteractionId)XCPD.Interactions.ITI_55, false);
    private static final Processor ITI_56_REQUEST_VALIDATOR = PixPdqV3CamelValidators.validatingProcessor((Hl7v3InteractionId)XCPD.Interactions.ITI_56, true);
    private static final Processor ITI_56_RESPONSE_VALIDATOR = PixPdqV3CamelValidators.validatingProcessor((Hl7v3InteractionId)XCPD.Interactions.ITI_56, false);
    private static final Processor PCC_1_REQUEST_VALIDATOR = PixPdqV3CamelValidators.validatingProcessor((Hl7v3InteractionId)QED.Interactions.PCC_1, true);
    private static final Processor PCC_1_RESPONSE_VALIDATOR = PixPdqV3CamelValidators.validatingProcessor((Hl7v3InteractionId)QED.Interactions.PCC_1, false);

    public static Processor iti44RequestValidator() {
        return ITI_44_REQUEST_VALIDATOR;
    }

    public static Processor iti44ResponseValidator() {
        return ITI_44_RESPONSE_VALIDATOR;
    }

    public static Processor iti45RequestValidator() {
        return ITI_45_REQUEST_VALIDATOR;
    }

    public static Processor iti45ResponseValidator() {
        return ITI_45_RESPONSE_VALIDATOR;
    }

    public static Processor iti46RequestValidator() {
        return ITI_46_REQUEST_VALIDATOR;
    }

    public static Processor iti46ResponseValidator() {
        return ITI_46_RESPONSE_VALIDATOR;
    }

    public static Processor iti47RequestValidator() {
        return ITI_47_REQUEST_VALIDATOR;
    }

    public static Processor iti47ResponseValidator() {
        return ITI_47_RESPONSE_VALIDATOR;
    }

    public static Processor iti55RequestValidator() {
        return ITI_55_REQUEST_VALIDATOR;
    }

    public static Processor iti55ResponseValidator() {
        return ITI_55_RESPONSE_VALIDATOR;
    }

    public static Processor iti56RequestValidator() {
        return ITI_56_REQUEST_VALIDATOR;
    }

    public static Processor iti56ResponseValidator() {
        return ITI_56_RESPONSE_VALIDATOR;
    }

    public static Processor pcc1RequestValidator() {
        return PCC_1_REQUEST_VALIDATOR;
    }

    public static Processor pcc1ResponseValidator() {
        return PCC_1_RESPONSE_VALIDATOR;
    }

    private static Processor validatingProcessor(Hl7v3InteractionId interactionId, boolean request) {
        return exchange -> PixPdqV3CamelValidators.doValidation(exchange, interactionId, request);
    }

    private static void doValidation(Exchange exchange, Hl7v3InteractionId interactionId, boolean request) {
        if (!ValidatorAdapter.validationEnabled((Exchange)exchange)) {
            return;
        }
        String message = (String)exchange.getIn().getBody(String.class);
        VALIDATOR.validate(message, request ? interactionId.getRequestValidationProfile() : interactionId.getResponseValidationProfile());
    }
}

