/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hl7v3;

import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.openehealth.ipf.commons.ihe.hl7v3.translation.Hl7TranslatorV2toV3;
import org.openehealth.ipf.commons.ihe.hl7v3.translation.Hl7TranslatorV3toV2;

public abstract class PixPdqV3CamelTranslators {
    public static final String HL7V3_ORIGINAL_REQUEST_PROPERTY = "hl7v3.original.request";

    public static Processor translatorHL7v3toHL7v2(Hl7TranslatorV3toV2 translator) {
        return exchange -> {
            ca.uhn.hl7v2.model.Message initial = (ca.uhn.hl7v2.model.Message)exchange.getProperty(HL7V3_ORIGINAL_REQUEST_PROPERTY, ca.uhn.hl7v2.model.Message.class);
            String xmlText = (String)exchange.getIn().getMandatoryBody(String.class);
            exchange.setProperty(HL7V3_ORIGINAL_REQUEST_PROPERTY, (Object)xmlText);
            Message resultMessage = exchange.getMessage();
            resultMessage.getHeaders().putAll(exchange.getIn().getHeaders());
            resultMessage.setBody((Object)translator.translateV3toV2(xmlText, initial));
        };
    }

    public static Processor translatorHL7v2toHL7v3(Hl7TranslatorV2toV3 translator) {
        return exchange -> {
            String initial = (String)exchange.getProperty(HL7V3_ORIGINAL_REQUEST_PROPERTY, String.class);
            ca.uhn.hl7v2.model.Message msg = (ca.uhn.hl7v2.model.Message)exchange.getIn().getMandatoryBody(ca.uhn.hl7v2.model.Message.class);
            exchange.setProperty(HL7V3_ORIGINAL_REQUEST_PROPERTY, (Object)msg);
            Message resultMessage = exchange.getMessage();
            String charset = (String)exchange.getProperty("CamelCharsetName", (Object)"UTF-8", String.class);
            resultMessage.getHeaders().putAll(exchange.getIn().getHeaders());
            resultMessage.setBody((Object)translator.translateV2toV3(msg, initial, charset));
        };
    }
}

