/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hl7v3.iti55.deferredresponse;

import org.apache.camel.Exchange;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.openehealth.ipf.commons.ihe.hl7v3.Hl7v3WsTransactionConfiguration;
import org.openehealth.ipf.commons.ihe.hl7v3.audit.Hl7v3AuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v3.iti55.asyncresponse.Iti55DeferredResponsePortType;
import org.openehealth.ipf.commons.ihe.ws.JaxWsClientFactory;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.AbstractAuditInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;
import org.openehealth.ipf.platform.camel.ihe.ws.AbstractWsEndpoint;
import org.openehealth.ipf.platform.camel.ihe.ws.AbstractWsProducer;

public class Iti55DeferredResponseProducer
extends AbstractWsProducer<Hl7v3AuditDataset, Hl7v3WsTransactionConfiguration, String, String> {
    public Iti55DeferredResponseProducer(AbstractWsEndpoint<Hl7v3AuditDataset, Hl7v3WsTransactionConfiguration> endpoint, JaxWsClientFactory<Hl7v3AuditDataset> clientFactory) {
        super(endpoint, clientFactory, String.class, String.class);
    }

    protected void enrichRequestContext(Exchange exchange, WrappedMessageContext requestContext) {
        WsAuditDataset auditDataset;
        String requestMessageId = (String)exchange.getIn().getHeader("iti55.deferred.requestMessageId", String.class);
        if (requestMessageId != null) {
            RelatesToType relatesToHolder = new RelatesToType();
            relatesToHolder.setValue(requestMessageId);
            AddressingProperties apropos = new AddressingProperties();
            apropos.setRelatesTo(relatesToHolder);
            requestContext.put("javax.xml.ws.addressing.context", (Object)apropos);
        }
        if ((auditDataset = (WsAuditDataset)exchange.getIn().getHeader("iti55.deferred.auditDataset", WsAuditDataset.class)) != null) {
            requestContext.put(AbstractAuditInterceptor.DATASET_CONTEXT_KEY, (Object)auditDataset);
        }
    }

    protected String callService(Object client, String responseString) {
        return ((Iti55DeferredResponsePortType)client).receiveDeferredResponse(responseString);
    }
}

