/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hl7v3.iti55;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.namespace.QName;
import org.apache.camel.Message;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.openehealth.ipf.platform.camel.ihe.ws.AbstractWsEndpoint;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TtlHeaderUtils {
    private static final QName TTL_HEADER_QNAME = new QName("urn:ihe:iti:xcpd:2009", "CorrelationTimeToLive");

    private TtlHeaderUtils() {
        throw new IllegalStateException("cannot instantiate utility class");
    }

    public static Duration getTtl(Message message) {
        Node child;
        Object o;
        Map soapHeaders = CastUtils.cast((Map)((Map)message.getHeader(AbstractWsEndpoint.INCOMING_SOAP_HEADERS, Map.class)));
        if (soapHeaders != null && soapHeaders.containsKey(TTL_HEADER_QNAME) && (o = ((Header)soapHeaders.get(TTL_HEADER_QNAME)).getObject()) instanceof Element && (child = ((Element)o).getFirstChild()) instanceof Text) {
            String value = child.getNodeValue();
            try {
                return DatatypeFactory.newInstance().newDuration(value);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot parse TTL header " + value, e);
            }
        }
        return null;
    }

    public static void setTtl(Duration dura, Message message) {
        ArrayList soapHeaders = message.getHeader(AbstractWsEndpoint.OUTGOING_SOAP_HEADERS);
        if (soapHeaders == null) {
            soapHeaders = new ArrayList();
            message.setHeader(AbstractWsEndpoint.OUTGOING_SOAP_HEADERS, soapHeaders);
        }
        Header ttlHeader = new Header(TTL_HEADER_QNAME, (Object)dura.toString(), (DataBinding)TtlHeaderUtils.getStringDataBinding());
        if (soapHeaders instanceof Collection) {
            ((Collection)soapHeaders).add(ttlHeader);
        } else if (soapHeaders instanceof Map) {
            ((Map)((Object)soapHeaders)).put(TTL_HEADER_QNAME, ttlHeader);
        }
    }

    private static JAXBDataBinding getStringDataBinding() {
        try {
            return new JAXBDataBinding(new Class[]{String.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

