/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hl7v3.core.converters;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import net.ihe.gazelle.hl7v3.prpain201309UV02.PRPAIN201309UV02Type;
import net.ihe.gazelle.hl7v3.prpain201310UV02.PRPAIN201310UV02Type;
import org.apache.camel.Converter;
import org.openehealth.ipf.commons.ihe.hl7v3.core.requests.PixV3QueryRequest;
import org.openehealth.ipf.commons.ihe.hl7v3.core.responses.PixV3QueryResponse;
import org.openehealth.ipf.commons.ihe.hl7v3.core.transform.requests.PixV3QueryRequestTransformer;
import org.openehealth.ipf.commons.ihe.hl7v3.core.transform.responses.PixV3QueryResponseTransformer;
import org.openehealth.ipf.platform.camel.ihe.hl7v3.core.converters.Hl7v3ConvertersBase;

@Converter(generateLoader=true)
public class Iti45Converters
extends Hl7v3ConvertersBase {
    private static final PixV3QueryRequestTransformer SIMPLE_REQUEST_TRANSFORMER = new PixV3QueryRequestTransformer();
    private static final PixV3QueryResponseTransformer SIMPLE_RESPONSE_TRANSFORMER = new PixV3QueryResponseTransformer();
    private static final JAXBContext JAXB_CONTEXT_PRPA_REQUEST;
    private static final JAXBContext JAXB_CONTEXT_PRPA_RESPONSE;

    @Converter
    public static PRPAIN201309UV02Type xmlToPrpaRequest(String xml) throws JAXBException {
        return (PRPAIN201309UV02Type)Iti45Converters.fromXml(xml, JAXB_CONTEXT_PRPA_REQUEST);
    }

    @Converter
    public static String prpaRequestToXml(PRPAIN201309UV02Type request) throws JAXBException {
        return Iti45Converters.toXml(request, JAXB_CONTEXT_PRPA_REQUEST);
    }

    @Converter
    public static String xmlToSimpleRequest(PixV3QueryRequest simpleRequest) throws JAXBException {
        return Iti45Converters.prpaRequestToXml(SIMPLE_REQUEST_TRANSFORMER.toPrpa(simpleRequest));
    }

    @Converter
    public static PixV3QueryRequest simpleRequestToXml(String xml) throws JAXBException {
        return SIMPLE_REQUEST_TRANSFORMER.fromPrpa(Iti45Converters.xmlToPrpaRequest(xml));
    }

    @Converter
    public static PRPAIN201310UV02Type xmlToPrpaResponse(String xml) throws JAXBException {
        return (PRPAIN201310UV02Type)Iti45Converters.fromXml(xml, JAXB_CONTEXT_PRPA_RESPONSE);
    }

    @Converter
    public static String prpaResponseToXml(PRPAIN201310UV02Type response) throws JAXBException {
        return Iti45Converters.toXml(response, JAXB_CONTEXT_PRPA_RESPONSE);
    }

    @Converter
    public static String xmlToSimpleResponse(PixV3QueryResponse simpleResponse) throws JAXBException {
        return Iti45Converters.prpaResponseToXml(SIMPLE_RESPONSE_TRANSFORMER.toPrpa(simpleResponse));
    }

    @Converter
    public static PixV3QueryResponse simpleResponseToXml(String xml) throws JAXBException {
        return SIMPLE_RESPONSE_TRANSFORMER.fromPrpa(Iti45Converters.xmlToPrpaResponse(xml));
    }

    static {
        try {
            JAXB_CONTEXT_PRPA_REQUEST = JAXBContext.newInstance((Class[])new Class[]{PRPAIN201309UV02Type.class});
            JAXB_CONTEXT_PRPA_RESPONSE = JAXBContext.newInstance((Class[])new Class[]{PRPAIN201310UV02Type.class});
        }
        catch (JAXBException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

