/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hl7v3;

import groovy.xml.slurpersupport.GPathResult;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.xml.ws.handler.MessageContext;
import org.apache.camel.Exchange;
import org.apache.cxf.jaxws.context.WebServiceContextImpl;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v3.Hl7v3InteractionId;
import org.openehealth.ipf.commons.ihe.hl7v3.Hl7v3NakFactory;
import org.openehealth.ipf.commons.ihe.hl7v3.Hl7v3WsTransactionConfiguration;
import org.openehealth.ipf.commons.ihe.hl7v3.audit.Hl7v3AuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v3.audit.Hl7v3AuditStrategy;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.ws.AbstractWebService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHl7v3WebService
extends AbstractWebService {
    private static final Logger log = LoggerFactory.getLogger(AbstractHl7v3WebService.class);
    private final Hl7v3WsTransactionConfiguration wsTransactionConfiguration;

    public AbstractHl7v3WebService(Hl7v3InteractionId<? extends Hl7v3WsTransactionConfiguration> hl7v3InteractionId) {
        this.wsTransactionConfiguration = Objects.requireNonNull((Hl7v3WsTransactionConfiguration)hl7v3InteractionId.getWsTransactionConfiguration(), "TransactionConfiguration is null");
    }

    protected String doProcess(String requestString) {
        Exchange result = this.process(requestString);
        Exception exception = Exchanges.extractException((Exchange)result);
        if (exception != null) {
            log.info("HL7 v3 service failed", (Throwable)exception);
            return this.createNak(requestString, (Throwable)exception);
        }
        return (String)result.getMessage().getBody(String.class);
    }

    protected String createNak(String requestString, Throwable throwable) {
        return Hl7v3NakFactory.response((String)requestString, (Throwable)throwable, (String)this.wsTransactionConfiguration.getNakRootElementName(), (String)this.wsTransactionConfiguration.getControlActProcessCode(), (boolean)false, (boolean)this.wsTransactionConfiguration.isIncludeQuantities());
    }

    protected String createNak(GPathResult request, Throwable throwable) {
        return Hl7v3NakFactory.response((GPathResult)request, (Throwable)throwable, (String)this.wsTransactionConfiguration.getNakRootElementName(), (String)this.wsTransactionConfiguration.getControlActProcessCode(), (boolean)false, (boolean)this.wsTransactionConfiguration.isIncludeQuantities());
    }

    public Hl7v3WsTransactionConfiguration getWsTransactionConfiguration() {
        return this.wsTransactionConfiguration;
    }

    protected Hl7v3AuditDataset startAtnaAuditing(String requestString, Hl7v3AuditStrategy auditStrategy) {
        Hl7v3AuditDataset auditDataset = null;
        if (auditStrategy != null) {
            try {
                auditDataset = auditStrategy.createAuditDataset();
                MessageContext messageContext = new WebServiceContextImpl().getMessageContext();
                HttpServletRequest servletRequest = (HttpServletRequest)messageContext.get((Object)"HTTP.REQUEST");
                if (servletRequest != null) {
                    auditDataset.setRemoteAddress(servletRequest.getRemoteAddr());
                }
                auditDataset.setDestinationUserId((String)messageContext.get((Object)"org.apache.cxf.request.url"));
                AddressingProperties apropos = (AddressingProperties)messageContext.get((Object)"javax.xml.ws.addressing.context.inbound");
                if (apropos != null && apropos.getReplyTo() != null && apropos.getReplyTo().getAddress() != null) {
                    auditDataset.setSourceUserId(apropos.getReplyTo().getAddress().getValue());
                }
                if (auditDataset.getSourceUserId() == null) {
                    auditDataset.setSourceUserId("unknown");
                }
                if (this.wsTransactionConfiguration.isAuditRequestPayload()) {
                    auditDataset.setRequestPayload(requestString);
                }
                auditStrategy.enrichAuditDatasetFromRequest((AuditDataset)auditDataset, (Object)requestString, null);
            }
            catch (Exception e) {
                log.error("Phase 1 of server-side ATNA auditing failed", (Throwable)e);
            }
        }
        return auditDataset;
    }

    protected void finalizeAtnaAuditing(Object response, Hl7v3AuditStrategy auditStrategy, AuditContext auditContext, Hl7v3AuditDataset auditDataset) {
        if (auditStrategy != null) {
            auditStrategy.enrichAuditDatasetFromResponse(auditDataset, response, auditContext);
            auditStrategy.doAudit(auditContext, (AuditDataset)auditDataset);
        }
    }
}

