/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.producer;

import ca.uhn.hl7v2.model.Message;
import org.apache.camel.Exchange;
import org.openehealth.ipf.commons.ihe.hl7v2.tracing.MessageTracer;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorFactory;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.HL7v2Endpoint;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.producer.ProducerAdaptingInterceptor;

public class ProducerTracingInterceptor
extends InterceptorSupport<HL7v2Endpoint> {
    private final MessageTracer messageTracer;

    public ProducerTracingInterceptor(MessageTracer messageTracer) {
        this.messageTracer = messageTracer;
        this.addAfter(new String[]{ProducerAdaptingInterceptor.class.getName()});
    }

    public void process(Exchange exchange) throws Exception {
        Message msg = (Message)exchange.getIn().getMandatoryBody(Message.class);
        this.messageTracer.sendMessage(msg, ((HL7v2Endpoint)this.getEndpoint()).getEndpointUri(), (message, span) -> {
            exchange.getIn().setBody((Object)message, Message.class);
            this.getWrappedProcessor().process(exchange);
        });
    }

    public static class Factory
    implements InterceptorFactory<HL7v2Endpoint, ProducerTracingInterceptor> {
        private final MessageTracer messageTracer;

        public Factory(MessageTracer messageTracer) {
            this.messageTracer = messageTracer;
        }

        public ProducerTracingInterceptor getNewInstance() {
            return new ProducerTracingInterceptor(this.messageTracer);
        }
    }
}

