/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.producer;

import ca.uhn.hl7v2.model.Message;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.commons.lang3.ClassUtils;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.HL7v2Endpoint;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2AdaptingException;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2MarshalUtils;

public class ProducerAdaptingInterceptor
extends InterceptorSupport<HL7v2Endpoint> {
    private final String charsetName;

    public ProducerAdaptingInterceptor(String charsetName) {
        this.charsetName = charsetName;
    }

    public ProducerAdaptingInterceptor() {
        this(null);
    }

    public void process(Exchange exchange) throws Exception {
        Message msg;
        if (this.charsetName != null) {
            exchange.setProperty("CamelCharsetName", (Object)this.charsetName);
        }
        if ((msg = Hl7v2MarshalUtils.extractHapiMessage(exchange.getIn(), ProducerAdaptingInterceptor.characterSet((Exchange)exchange), ((HL7v2Endpoint)this.getEndpoint()).getHl7v2TransactionConfiguration().getParser())) == null) {
            throw new Hl7v2AdaptingException("Cannot create HL7v2 message from the given " + ClassUtils.getSimpleName((Object)exchange.getIn().getBody(), (String)"<null>"));
        }
        exchange.getIn().setBody((Object)msg);
        exchange.setPattern(ExchangePattern.InOut);
        this.getWrappedProcessor().process(exchange);
    }
}

