/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.consumer;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.Parser;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.openehealth.ipf.modules.hl7.message.MessageUtils;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.HL7v2Endpoint;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2AdaptingException;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2MarshalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerMarshalInterceptor
extends InterceptorSupport<HL7v2Endpoint> {
    private static final transient Logger LOG = LoggerFactory.getLogger(ConsumerMarshalInterceptor.class);

    public void process(Exchange exchange) throws Exception {
        ca.uhn.hl7v2.model.Message originalMessage = null;
        Parser parser = ((HL7v2Endpoint)this.getEndpoint()).getHl7v2TransactionConfiguration().getParser();
        Message inMessage = exchange.getIn();
        String originalString = (String)inMessage.getBody(String.class);
        boolean unmarshallingFailed = false;
        try {
            originalMessage = parser.parse(originalString);
        }
        catch (HL7Exception e) {
            unmarshallingFailed = true;
            LOG.error("Unmarshalling failed, message processing not possible", (Throwable)e);
            ca.uhn.hl7v2.model.Message nak = ((HL7v2Endpoint)this.getEndpoint()).getNakFactory().createDefaultNak(e);
            Exchanges.resultMessage((Exchange)exchange).setBody((Object)nak);
        }
        if (!unmarshallingFailed) {
            ca.uhn.hl7v2.model.Message copy;
            try {
                copy = MessageUtils.copy((ca.uhn.hl7v2.model.Message)originalMessage);
            }
            catch (Exception e) {
                copy = originalMessage;
            }
            inMessage.setBody((Object)originalMessage);
            inMessage.setHeader("ipf.hl7v2.OriginalMessageAdapter", (Object)copy);
            inMessage.setHeader("ipf.hl7v2.OriginalMessageString", (Object)originalString);
            try {
                this.getWrappedProcessor().process(exchange);
            }
            catch (Hl7v2AdaptingException mae) {
                throw mae;
            }
            catch (Exception e) {
                LOG.error("Message processing failed", (Throwable)e);
                Exchanges.resultMessage((Exchange)exchange).setBody((Object)((HL7v2Endpoint)this.getEndpoint()).getNakFactory().createNak(originalMessage, (Throwable)e));
            }
        }
        String s = Hl7v2MarshalUtils.marshalStandardTypes(Exchanges.resultMessage((Exchange)exchange), ConsumerMarshalInterceptor.characterSet((Exchange)exchange), parser);
        Exchanges.resultMessage((Exchange)exchange).setBody((Object)s);
    }
}

