/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.consumer;

import org.apache.camel.Exchange;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.HL7v2Endpoint;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.consumer.ConsumerMarshalInterceptor;

public class ConsumerSegmentEchoingInterceptor
extends InterceptorSupport<HL7v2Endpoint> {
    private final String segmentName;

    public ConsumerSegmentEchoingInterceptor(String segmentName) {
        this.segmentName = (String)Validate.notEmpty((CharSequence)segmentName);
        this.addBefore(new String[]{ConsumerMarshalInterceptor.class.getName()});
    }

    public void process(Exchange exchange) throws Exception {
        String response;
        int[] responseQpdBoundaries;
        String request = (String)exchange.getIn().getBody(String.class);
        int[] requestQpdBoundaries = this.getQpdBoundaries(request);
        this.getWrappedProcessor().process(exchange);
        if (requestQpdBoundaries != null && (responseQpdBoundaries = this.getQpdBoundaries(response = (String)Exchanges.resultMessage((Exchange)exchange).getBody(String.class))) != null) {
            Exchanges.resultMessage((Exchange)exchange).setBody((Object)new StringBuilder().append(response, 0, responseQpdBoundaries[0]).append(request, requestQpdBoundaries[0], requestQpdBoundaries[1]).append(response, responseQpdBoundaries[1], response.length()).toString());
        }
    }

    private int[] getQpdBoundaries(String s) {
        int[] nArray;
        int pos2;
        int pos1 = s.indexOf("\r" + this.segmentName + s.charAt(3));
        int n = pos2 = pos1 > 0 ? s.indexOf("\r", pos1 + 4) : -1;
        if (pos2 > 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = pos1;
            nArray = nArray2;
            nArray2[1] = pos2;
        } else {
            nArray = null;
        }
        return nArray;
    }
}

