/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept.consumer;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.HL7Exception;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.commons.lang3.ClassUtils;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.HL7v2Endpoint;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2AdaptingException;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.Hl7v2MarshalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerAdaptingInterceptor
extends InterceptorSupport<HL7v2Endpoint> {
    private static final transient Logger LOG = LoggerFactory.getLogger(ConsumerAdaptingInterceptor.class);
    public static final String ACK_TYPE_CODE_HEADER = "ipf.hl7v2.AckTypeCode";
    private final String charsetName;

    public ConsumerAdaptingInterceptor(String charsetName) {
        this.charsetName = charsetName;
    }

    public ConsumerAdaptingInterceptor() {
        this(null);
    }

    public void process(Exchange exchange) throws Exception {
        ca.uhn.hl7v2.model.Message msg;
        ca.uhn.hl7v2.model.Message originalMessage = (ca.uhn.hl7v2.model.Message)exchange.getIn().getHeader("ipf.hl7v2.OriginalMessageAdapter", ca.uhn.hl7v2.model.Message.class);
        try {
            this.getWrappedProcessor().process(exchange);
            Exception exception = Exchanges.extractException((Exchange)exchange);
            if (exception != null) {
                throw exception;
            }
        }
        catch (Exception e) {
            LOG.warn("Message processing failed", (Throwable)e);
            Exchanges.resultMessage((Exchange)exchange).setBody((Object)((HL7v2Endpoint)this.getEndpoint()).getNakFactory().createNak(originalMessage, (Throwable)e));
        }
        Message m = Exchanges.resultMessage((Exchange)exchange);
        Object body = m.getBody();
        if (this.charsetName != null) {
            exchange.setProperty("CamelCharsetName", (Object)this.charsetName);
        }
        if ((msg = Hl7v2MarshalUtils.extractHapiMessage(m, ConsumerAdaptingInterceptor.characterSet((Exchange)exchange), ((HL7v2Endpoint)this.getEndpoint()).getHl7v2TransactionConfiguration().getParser())) == null && body instanceof Throwable) {
            msg = ((HL7v2Endpoint)this.getEndpoint()).getNakFactory().createNak(originalMessage, (Throwable)body);
        }
        if (msg == null) {
            msg = this.analyseMagicHeader(m, originalMessage);
        }
        if (msg == null) {
            throw new Hl7v2AdaptingException("Cannot create HL7v2 message from " + ClassUtils.getSimpleName((Object)body, (String)"<null>") + " returned from the route");
        }
        m.setBody((Object)msg);
    }

    private ca.uhn.hl7v2.model.Message analyseMagicHeader(Message m, ca.uhn.hl7v2.model.Message originalMessage) throws HL7Exception, IOException {
        ca.uhn.hl7v2.model.Message ack;
        Object header = m.getHeader(ACK_TYPE_CODE_HEADER);
        if (header == null || !(header instanceof AcknowledgmentCode)) {
            return null;
        }
        if (header == AcknowledgmentCode.AA || header == AcknowledgmentCode.CA) {
            ack = ((HL7v2Endpoint)this.getEndpoint()).getNakFactory().createAck(originalMessage);
        } else {
            HL7Exception exception = new HL7Exception("HL7v2 processing failed", ((HL7v2Endpoint)this.getEndpoint()).getHl7v2TransactionConfiguration().getResponseErrorDefaultErrorCode());
            ack = ((HL7v2Endpoint)this.getEndpoint()).getNakFactory().createNak(originalMessage, exception, (AcknowledgmentCode)header);
        }
        return ack;
    }
}

