/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hl7v2.intercept;

import ca.uhn.hl7v2.model.Message;
import org.apache.camel.Exchange;
import org.openehealth.ipf.commons.ihe.hl7v2.Hl7v2TransactionConfiguration;
import org.openehealth.ipf.platform.camel.core.util.Exchanges;
import org.openehealth.ipf.platform.camel.ihe.core.InterceptorSupport;
import org.openehealth.ipf.platform.camel.ihe.hl7v2.HL7v2Endpoint;

public class AcceptanceInterceptorUtils {
    private AcceptanceInterceptorUtils() {
        throw new IllegalStateException("Helper class");
    }

    public static void processRequest(InterceptorSupport<HL7v2Endpoint> interceptor, Exchange exchange) throws Exception {
        Hl7v2TransactionConfiguration config = ((HL7v2Endpoint)interceptor.getEndpoint()).getHl7v2TransactionConfiguration();
        config.checkRequestAcceptance((Message)exchange.getIn().getBody(Message.class));
        interceptor.getWrappedProcessor().process(exchange);
    }

    public static void processResponse(InterceptorSupport<HL7v2Endpoint> interceptor, Exchange exchange) throws Exception {
        interceptor.getWrappedProcessor().process(exchange);
        Hl7v2TransactionConfiguration config = ((HL7v2Endpoint)interceptor.getEndpoint()).getHl7v2TransactionConfiguration();
        config.checkResponseAcceptance((Message)Exchanges.resultMessage((Exchange)exchange).getBody(Message.class));
    }
}

