/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.hl7v2;

import ca.uhn.hl7v2.parser.Parser;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import org.apache.camel.Message;
import org.apache.camel.WrappedFile;
import org.apache.camel.converter.IOConverter;

public class Hl7v2MarshalUtils {
    private Hl7v2MarshalUtils() {
        throw new IllegalStateException("Cannot instantiate helper class");
    }

    public static String marshalStandardTypes(Message message, String charset, Parser parser) throws Exception {
        Object body = message.getBody();
        if (!Hl7v2MarshalUtils.typeSupported(body)) {
            return null;
        }
        String s = null;
        if (body instanceof String) {
            s = (String)body;
        } else if (body instanceof ca.uhn.hl7v2.model.Message) {
            s = parser.encode((ca.uhn.hl7v2.model.Message)body);
        } else if (body instanceof File) {
            s = Hl7v2MarshalUtils.readFile(body, charset);
        } else if (body instanceof WrappedFile) {
            Object file = ((WrappedFile)body).getFile();
            if (file instanceof File) {
                s = Hl7v2MarshalUtils.readFile(file, charset);
            }
        } else {
            byte[] bytes = (byte[])message.getBody(byte[].class);
            if (bytes != null) {
                s = new String(bytes, charset);
            }
        }
        return s;
    }

    private static String readFile(Object file, String charset) throws Exception {
        byte[] bytes = IOConverter.toByteArray((File)((File)file));
        return new String(bytes, charset).replace('\n', '\r');
    }

    public static boolean typeSupported(Object body) {
        Class[] knownTypes;
        Class[] classArray = knownTypes = new Class[]{String.class, ca.uhn.hl7v2.model.Message.class, File.class, InputStream.class, ByteBuffer.class, byte[].class, WrappedFile.class};
        int n = knownTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class type = classArray[n2];
            try {
                type.cast(body);
                return true;
            }
            catch (ClassCastException classCastException) {
                ++n2;
            }
        }
        return false;
    }

    public static String convertBodyToString(Message message, String charset, boolean defragmentSegments) throws Exception {
        InputStream stream = (InputStream)message.getBody(InputStream.class);
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, charset));
        String s = IOConverter.toString((BufferedReader)br);
        s = s.replace('\n', '\r');
        if (defragmentSegments) {
            s = s.replace("\rADD" + s.charAt(3), "");
        }
        return s;
    }

    public static ca.uhn.hl7v2.model.Message extractHapiMessage(Message message, String charset, Parser parser) throws Exception {
        Object body = message.getBody();
        ca.uhn.hl7v2.model.Message msg = null;
        if (body instanceof ca.uhn.hl7v2.model.Message) {
            msg = (ca.uhn.hl7v2.model.Message)body;
        } else {
            String s = Hl7v2MarshalUtils.marshalStandardTypes(message, charset, parser);
            if (s != null) {
                s = s.replace('\n', '\r');
                msg = parser.parse(s);
            }
        }
        return msg;
    }
}

