/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.atna.util;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.queue.AuditMessageQueue;

public class CamelAuditMessageQueue
implements AuditMessageQueue {
    public static final String HEADER_NAMESPACE = "org.openehealth.ipf.platform.camel.ihe.atna";
    private CamelContext camelContext;
    private ProducerTemplate producerTemplate;
    private String endpointUriString;
    private URI endpointUriObject;
    private InetAddress destinationAddress;
    private int destinationPort;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setEndpointUri(String endpointUri) throws URISyntaxException, UnknownHostException {
        this.endpointUriString = endpointUri;
        this.endpointUriObject = new URI(endpointUri);
        String host = this.endpointUriObject.getHost();
        this.destinationAddress = InetAddress.getByName(host == null ? "0.0.0.0" : host);
        this.destinationPort = this.endpointUriObject.getPort();
    }

    public void init() {
        this.producerTemplate = this.camelContext.createProducerTemplate();
        this.producerTemplate.start();
    }

    public void destroy() {
        this.producerTemplate.stop();
    }

    public void audit(AuditContext auditContext, AuditMessage ... auditMessages) {
        for (AuditMessage m : auditMessages) {
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("org.openehealth.ipf.platform.camel.ihe.atna.destination.address", this.destinationAddress.getHostAddress());
            headers.put("org.openehealth.ipf.platform.camel.ihe.atna.destination.port", this.destinationPort);
            headers.put("X-IPF-ATNA-Timestamp", auditContext.getAuditMetadataProvider().getTimestamp());
            headers.put("X-IPF-ATNA-Hostname", auditContext.getAuditMetadataProvider().getHostname());
            headers.put("X-IPF-ATNA-ProcessID", auditContext.getAuditMetadataProvider().getProcessID());
            headers.put("X-IPF-ATNA-Application", auditContext.getSendingApplication());
            this.producerTemplate.sendBodyAndHeaders(this.endpointUriString, (Object)m, headers);
        }
    }

    private InetAddress getDestinationAddress() throws UnknownHostException {
        String host = this.endpointUriObject.getHost();
        return InetAddress.getByName(host == null ? "0.0.0.0" : host);
    }
}

