/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.platform.camel.ihe.atna.util;

import java.util.Collection;
import java.util.Map;
import org.apache.camel.support.DefaultComponent;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.core.config.ContextFacade;

public abstract class AuditConfiguration {
    public static AuditContext obtainAuditContext(DefaultComponent component, Map<String, Object> parameters) {
        Boolean audit = (Boolean)component.getAndRemoveParameter(parameters, "audit", Boolean.class, (Object)true);
        AuditContext auditContext = (AuditContext)component.resolveAndRemoveReferenceParameter(parameters, "auditContext", AuditContext.class);
        if (auditContext == null) {
            if (audit != null && !audit.booleanValue()) {
                auditContext = AuditContext.noAudit();
            } else {
                Collection beans = ContextFacade.getBeans(AuditContext.class);
                if (beans.size() == 1) {
                    auditContext = (AuditContext)beans.iterator().next();
                } else {
                    throw new AuditException("Must have exactly one bean of type " + AuditContext.class.getName() + ", but was : " + beans.size());
                }
            }
        }
        return auditContext;
    }
}

