/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.modules.hl7.message;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.Escaping;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.util.DeepCopy;
import ca.uhn.hl7v2.util.ReflectionUtil;
import ca.uhn.hl7v2.util.Terser;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.openehealth.ipf.modules.hl7.HL7v2Exception;
import org.openehealth.ipf.modules.hl7.parser.DefaultEscaping;

public class MessageUtils
implements GroovyObject {
    private static final DateTimeFormatter FMT;
    private static final Escaping ESCAPE;
    private static final Parser PARSER;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public MessageUtils() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        CallSite callSite = IndyInterface.bootstrap("getProperty", "INSTANCE", 0, DefaultEscaping.class);
        ESCAPE = IndyInterface.bootstrap("cast", "()", 0, callSite);
        CallSite callSite2 = IndyInterface.bootstrap("invoke", "ofPattern", 0, DateTimeFormatter.class, "yyyyMMddHHmmss");
        FMT = IndyInterface.bootstrap("cast", "()", 0, callSite2);
        CallSite config = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ParserConfiguration.class));
        Escaping escaping = ESCAPE;
        ScriptBytecodeAdapter.setProperty((Object)escaping, null, (Object)config, (String)"escaping");
        CallSite context = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, DefaultHapiContext.class));
        CallSite callSite3 = config;
        ScriptBytecodeAdapter.setProperty((Object)callSite3, null, (Object)context, (String)"parserConfiguration");
        CallSite callSite4 = IndyInterface.bootstrap("invoke", "getGenericParser", 0, context);
        PARSER = IndyInterface.bootstrap("cast", "()", 0, callSite4);
    }

    public static boolean atLeastVersion(Message msg, String targetVersion) {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "atLeastVersion", 0, MessageUtils.class, IndyInterface.bootstrap("getProperty", "version", 0, msg), targetVersion));
    }

    public static boolean atLeastVersion(String actualVersion, String targetVersion) {
        return DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "atLeastVersion", 0, MessageUtils.class, IndyInterface.bootstrap("invoke", "versionOf", 0, Version.class, actualVersion), IndyInterface.bootstrap("invoke", "versionOf", 0, Version.class, targetVersion)));
    }

    public static boolean atLeastVersion(Version actualVersion, Version targetVersion) {
        if (ScriptBytecodeAdapter.compareEqual((Object)actualVersion, null) || ScriptBytecodeAdapter.compareEqual((Object)targetVersion, null)) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, IllegalArgumentException.class, "unknown HL7 version"));
        }
        return !(ScriptBytecodeAdapter.compareEqual((Object)targetVersion, (Object)actualVersion) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isGreaterThan", 0, targetVersion, actualVersion)));
    }

    public static String hl7Now() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "format", 0, IndyInterface.bootstrap("invoke", "now", 0, ZonedDateTime.class), FMT));
    }

    public static String encodeHL7String(String s, Message msg) {
        CallSite callSite = IndyInterface.bootstrap("getProperty", "escaping", 1, IndyInterface.bootstrap("getProperty", "parserConfiguration", 1, IndyInterface.bootstrap("getProperty", "parser", 1, msg)));
        CallSite escaping = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : ESCAPE);
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "escape", 0, escaping, s, IndyInterface.bootstrap("invoke", "encodingCharacters", 0, MessageUtils.class, msg)));
    }

    public static String eventType(Message msg) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, Terser.class, IndyInterface.bootstrap("getProperty", "MSH", 0, msg), 9, false, true, true));
    }

    public static String triggerEvent(Message msg) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, Terser.class, IndyInterface.bootstrap("getProperty", "MSH", 0, msg), 9, false, 2, true));
    }

    public static String messageStructure(String messageType, String triggerEvent, String version, ModelClassFactory factory) {
        GStringImpl structName = new GStringImpl(new Object[]{messageType, triggerEvent}, new String[]{"", "_", ""});
        CallSite callSite = IndyInterface.bootstrap("invoke", "getMessageStructureForEvent", 0, factory, structName, IndyInterface.bootstrap("invoke", "versionOf", 0, Version.class, version));
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : structName);
    }

    public static String messageStructure(Message msg) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "messageStructure", 0, MessageUtils.class, IndyInterface.bootstrap("invoke", "eventType", 0, MessageUtils.class, msg), IndyInterface.bootstrap("invoke", "triggerEvent", 0, MessageUtils.class, msg), IndyInterface.bootstrap("getProperty", "version", 0, msg), IndyInterface.bootstrap("getProperty", "modelClassFactory", 0, IndyInterface.bootstrap("getProperty", "hapiContext", 0, IndyInterface.bootstrap("getProperty", "parser", 0, msg)))));
    }

    public static Message defaultNak(HL7Exception e, AcknowledgmentCode ackCode, String version, String sendingApplication, String sendingFacility, String msh9) {
        CallSite callSite = IndyInterface.bootstrap("getProperty", "message", 0, e);
        CallSite cause = IndyInterface.bootstrap("invoke", "encodeHL7String", 0, MessageUtils.class, IndyInterface.bootstrap("cast", "()", 0, callSite) != false ? callSite : IndyInterface.bootstrap("getProperty", "simpleName", 0, IndyInterface.bootstrap("getProperty", "class", 0, e)), null);
        CallSite now = IndyInterface.bootstrap("invoke", "hl7Now", 0, MessageUtils.class);
        CallSite cannedNak = IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{sendingApplication, sendingFacility, now, msh9, version}, new String[]{"MSH|^~\\&|", "|", "|unknown|unknown|", "||", "|unknown|T|", "|\r"}), new GStringImpl(new Object[]{cause}, new String[]{"MSA|AE|MsgIdUnknown|", "|\r"})), "ERR|\r");
        CallSite nak = IndyInterface.bootstrap("invoke", "parse", 0, PARSER, cannedNak);
        IndyInterface.bootstrap("invoke", "populateResponse", 0, e, nak, ackCode, false);
        return IndyInterface.bootstrap("cast", "()", 0, nak);
    }

    public static Message defaultNak(HL7Exception e, AcknowledgmentCode ackCode, String version) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "defaultNak", 0, MessageUtils.class, e, ackCode, version, "unknown", "unknown", "ACK"));
    }

    public static Message newMessage(HapiContext context, String event, String version) {
        if (IndyInterface.bootstrap("cast", "()", 0, version) != false) {
            CallSite list = IndyInterface.bootstrap("invoke", "tokenize", 0, event, "_");
            CallSite eventType = IndyInterface.bootstrap("invoke", "getAt", 0, list, false);
            CallSite triggerEvent = IndyInterface.bootstrap("invoke", "getAt", 0, list, true);
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "makeMessage", 0, MessageUtils.class, context, eventType, triggerEvent, version));
        }
        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, HL7Exception.class, "Must have valid version to create message"));
    }

    public static Message response(Message msg, String eventType, String triggerEvent) {
        if (IndyInterface.bootstrap("cast", "()", 0, triggerEvent) == false) {
            triggerEvent = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, Terser.class, IndyInterface.bootstrap("getProperty", "MSH", 0, msg), 9, false, 2, true));
        }
        CallSite v = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "version", 0, msg));
        CallSite out = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "makeMessage", 0, MessageUtils.class, IndyInterface.bootstrap("getProperty", "hapiContext", 0, IndyInterface.bootstrap("getProperty", "parser", 0, msg)), eventType, triggerEvent, v));
        CallSite mshIn = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "MSH", 0, msg));
        CallSite mshOut = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "MSH", 0, out));
        CallSite fieldSep = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, Terser.class, mshIn, true, false, true, true));
        CallSite encChars = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, Terser.class, mshIn, 2, false, true, true));
        CallSite procID = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, Terser.class, mshIn, 11, false, true, true));
        IndyInterface.bootstrap("invoke", "set", 0, Terser.class, mshOut, true, false, true, true, fieldSep);
        IndyInterface.bootstrap("invoke", "set", 0, Terser.class, mshOut, 2, false, true, true, encChars);
        IndyInterface.bootstrap("invoke", "set", 0, Terser.class, mshOut, 11, false, true, true, procID);
        IndyInterface.bootstrap("invoke", "set", 0, Terser.class, mshOut, 3, false, true, true, IndyInterface.bootstrap("invoke", "get", 0, Terser.class, mshIn, 5, false, true, true));
        IndyInterface.bootstrap("invoke", "set", 0, Terser.class, mshOut, 4, false, true, true, IndyInterface.bootstrap("invoke", "get", 0, Terser.class, mshIn, 6, false, true, true));
        IndyInterface.bootstrap("invoke", "set", 0, Terser.class, mshOut, 5, false, true, true, IndyInterface.bootstrap("invoke", "get", 0, Terser.class, mshIn, 3, false, true, true));
        IndyInterface.bootstrap("invoke", "set", 0, Terser.class, mshOut, 6, false, true, true, IndyInterface.bootstrap("invoke", "get", 0, Terser.class, mshIn, 4, false, true, true));
        if (ScriptBytecodeAdapter.isCase((Object)"MSA", (Object)IndyInterface.bootstrap("getProperty", "names", 0, out))) {
            IndyInterface.bootstrap("invoke", "set", 0, Terser.class, IndyInterface.bootstrap("getProperty", "MSA", 0, out), 2, false, true, true, IndyInterface.bootstrap("invoke", "get", 0, Terser.class, IndyInterface.bootstrap("getProperty", "MSH", 0, msg), 10, false, true, true));
        }
        return out;
    }

    public static Message empty(Message message) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newInstance", 0, MessageUtils.class, message, IndyInterface.bootstrap("getProperty", "modelClassFactory", 0, IndyInterface.bootstrap("getProperty", "hapiContext", 0, IndyInterface.bootstrap("getProperty", "parser", 0, message)))));
    }

    public static Message copyMessage(Message source) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("getProperty", "parser", 0, source), IndyInterface.bootstrap("invoke", "encode", 0, source)));
    }

    private static Group newInstance(Group group, ModelClassFactory factory) {
        public final class _newInstance_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _newInstance_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "size", 1, IndyInterface.bootstrap("getProperty", "parameterTypes", 0, it)), (Object)1) && ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "getAt", 0, IndyInterface.bootstrap("getProperty", "parameterTypes", 0, it), false), ModelClassFactory.class);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _newInstance_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        CallSite constructor = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "find", 1, IndyInterface.bootstrap("getProperty", "constructors", 1, IndyInterface.bootstrap("getProperty", "class", 1, group)), new _newInstance_closure1(MessageUtils.class, MessageUtils.class)));
        return IndyInterface.bootstrap("cast", "()", 0, DefaultTypeTransformation.booleanUnbox((Object)constructor) && DefaultTypeTransformation.booleanUnbox((Object)factory) ? IndyInterface.bootstrap("invoke", "newInstance", 0, constructor, factory) : IndyInterface.bootstrap("invoke", "newInstance", 0, MessageUtils.class, group));
    }

    private static Group newInstance(Group group) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newInstance", 0, IndyInterface.bootstrap("invoke", "getConstructor", 0, IndyInterface.bootstrap("getProperty", "class", 0, group))));
    }

    public static Message makeMessage(HapiContext context, String eventType, String triggerEvent, String version) {
        CallSite factory = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "modelClassFactory", 0, context));
        String structName = ScriptBytecodeAdapter.compareEqual((Object)eventType, (Object)"ACK") ? "ACK" : IndyInterface.bootstrap("invoke", "messageStructure", 0, MessageUtils.class, eventType, triggerEvent, version, factory);
        CallSite c = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getMessageClass", 0, factory, structName, version, true));
        if (IndyInterface.bootstrap("cast", "()", 0, c) == false) {
            CallSite e = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, HL7Exception.class, new GStringImpl(new Object[]{structName}, new String[]{"Can't instantiate message ", ""}), IndyInterface.bootstrap("getProperty", "UNSUPPORTED_MESSAGE_TYPE", 0, ErrorCode.class)));
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, HL7v2Exception.class, e));
        }
        CallSite msg = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "instantiateMessage", 0, ReflectionUtil.class, c, factory));
        IndyInterface.bootstrap("invoke", "setParser", 0, msg, IndyInterface.bootstrap("invoke", "getGenericParser", 0, context));
        IndyInterface.bootstrap("invoke", "initQuickstart", 0, msg, eventType, triggerEvent, "P");
        IndyInterface.bootstrap("invoke", "set", 0, Terser.class, IndyInterface.bootstrap("getProperty", "MSH", 0, msg), 11, false, 2, true, "T");
        return msg;
    }

    public static Segment newSegment(String name, Message message) {
        CallSite context = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getHapiContext", 0, IndyInterface.bootstrap("invoke", "getParser", 0, message)));
        CallSite c = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSegmentClass", 0, IndyInterface.bootstrap("getProperty", "modelClassFactory", 0, context), name, IndyInterface.bootstrap("getProperty", "version", 1, message)));
        if (IndyInterface.bootstrap("cast", "()", 0, c) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, HL7Exception.class, new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Segment ", ""})));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "instantiateStructure", 0, ReflectionUtil.class, c, message, IndyInterface.bootstrap("getProperty", "modelClassFactory", 0, context)));
    }

    public static Group newGroup(String name, Message message) {
        CallSite context = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getHapiContext", 0, IndyInterface.bootstrap("invoke", "getParser", 0, message)));
        CallSite c = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getGroupClass", 0, IndyInterface.bootstrap("getProperty", "modelClassFactory", 0, context), name, IndyInterface.bootstrap("getProperty", "version", 1, message)));
        if (IndyInterface.bootstrap("cast", "()", 0, c) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, HL7Exception.class, new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Group ", ""})));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "instantiateStructure", 0, ReflectionUtil.class, c, message, IndyInterface.bootstrap("getProperty", "modelClassFactory", 0, context)));
    }

    public static Primitive newPrimitive(String name, Message message, String value) {
        CallSite context = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getHapiContext", 0, IndyInterface.bootstrap("invoke", "getParser", 0, message)));
        CallSite c = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTypeClass", 0, IndyInterface.bootstrap("getProperty", "modelClassFactory", 0, context), name, IndyInterface.bootstrap("getProperty", "version", 1, message)));
        if (IndyInterface.bootstrap("cast", "()", 0, c) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, HL7Exception.class, new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Type ", ""})));
        }
        CallSite primitive = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newInstance", 0, c, ScriptBytecodeAdapter.createPojoWrapper((Object)((Object[])IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{message}), Object[].class)), Object[].class)));
        if (IndyInterface.bootstrap("cast", "()", 0, value) != false) {
            IndyInterface.bootstrap("invoke", "setValue", 0, primitive, value);
        }
        return primitive;
    }

    public static Composite newComposite(String name, Message message, Map map) {
        CallSite context = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getHapiContext", 0, IndyInterface.bootstrap("invoke", "getParser", 0, message)));
        CallSite c = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getTypeClass", 0, IndyInterface.bootstrap("getProperty", "modelClassFactory", 0, context), name, IndyInterface.bootstrap("getProperty", "version", 1, message)));
        if (IndyInterface.bootstrap("cast", "()", 0, c) == false) {
            throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, HL7Exception.class, new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Type ", ""})));
        }
        Reference composite = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "newInstance", 0, c, ScriptBytecodeAdapter.createPojoWrapper((Object)((Object[])IndyInterface.bootstrap("invoke", "asType", 0, ScriptBytecodeAdapter.createList((Object[])new Object[]{message}), Object[].class)), Object[].class))));
        public final class _newComposite_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference composite;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _newComposite_closure2(Object _outerInstance, Object _thisObject, Reference composite) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.composite = reference = composite;
            }

            public Object doCall(Object k, Object v) {
                CallSite type = IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getProperty(_newComposite_closure2.class, (Object)IndyInterface.bootstrap("cast", "()", 0, this.composite.get()), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{k}, new String[]{"", ""})))));
                if (type instanceof Primitive && v instanceof String) {
                    return IndyInterface.bootstrap("invoke", "setValue", 0, type, v);
                }
                return IndyInterface.bootstrap("invoke", "copy", 0, DeepCopy.class, v, type);
            }

            @Generated
            public Object call(Object k, Object v) {
                return IndyInterface.bootstrap("invoke", "doCall", 2, this, k, v);
            }

            @Generated
            public Composite getComposite() {
                return IndyInterface.bootstrap("cast", "()", 0, this.composite.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _newComposite_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        IndyInterface.bootstrap("invoke", "each", 1, map, new _newComposite_closure2(MessageUtils.class, MessageUtils.class, composite));
        return (Composite)composite.get();
    }

    public static Message load(HapiContext context, String resource) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "make", 0, MessageUtils.class, context, IndyInterface.bootstrap("getProperty", "text", 1, IndyInterface.bootstrap("invoke", "getResource", 0, IndyInterface.bootstrap("getProperty", "classLoader", 0, IndyInterface.bootstrap("invoke", "getClass", 0, MessageUtils.class)), resource))));
    }

    public static Message load(HapiContext context, String resource, String charset) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "make", 0, MessageUtils.class, context, IndyInterface.bootstrap("invoke", "getText", 1, IndyInterface.bootstrap("invoke", "getResource", 0, IndyInterface.bootstrap("getProperty", "classLoader", 0, IndyInterface.bootstrap("invoke", "getClass", 0, MessageUtils.class)), resource), charset)));
    }

    public static Message make(HapiContext context, InputStream stream) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "make", 0, MessageUtils.class, context, IndyInterface.bootstrap("getProperty", "text", 1, stream)));
    }

    public static Message make(HapiContext context, InputStream stream, String charset) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "make", 0, MessageUtils.class, context, IndyInterface.bootstrap("invoke", "getText", 1, stream, charset)));
    }

    public static Message make(HapiContext context, String message) {
        if (IndyInterface.bootstrap("cast", "()", 0, message) == false) {
            return IndyInterface.bootstrap("cast", "()", 0, null);
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parse", 0, IndyInterface.bootstrap("getProperty", "genericParser", 0, context), message));
    }

    private static EncodingCharacters encodingCharacters(Message msg) {
        if (ScriptBytecodeAdapter.compareNotEqual((Object)msg, null)) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getInstance", 0, EncodingCharacters.class, msg));
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, EncodingCharacters.class, ScriptBytecodeAdapter.createPojoWrapper((Object)Character.valueOf(((Character)((Object)IndyInterface.bootstrap("invoke", "asType", 0, "|", Character.class))).charValue()), Character.TYPE), "^~\\&"));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MessageUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }
}

