/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.modules.hl7.message;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.AbstractPrimitive;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.Escaping;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.ParserConfiguration;
import ca.uhn.hl7v2.util.DeepCopy;
import ca.uhn.hl7v2.util.ReflectionUtil;
import ca.uhn.hl7v2.util.Terser;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openehealth.ipf.modules.hl7.HL7v2Exception;
import org.openehealth.ipf.modules.hl7.parser.DefaultEscaping;

public class MessageUtils
implements GroovyObject {
    private static DateTimeFormatter FMT;
    private static final Escaping ESCAPE;
    private static final Parser PARSER;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public MessageUtils() {
        MetaClass metaClass;
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    static {
        Object object = MessageUtils.$getCallSiteArray()[0].call(ISODateTimeFormat.class);
        FMT = (DateTimeFormatter)ScriptBytecodeAdapter.castToType((Object)object, DateTimeFormatter.class);
        Object object2 = MessageUtils.$getCallSiteArray()[1].callGetProperty(DefaultEscaping.class);
        ESCAPE = (Escaping)ScriptBytecodeAdapter.castToType((Object)object2, Escaping.class);
        ParserConfiguration config = (ParserConfiguration)ScriptBytecodeAdapter.castToType((Object)MessageUtils.$getCallSiteArray()[2].callConstructor(ParserConfiguration.class), ParserConfiguration.class);
        MessageUtils.$getCallSiteArray()[3].call((Object)config, (Object)ESCAPE);
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)MessageUtils.$getCallSiteArray()[4].callConstructor(DefaultHapiContext.class), HapiContext.class);
        ParserConfiguration parserConfiguration = config;
        ScriptBytecodeAdapter.setProperty((Object)parserConfiguration, null, (Object)context, (String)"parserConfiguration");
        Object object3 = MessageUtils.$getCallSiteArray()[5].call((Object)context);
        PARSER = (Parser)ScriptBytecodeAdapter.castToType((Object)object3, Parser.class);
    }

    public static boolean atLeastVersion(Message msg, String targetVersion) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[6].callStatic(MessageUtils.class, callSiteArray[7].callGetProperty((Object)msg), (Object)targetVersion));
    }

    public static boolean atLeastVersion(String actualVersion, String targetVersion) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].callStatic(MessageUtils.class, callSiteArray[9].call(Version.class, (Object)actualVersion), callSiteArray[10].call(Version.class, (Object)targetVersion)));
    }

    public static boolean atLeastVersion(Version actualVersion, Version targetVersion) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)actualVersion, null) || ScriptBytecodeAdapter.compareEqual((Object)targetVersion, null)) {
                throw (Throwable)callSiteArray[11].callConstructor(IllegalArgumentException.class, (Object)"unknown HL7 version");
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)actualVersion, null) || ScriptBytecodeAdapter.compareEqual((Object)targetVersion, null)) {
            throw (Throwable)callSiteArray[12].callConstructor(IllegalArgumentException.class, (Object)"unknown HL7 version");
        }
        return !(ScriptBytecodeAdapter.compareEqual((Object)targetVersion, (Object)actualVersion) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call((Object)targetVersion, (Object)actualVersion)));
    }

    public static String hl7Now() {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[14].call(callSiteArray[15].call((Object)FMT, callSiteArray[16].callConstructor(DateTime.class)), (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{ScriptBytecodeAdapter.createRange((Object)0, (Object)7, (boolean)true), ScriptBytecodeAdapter.createRange((Object)9, (Object)14, (boolean)true)})));
    }

    public static String encodeHL7String(String s, Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        Object object = callSiteArray[17].callGetPropertySafe(callSiteArray[18].callGetPropertySafe(callSiteArray[19].callGetPropertySafe((Object)msg)));
        Escaping escaping = (Escaping)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : ESCAPE), Escaping.class);
        return ShortTypeHandling.castToString((Object)callSiteArray[20].call((Object)escaping, (Object)s, callSiteArray[21].callStatic(MessageUtils.class, (Object)msg)));
    }

    public static String pipeEncode(Type t) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[22].call((Object)t));
    }

    public static String pipeEncode(Segment s) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[23].call((Object)s));
    }

    public static String eventType(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[24].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[25].callGetProperty((Object)msg), (Object)9, (Object)0, (Object)1, (Object)1)));
    }

    public static String triggerEvent(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[26].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[27].callGetProperty((Object)msg), (Object)9, (Object)0, (Object)2, (Object)1)));
    }

    public static String messageStructure(String messageType, String triggerEvent, String version, ModelClassFactory factory) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        GStringImpl structName = new GStringImpl(new Object[]{messageType, triggerEvent}, new String[]{"", "_", ""});
        Object object = callSiteArray[28].call((Object)factory, (Object)structName, callSiteArray[29].call(Version.class, (Object)version));
        return ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : structName));
    }

    public static String messageStructure(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[30].callStatic(MessageUtils.class, callSiteArray[31].callStatic(MessageUtils.class, (Object)msg), callSiteArray[32].callStatic(MessageUtils.class, (Object)msg), callSiteArray[33].callGetProperty((Object)msg), callSiteArray[34].callGetProperty(callSiteArray[35].callGetProperty(callSiteArray[36].callGetProperty((Object)msg)))));
    }

    public static Message ack(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[37].call((Object)msg), Message.class);
    }

    public static Message defaultNak(HL7Exception e, AcknowledgmentCode ackCode, String version, String sendingApplication, String sendingFacility, String msh9) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        Object object = callSiteArray[39].callGetProperty((Object)e);
        Object cause = callSiteArray[38].callStatic(MessageUtils.class, DefaultTypeTransformation.booleanUnbox((Object)object) ? object : callSiteArray[40].callGetProperty(callSiteArray[41].callGetProperty((Object)e)), null);
        Object now = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2;
            now = object2 = callSiteArray[42].callStatic(MessageUtils.class);
        } else {
            String string = MessageUtils.hl7Now();
            now = string;
        }
        Object cannedNak = callSiteArray[43].call((Object)new GStringImpl(new Object[]{sendingApplication, sendingFacility, now, msh9, version}, new String[]{"MSH|^~\\&|", "|", "|unknown|unknown|", "||", "|unknown|T|", "|\r"}), (Object)new GStringImpl(new Object[]{cause}, new String[]{"MSA|AE|MsgIdUnknown|", "|\r"}));
        Object nak = callSiteArray[44].call((Object)PARSER, cannedNak);
        callSiteArray[45].call((Object)e, nak, (Object)ackCode, (Object)0);
        return (Message)ScriptBytecodeAdapter.castToType((Object)nak, Message.class);
    }

    public static Message defaultNak(HL7Exception e, AcknowledgmentCode ackCode, String version) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[46].callStatic(MessageUtils.class, ArrayUtil.createArray((Object)e, (Object)ackCode, (Object)version, (Object)"unknown", (Object)"unknown", (Object)"ACK")), Message.class);
    }

    public static Message newMessage(HapiContext context, String event, String version) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)version)) {
            Object list = callSiteArray[47].call((Object)event, (Object)"_");
            Object eventType = callSiteArray[48].call(list, (Object)0);
            Object triggerEvent = callSiteArray[49].call(list, (Object)1);
            return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].callStatic(MessageUtils.class, (Object)context, eventType, triggerEvent, (Object)version), Message.class);
        }
        throw (Throwable)callSiteArray[51].callConstructor(HL7Exception.class, (Object)"Must have valid version to create message");
    }

    public static Message response(Message msg, String eventType, String triggerEvent) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)triggerEvent)) {
            Object object = callSiteArray[52].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[53].callGetProperty((Object)msg), (Object)9, (Object)0, (Object)2, (Object)1));
            triggerEvent = ShortTypeHandling.castToString((Object)object);
        }
        String v = ShortTypeHandling.castToString((Object)callSiteArray[54].callGetProperty((Object)msg));
        Message out = (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[55].callStatic(MessageUtils.class, callSiteArray[56].callGetProperty(callSiteArray[57].callGetProperty((Object)msg)), (Object)eventType, (Object)triggerEvent, (Object)v), Message.class);
        Segment mshIn = (Segment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[58].callGetProperty((Object)msg), Segment.class);
        Segment mshOut = (Segment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[59].callGetProperty((Object)out), Segment.class);
        String fieldSep = ShortTypeHandling.castToString((Object)callSiteArray[60].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)1, (Object)0, (Object)1, (Object)1)));
        String encChars = ShortTypeHandling.castToString((Object)callSiteArray[61].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)2, (Object)0, (Object)1, (Object)1)));
        String procID = ShortTypeHandling.castToString((Object)callSiteArray[62].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)11, (Object)0, (Object)1, (Object)1)));
        callSiteArray[63].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)1, (Object)0, (Object)1, (Object)1, (Object)fieldSep));
        callSiteArray[64].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)2, (Object)0, (Object)1, (Object)1, (Object)encChars));
        callSiteArray[65].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)11, (Object)0, (Object)1, (Object)1, (Object)procID));
        callSiteArray[66].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)3, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[67].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)5, (Object)0, (Object)1, (Object)1))));
        callSiteArray[68].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)4, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[69].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)6, (Object)0, (Object)1, (Object)1))));
        callSiteArray[70].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)5, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[71].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)3, (Object)0, (Object)1, (Object)1))));
        callSiteArray[72].call(Terser.class, ArrayUtil.createArray((Object)mshOut, (Object)6, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[73].call(Terser.class, ArrayUtil.createArray((Object)mshIn, (Object)4, (Object)0, (Object)1, (Object)1))));
        if (ScriptBytecodeAdapter.isCase((Object)"MSA", (Object)callSiteArray[74].callGetProperty((Object)out))) {
            callSiteArray[75].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[76].callGetProperty((Object)out), (Object)2, (Object)0, (Object)1, (Object)1, (Object)callSiteArray[77].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[78].callGetProperty((Object)msg), (Object)10, (Object)0, (Object)1, (Object)1))));
        }
        return out;
    }

    public static Message empty(Message message) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[79].callStatic(MessageUtils.class, (Object)message, callSiteArray[80].callGetProperty(callSiteArray[81].callGetProperty(callSiteArray[82].callGetProperty((Object)message)))), Message.class);
    }

    public static Message copy(Message source) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[83].call(callSiteArray[84].callGetProperty((Object)source), callSiteArray[85].call((Object)source)), Message.class);
    }

    private static Group newInstance(Group group, ModelClassFactory factory) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        Constructor constructor = (Constructor)ScriptBytecodeAdapter.castToType((Object)callSiteArray[86].callSafe(callSiteArray[87].callGetPropertySafe(callSiteArray[88].callGetPropertySafe((Object)group)), (Object)new GeneratedClosure(MessageUtils.class, MessageUtils.class){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _newInstance_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _newInstance_closure1.$getCallSiteArray();
                if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callSafe(callSiteArray[1].callGetProperty(it)), (Object)1) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[2].call(callSiteArray[3].callGetProperty(it), (Object)0), ModelClassFactory.class);
                }
                return ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[4].callSafe(callSiteArray[5].callGetProperty(it)), (Object)1) && ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[6].call(callSiteArray[7].callGetProperty(it), (Object)0), ModelClassFactory.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _newInstance_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _newInstance_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "size";
                stringArray[1] = "parameterTypes";
                stringArray[2] = "getAt";
                stringArray[3] = "parameterTypes";
                stringArray[4] = "size";
                stringArray[5] = "parameterTypes";
                stringArray[6] = "getAt";
                stringArray[7] = "parameterTypes";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[8];
                _newInstance_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_newInstance_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _newInstance_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), Constructor.class);
        return (Group)ScriptBytecodeAdapter.castToType((Object)(DefaultTypeTransformation.booleanUnbox((Object)constructor) && DefaultTypeTransformation.booleanUnbox((Object)factory) ? callSiteArray[89].call((Object)constructor, (Object)factory) : callSiteArray[90].callStatic(MessageUtils.class, (Object)group)), Group.class);
    }

    private static Group newInstance(Group group) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Group)ScriptBytecodeAdapter.castToType((Object)callSiteArray[91].call(callSiteArray[92].callGetProperty((Object)group)), Group.class);
    }

    public static Message makeMessage(HapiContext context, String eventType, String triggerEvent, String version) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        ModelClassFactory factory = (ModelClassFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[93].callGetProperty((Object)context), ModelClassFactory.class);
        String structName = ScriptBytecodeAdapter.compareEqual((Object)eventType, (Object)"ACK") ? "ACK" : callSiteArray[94].callStatic(MessageUtils.class, (Object)eventType, (Object)triggerEvent, (Object)version, (Object)factory);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[95].call((Object)factory, (Object)structName, (Object)version, (Object)true));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            HL7Exception e = (HL7Exception)ScriptBytecodeAdapter.castToType((Object)callSiteArray[96].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{structName}, new String[]{"Can't instantiate message ", ""}), callSiteArray[97].callGetProperty(ErrorCode.class)), HL7Exception.class);
            throw (Throwable)callSiteArray[98].callConstructor(HL7v2Exception.class, (Object)e);
        }
        AbstractMessage msg = (AbstractMessage)ScriptBytecodeAdapter.castToType((Object)callSiteArray[99].call(ReflectionUtil.class, (Object)c, (Object)factory), AbstractMessage.class);
        callSiteArray[100].call((Object)msg, callSiteArray[101].call((Object)context));
        callSiteArray[102].call((Object)msg, (Object)eventType, (Object)triggerEvent, (Object)"P");
        callSiteArray[103].call(Terser.class, ArrayUtil.createArray((Object)callSiteArray[104].callGetProperty((Object)msg), (Object)11, (Object)0, (Object)2, (Object)1, (Object)"T"));
        return msg;
    }

    public static Segment newSegment(String name, Message message) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[105].call(callSiteArray[106].call((Object)message)), HapiContext.class);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[107].call(callSiteArray[108].callGetProperty((Object)context), (Object)name, callSiteArray[109].callGetPropertySafe((Object)message)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            throw (Throwable)callSiteArray[110].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Segment ", ""}));
        }
        return (Segment)ScriptBytecodeAdapter.castToType((Object)callSiteArray[111].call(ReflectionUtil.class, (Object)c, (Object)message, callSiteArray[112].callGetProperty((Object)context)), Segment.class);
    }

    public static Group newGroup(String name, Message message) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[113].call(callSiteArray[114].call((Object)message)), HapiContext.class);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[115].call(callSiteArray[116].callGetProperty((Object)context), (Object)name, callSiteArray[117].callGetPropertySafe((Object)message)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            throw (Throwable)callSiteArray[118].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Group ", ""}));
        }
        return (Group)ScriptBytecodeAdapter.castToType((Object)callSiteArray[119].call(ReflectionUtil.class, (Object)c, (Object)message, callSiteArray[120].callGetProperty((Object)context)), Group.class);
    }

    public static Primitive newPrimitive(String name, Message message, String value) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[121].call(callSiteArray[122].call((Object)message)), HapiContext.class);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[123].call(callSiteArray[124].callGetProperty((Object)context), (Object)name, callSiteArray[125].callGetPropertySafe((Object)message)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            throw (Throwable)callSiteArray[126].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Type ", ""}));
        }
        AbstractPrimitive primitive = (AbstractPrimitive)ScriptBytecodeAdapter.castToType((Object)callSiteArray[127].call((Object)c, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Object[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{message}), Object[].class)), Object[].class)), AbstractPrimitive.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)value)) {
            callSiteArray[128].call((Object)primitive, (Object)value);
        }
        return primitive;
    }

    public static Composite newComposite(String name, Message message, Map map) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        HapiContext context = (HapiContext)ScriptBytecodeAdapter.castToType((Object)callSiteArray[129].call(callSiteArray[130].call((Object)message)), HapiContext.class);
        Class c = ShortTypeHandling.castToClass((Object)callSiteArray[131].call(callSiteArray[132].callGetProperty((Object)context), (Object)name, callSiteArray[133].callGetPropertySafe((Object)message)));
        if (!DefaultTypeTransformation.booleanUnbox((Object)c)) {
            throw (Throwable)callSiteArray[134].callConstructor(HL7Exception.class, (Object)new GStringImpl(new Object[]{name}, new String[]{"Can't instantiate Type ", ""}));
        }
        Reference composite = new Reference((Object)((Composite)ScriptBytecodeAdapter.castToType((Object)callSiteArray[135].call((Object)c, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Object[])ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{message}), Object[].class)), Object[].class)), Composite.class)));
        callSiteArray[136].callSafe((Object)map, (Object)new GeneratedClosure(MessageUtils.class, MessageUtils.class, composite){
            private /* synthetic */ Reference composite;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _newComposite_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.composite = reference = composite;
            }

            public Object doCall(Object k, Object v) {
                CallSite[] callSiteArray = _newComposite_closure2.$getCallSiteArray();
                Type type = (Type)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.getProperty(_newComposite_closure2.class, (Object)this.composite.get(), (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{k}, new String[]{"", ""}))), Type.class);
                if (type instanceof Primitive && v instanceof String) {
                    return callSiteArray[0].call((Object)type, v);
                }
                return callSiteArray[1].call(DeepCopy.class, v, (Object)type);
            }

            public Object call(Object k, Object v) {
                CallSite[] callSiteArray = _newComposite_closure2.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, k, v);
            }

            public Composite getComposite() {
                CallSite[] callSiteArray = _newComposite_closure2.$getCallSiteArray();
                return (Composite)ScriptBytecodeAdapter.castToType((Object)this.composite.get(), Composite.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _newComposite_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "setValue";
                stringArray[1] = "copy";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _newComposite_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_newComposite_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _newComposite_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        return (Composite)composite.get();
    }

    public static String dump(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[137].call((Object)msg));
    }

    public static Message load(HapiContext context, String resource) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[138].callStatic(MessageUtils.class, (Object)context, callSiteArray[139].callGetPropertySafe(callSiteArray[140].call(callSiteArray[141].callGetProperty(callSiteArray[142].callStatic(MessageUtils.class)), (Object)resource))), Message.class);
    }

    public static Message load(HapiContext context, String resource, String charset) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[143].callStatic(MessageUtils.class, (Object)context, callSiteArray[144].callSafe(callSiteArray[145].call(callSiteArray[146].callGetProperty(callSiteArray[147].callStatic(MessageUtils.class)), (Object)resource), (Object)charset)), Message.class);
    }

    public static Message make(HapiContext context, InputStream stream) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[148].callStatic(MessageUtils.class, (Object)context, callSiteArray[149].callGetPropertySafe((Object)stream)), Message.class);
    }

    public static Message make(HapiContext context, InputStream stream, String charset) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[150].callStatic(MessageUtils.class, (Object)context, callSiteArray[151].callSafe((Object)stream, (Object)charset)), Message.class);
    }

    public static Message make(HapiContext context, String message) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)message)) {
            return (Message)ScriptBytecodeAdapter.castToType(null, Message.class);
        }
        return (Message)ScriptBytecodeAdapter.castToType((Object)callSiteArray[152].call(callSiteArray[153].callGetProperty((Object)context), (Object)message), Message.class);
    }

    private static EncodingCharacters encodingCharacters(Message msg) {
        CallSite[] callSiteArray = MessageUtils.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)msg, null)) {
            return (EncodingCharacters)ScriptBytecodeAdapter.castToType((Object)callSiteArray[154].call(EncodingCharacters.class, (Object)msg), EncodingCharacters.class);
        }
        return (EncodingCharacters)ScriptBytecodeAdapter.castToType((Object)callSiteArray[155].callConstructor(EncodingCharacters.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)Character.valueOf(DefaultTypeTransformation.charUnbox((Object)ScriptBytecodeAdapter.asType((Object)"|", Character.TYPE))), Character.TYPE), (Object)"^~\\&"), EncodingCharacters.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MessageUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "basicDateTimeNoMillis";
        stringArray[1] = "INSTANCE";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "setEscaping";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "getGenericParser";
        stringArray[6] = "atLeastVersion";
        stringArray[7] = "version";
        stringArray[8] = "atLeastVersion";
        stringArray[9] = "versionOf";
        stringArray[10] = "versionOf";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "isGreaterThan";
        stringArray[14] = "getAt";
        stringArray[15] = "print";
        stringArray[16] = "<$constructor$>";
        stringArray[17] = "escaping";
        stringArray[18] = "parserConfiguration";
        stringArray[19] = "parser";
        stringArray[20] = "escape";
        stringArray[21] = "encodingCharacters";
        stringArray[22] = "encode";
        stringArray[23] = "encode";
        stringArray[24] = "get";
        stringArray[25] = "MSH";
        stringArray[26] = "get";
        stringArray[27] = "MSH";
        stringArray[28] = "getMessageStructureForEvent";
        stringArray[29] = "versionOf";
        stringArray[30] = "messageStructure";
        stringArray[31] = "eventType";
        stringArray[32] = "triggerEvent";
        stringArray[33] = "version";
        stringArray[34] = "modelClassFactory";
        stringArray[35] = "hapiContext";
        stringArray[36] = "parser";
        stringArray[37] = "generateACK";
        stringArray[38] = "encodeHL7String";
        stringArray[39] = "message";
        stringArray[40] = "simpleName";
        stringArray[41] = "class";
        stringArray[42] = "hl7Now";
        stringArray[43] = "plus";
        stringArray[44] = "parse";
        stringArray[45] = "populateResponse";
        stringArray[46] = "defaultNak";
        stringArray[47] = "tokenize";
        stringArray[48] = "getAt";
        stringArray[49] = "getAt";
        stringArray[50] = "makeMessage";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "get";
        stringArray[53] = "MSH";
        stringArray[54] = "version";
        stringArray[55] = "makeMessage";
        stringArray[56] = "hapiContext";
        stringArray[57] = "parser";
        stringArray[58] = "MSH";
        stringArray[59] = "MSH";
        stringArray[60] = "get";
        stringArray[61] = "get";
        stringArray[62] = "get";
        stringArray[63] = "set";
        stringArray[64] = "set";
        stringArray[65] = "set";
        stringArray[66] = "set";
        stringArray[67] = "get";
        stringArray[68] = "set";
        stringArray[69] = "get";
        stringArray[70] = "set";
        stringArray[71] = "get";
        stringArray[72] = "set";
        stringArray[73] = "get";
        stringArray[74] = "names";
        stringArray[75] = "set";
        stringArray[76] = "MSA";
        stringArray[77] = "get";
        stringArray[78] = "MSH";
        stringArray[79] = "newInstance";
        stringArray[80] = "modelClassFactory";
        stringArray[81] = "hapiContext";
        stringArray[82] = "parser";
        stringArray[83] = "parse";
        stringArray[84] = "parser";
        stringArray[85] = "encode";
        stringArray[86] = "find";
        stringArray[87] = "constructors";
        stringArray[88] = "class";
        stringArray[89] = "newInstance";
        stringArray[90] = "newInstance";
        stringArray[91] = "newInstance";
        stringArray[92] = "class";
        stringArray[93] = "modelClassFactory";
        stringArray[94] = "messageStructure";
        stringArray[95] = "getMessageClass";
        stringArray[96] = "<$constructor$>";
        stringArray[97] = "UNSUPPORTED_MESSAGE_TYPE";
        stringArray[98] = "<$constructor$>";
        stringArray[99] = "instantiateMessage";
        stringArray[100] = "setParser";
        stringArray[101] = "getGenericParser";
        stringArray[102] = "initQuickstart";
        stringArray[103] = "set";
        stringArray[104] = "MSH";
        stringArray[105] = "getHapiContext";
        stringArray[106] = "getParser";
        stringArray[107] = "getSegmentClass";
        stringArray[108] = "modelClassFactory";
        stringArray[109] = "version";
        stringArray[110] = "<$constructor$>";
        stringArray[111] = "instantiateStructure";
        stringArray[112] = "modelClassFactory";
        stringArray[113] = "getHapiContext";
        stringArray[114] = "getParser";
        stringArray[115] = "getGroupClass";
        stringArray[116] = "modelClassFactory";
        stringArray[117] = "version";
        stringArray[118] = "<$constructor$>";
        stringArray[119] = "instantiateStructure";
        stringArray[120] = "modelClassFactory";
        stringArray[121] = "getHapiContext";
        stringArray[122] = "getParser";
        stringArray[123] = "getTypeClass";
        stringArray[124] = "modelClassFactory";
        stringArray[125] = "version";
        stringArray[126] = "<$constructor$>";
        stringArray[127] = "newInstance";
        stringArray[128] = "setValue";
        stringArray[129] = "getHapiContext";
        stringArray[130] = "getParser";
        stringArray[131] = "getTypeClass";
        stringArray[132] = "modelClassFactory";
        stringArray[133] = "version";
        stringArray[134] = "<$constructor$>";
        stringArray[135] = "newInstance";
        stringArray[136] = "each";
        stringArray[137] = "printStructure";
        stringArray[138] = "make";
        stringArray[139] = "text";
        stringArray[140] = "getResource";
        stringArray[141] = "classLoader";
        stringArray[142] = "getClass";
        stringArray[143] = "make";
        stringArray[144] = "getText";
        stringArray[145] = "getResource";
        stringArray[146] = "classLoader";
        stringArray[147] = "getClass";
        stringArray[148] = "make";
        stringArray[149] = "text";
        stringArray[150] = "make";
        stringArray[151] = "getText";
        stringArray[152] = "parse";
        stringArray[153] = "genericParser";
        stringArray[154] = "getInstance";
        stringArray[155] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[156];
        MessageUtils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(MessageUtils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = MessageUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

