/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v3.storage;

import org.openehealth.ipf.commons.ihe.hl7v3.storage.Hl7v3ContinuationStorage;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class SpringCacheHl7v3ContinuationStorage
implements Hl7v3ContinuationStorage {
    private static final String INTERACTIVE_CONTINUATION_CACHE = "interactiveHl7v3ContinuationCache";
    private final Cache cache;
    private static final String MESSAGE_SUFFIX = ".message";
    private static final String LAST_RESULT_NUMBER_SUFFIX = ".lastIndex";
    private static final String CONTINUATION_QUANTITY_SUFFIX = ".quantity";

    public SpringCacheHl7v3ContinuationStorage(CacheManager cacheManager) {
        this.cache = cacheManager.getCache(INTERACTIVE_CONTINUATION_CACHE);
    }

    @Override
    public void storeMessage(String key, String message) {
        this.cache.put((Object)(key + MESSAGE_SUFFIX), (Object)message);
    }

    @Override
    public String getMessage(String key) {
        return (String)this.cache.get((Object)(key + MESSAGE_SUFFIX), String.class);
    }

    @Override
    public void storeLastResultNumber(String key, int lastResultNumber) {
        this.cache.put((Object)(key + LAST_RESULT_NUMBER_SUFFIX), (Object)lastResultNumber);
    }

    @Override
    public int getLastResultNumber(String key) {
        Integer i = (Integer)this.cache.get((Object)(key + LAST_RESULT_NUMBER_SUFFIX), Integer.class);
        return i != null ? i : -1;
    }

    @Override
    public void storeContinuationQuantity(String key, int continuationQuantity) {
        this.cache.put((Object)(key + CONTINUATION_QUANTITY_SUFFIX), (Object)continuationQuantity);
    }

    @Override
    public int getContinuationQuantity(String key) {
        Integer i = (Integer)this.cache.get((Object)(key + CONTINUATION_QUANTITY_SUFFIX), Integer.class);
        return i != null ? i : -1;
    }

    @Override
    public boolean remove(String key) {
        this.cache.evict((Object)(key + LAST_RESULT_NUMBER_SUFFIX));
        this.cache.evict((Object)(key + CONTINUATION_QUANTITY_SUFFIX));
        if (this.cache.get((Object)(key + MESSAGE_SUFFIX)) != null) {
            this.cache.evict((Object)(key + MESSAGE_SUFFIX));
            return true;
        }
        return false;
    }
}

