/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v3.storage;

import java.io.Serializable;
import java.util.Objects;
import javax.cache.Cache;
import org.openehealth.ipf.commons.ihe.hl7v3.storage.Hl7v3ContinuationStorage;

public class JCacheHl7v3ContinuationStorage
implements Hl7v3ContinuationStorage {
    private final Cache<String, Serializable> cache;
    private static final String MESSAGE_SUFFIX = ".message";
    private static final String LAST_RESULT_NUMBER_SUFFIX = ".lastIndex";
    private static final String CONTINUATION_QUANTITY_SUFFIX = ".quantity";

    JCacheHl7v3ContinuationStorage(Cache<String, Serializable> cache) {
        Objects.requireNonNull(cache);
        this.cache = cache;
    }

    @Override
    public void storeMessage(String key, String message) {
        this.cache.put((Object)(key + MESSAGE_SUFFIX), (Object)message);
    }

    @Override
    public String getMessage(String key) {
        return (String)this.cache.get((Object)(key + MESSAGE_SUFFIX));
    }

    @Override
    public void storeLastResultNumber(String key, int lastResultNumber) {
        this.cache.put((Object)(key + LAST_RESULT_NUMBER_SUFFIX), (Object)lastResultNumber);
    }

    @Override
    public int getLastResultNumber(String key) {
        Serializable value = (Serializable)this.cache.get((Object)(key + LAST_RESULT_NUMBER_SUFFIX));
        return value != null ? (Integer)value : -1;
    }

    @Override
    public void storeContinuationQuantity(String key, int continuationQuantity) {
        this.cache.put((Object)(key + CONTINUATION_QUANTITY_SUFFIX), (Object)continuationQuantity);
    }

    @Override
    public int getContinuationQuantity(String key) {
        Serializable value = (Serializable)this.cache.get((Object)(key + CONTINUATION_QUANTITY_SUFFIX));
        return value != null ? (Integer)value : -1;
    }

    @Override
    public boolean remove(String key) {
        boolean exists = this.cache.get((Object)(key + MESSAGE_SUFFIX)) != null;
        this.cache.remove((Object)(key + LAST_RESULT_NUMBER_SUFFIX));
        this.cache.remove((Object)(key + CONTINUATION_QUANTITY_SUFFIX));
        this.cache.remove((Object)(key + MESSAGE_SUFFIX));
        return exists;
    }
}

