/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.storage;

import ca.uhn.hl7v2.model.Message;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openehealth.ipf.commons.ihe.hl7v2.storage.InteractiveContinuationStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class SpringCacheInteractiveContinuationStorage
implements InteractiveContinuationStorage {
    private static final transient Logger LOG = LoggerFactory.getLogger(SpringCacheInteractiveContinuationStorage.class);
    private static final String INTERACTIVE_CONTINUATION_CACHE = "interactiveHl7v2ContinuationCache";
    private final Cache cache;

    public SpringCacheInteractiveContinuationStorage(CacheManager cacheManager) {
        this.cache = cacheManager.getCache(INTERACTIVE_CONTINUATION_CACHE);
    }

    @Override
    public void put(String continuationPointer, String chainId, Message fragment) {
        InteractiveContinuationChain chain = (InteractiveContinuationChain)this.cache.get((Object)chainId, InteractiveContinuationChain.class);
        if (chain == null) {
            LOG.debug("Create chain for storage key {}", (Object)chainId);
            chain = new InteractiveContinuationChain();
            this.cache.put((Object)chainId, (Object)chain);
        }
        chain.put(continuationPointer, fragment);
    }

    @Override
    public Message get(String continuationPointer, String chainId) {
        InteractiveContinuationChain chain = (InteractiveContinuationChain)this.cache.get((Object)chainId, InteractiveContinuationChain.class);
        if (chain != null) {
            return chain.get(continuationPointer);
        }
        return null;
    }

    @Override
    public boolean delete(String chainId) {
        if (this.cache.get((Object)chainId) != null) {
            this.cache.evict((Object)chainId);
            return true;
        }
        return false;
    }

    private static class InteractiveContinuationChain
    implements Serializable {
        private final Map<String, Message> responseMessages = Collections.synchronizedMap(new HashMap());

        private InteractiveContinuationChain() {
        }

        public void put(String continuationPointer, Message message) {
            this.responseMessages.put(continuationPointer, message);
        }

        public Message get(String continuationPointer) {
            return this.responseMessages.get(continuationPointer);
        }
    }
}

