/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.storage;

import ca.uhn.hl7v2.model.Message;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.cache.Cache;
import org.openehealth.ipf.commons.ihe.hl7v2.storage.InteractiveContinuationStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCacheInteractiveContinuationStorage
implements InteractiveContinuationStorage {
    private static final Logger LOG = LoggerFactory.getLogger(JCacheInteractiveContinuationStorage.class);
    private final Cache<String, InteractiveContinuationChain> cache;

    public JCacheInteractiveContinuationStorage(Cache<String, InteractiveContinuationChain> ehcache) {
        Objects.requireNonNull(ehcache);
        this.cache = ehcache;
    }

    @Override
    public void put(String continuationPointer, String chainId, Message fragment) {
        InteractiveContinuationChain chain = (InteractiveContinuationChain)this.cache.get((Object)chainId);
        if (chain == null) {
            LOG.debug("Create chain for storage key {}", (Object)chainId);
            chain = new InteractiveContinuationChain();
            this.cache.put((Object)chainId, (Object)chain);
        }
        chain.put(continuationPointer, fragment);
    }

    @Override
    public Message get(String continuationPointer, String chainId) {
        InteractiveContinuationChain chain = (InteractiveContinuationChain)this.cache.get((Object)chainId);
        if (chain != null) {
            return chain.get(continuationPointer);
        }
        return null;
    }

    @Override
    public boolean delete(String chainId) {
        return this.cache.remove((Object)chainId);
    }

    public static class InteractiveContinuationChain
    implements Serializable {
        private final Map<String, Message> responseMessages = Collections.synchronizedMap(new HashMap());

        public void put(String continuationPointer, Message message) {
            this.responseMessages.put(continuationPointer, message);
        }

        public Message get(String continuationPointer) {
            return this.responseMessages.get(continuationPointer);
        }
    }
}

