/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.definitions;

import ca.uhn.hl7v2.Version;
import java.util.Collections;
import java.util.Map;
import org.openehealth.ipf.modules.hl7.parser.CustomModelClassFactory;

public final class CustomModelClassUtils {
    private static final String CUSTOM_EVENT_MAP_DIRECTORY = "org/openehealth/ipf/commons/ihe/hl7v2/";

    private CustomModelClassUtils() {
        throw new IllegalStateException("Utility class, cannot instantiate");
    }

    public static CustomModelClassFactory createFactory(String transaction, String version) {
        String packageName = String.format("%s.%s.%s", CustomModelClassUtils.class.getPackage().getName(), transaction, Version.versionOf((String)version).getPackageVersion());
        Map<String, String[]> map = Collections.singletonMap(version, new String[]{packageName});
        CustomModelClassFactory cmcf = new CustomModelClassFactory(map);
        cmcf.setEventMapDirectory(CUSTOM_EVENT_MAP_DIRECTORY);
        return cmcf;
    }
}

