/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.hl7v2.audit.iti64;

import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.CX;
import ca.uhn.hl7v2.model.v25.group.ADT_A43_PATIENT;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.PipeParser;
import java.util.Map;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategySupport;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.iti64.IHEPatientRecordChangeLinkBuilder;
import org.openehealth.ipf.commons.ihe.hl7v2.audit.iti64.Iti64AuditDataset;
import org.openehealth.ipf.commons.ihe.hl7v2.definitions.xpid.v25.message.ADT_A43;

public class Iti64AuditStrategy
extends AuditStrategySupport<Iti64AuditDataset> {
    private static final EncodingCharacters ENCODING_CHARACTERS = new EncodingCharacters('|', null);

    public Iti64AuditStrategy(boolean serverSide) {
        super(serverSide);
    }

    public Iti64AuditDataset enrichAuditDatasetFromRequest(Iti64AuditDataset auditDataset, Object msg, Map<String, Object> parameters) {
        CX[] mrgPatientIdList;
        ADT_A43 message = (ADT_A43)((Object)msg);
        ADT_A43_PATIENT patient = message.getPATIENT(0);
        CX[] pidPatientIdList = patient.getPID().getPatientIdentifierList();
        if (pidPatientIdList.length > 0) {
            auditDataset.setNewPatientId(PipeParser.encode((Type)pidPatientIdList[0], (EncodingCharacters)ENCODING_CHARACTERS));
            if (pidPatientIdList.length > 1) {
                auditDataset.setLocalPatientId(PipeParser.encode((Type)pidPatientIdList[1], (EncodingCharacters)ENCODING_CHARACTERS));
            }
        }
        if ((mrgPatientIdList = patient.getMRG().getMrg1_PriorPatientIdentifierList()).length > 0) {
            auditDataset.setPreviousPatientId(PipeParser.encode((Type)mrgPatientIdList[0], (EncodingCharacters)ENCODING_CHARACTERS));
            if (mrgPatientIdList.length > 1) {
                auditDataset.setSubsumedLocalPatientId(PipeParser.encode((Type)mrgPatientIdList[1], (EncodingCharacters)ENCODING_CHARACTERS));
            }
        }
        return auditDataset;
    }

    public AuditMessage[] makeAuditMessage(AuditContext auditContext, Iti64AuditDataset auditDataset) {
        IHEPatientRecordChangeLinkBuilder builder = new IHEPatientRecordChangeLinkBuilder(auditContext, auditDataset).setLocalPatientId(auditDataset);
        if (auditDataset.getSubsumedLocalPatientId() != null) {
            builder.setSubsumedLocalPatientId(auditDataset);
        }
        return builder.setNewPatientId(auditDataset).setPreviousPatientId(auditDataset).setSubmissionSet(auditDataset).getMessages();
    }

    public Iti64AuditDataset createAuditDataset() {
        return new Iti64AuditDataset(this.isServerSide());
    }
}

